# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Dict, List, Any


class AddCategoryRequest(TeaModel):
    def __init__(
        self,
        cate_name: str = None,
        parent_id: int = None,
        type: str = None,
    ):
        self.cate_name = cate_name
        self.parent_id = parent_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddCategoryResponseBodyCategory(TeaModel):
    def __init__(
        self,
        cate_id: int = None,
        cate_name: str = None,
        level: int = None,
        parent_id: int = None,
        type: str = None,
    ):
        self.cate_id = cate_id
        self.cate_name = cate_name
        self.level = level
        self.parent_id = parent_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.level is not None:
            result['Level'] = self.level
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddCategoryResponseBody(TeaModel):
    def __init__(
        self,
        category: AddCategoryResponseBodyCategory = None,
        request_id: str = None,
    ):
        self.category = category
        self.request_id = request_id

    def validate(self):
        if self.category:
            self.category.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            temp_model = AddCategoryResponseBodyCategory()
            self.category = temp_model.from_map(m['Category'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddCategoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddEditingProjectMaterialsRequest(TeaModel):
    def __init__(
        self,
        material_maps: str = None,
        project_id: str = None,
    ):
        # 素材ID
        self.material_maps = material_maps
        # 云剪辑工程ID
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.material_maps is not None:
            result['MaterialMaps'] = self.material_maps
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaterialMaps') is not None:
            self.material_maps = m.get('MaterialMaps')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class AddEditingProjectMaterialsResponseBodyLiveMaterials(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        live_url: str = None,
        stream_name: str = None,
    ):
        self.app_name = app_name
        self.domain_name = domain_name
        self.live_url = live_url
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.live_url is not None:
            result['LiveUrl'] = self.live_url
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('LiveUrl') is not None:
            self.live_url = m.get('LiveUrl')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class AddEditingProjectMaterialsResponseBodyMediaInfosFileInfoListFileBasicInfo(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        duration: str = None,
        file_name: str = None,
        file_size: str = None,
        file_status: str = None,
        file_type: str = None,
        file_url: str = None,
        format_name: str = None,
        height: str = None,
        region: str = None,
        width: str = None,
    ):
        # 码率
        self.bitrate = bitrate
        # 时长
        self.duration = duration
        # 文件名
        self.file_name = file_name
        # 文件大小（字节）
        self.file_size = file_size
        # 文件状态
        self.file_status = file_status
        # 文件类型
        self.file_type = file_type
        # 文件oss地址
        self.file_url = file_url
        # 封装格式
        self.format_name = format_name
        # 高
        self.height = height
        # 文件存储区域
        self.region = region
        # 宽
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class AddEditingProjectMaterialsResponseBodyMediaInfosFileInfoList(TeaModel):
    def __init__(
        self,
        file_basic_info: AddEditingProjectMaterialsResponseBodyMediaInfosFileInfoListFileBasicInfo = None,
    ):
        # 文件基础信息，包含时长，大小等
        self.file_basic_info = file_basic_info

    def validate(self):
        if self.file_basic_info:
            self.file_basic_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileBasicInfo') is not None:
            temp_model = AddEditingProjectMaterialsResponseBodyMediaInfosFileInfoListFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        return self


class AddEditingProjectMaterialsResponseBodyMediaInfosMediaBasicInfo(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        category: str = None,
        cover_url: str = None,
        create_time: str = None,
        deleted_time: str = None,
        description: str = None,
        input_url: str = None,
        media_id: str = None,
        media_tags: str = None,
        media_type: str = None,
        modified_time: str = None,
        snapshots: str = None,
        source: str = None,
        sprite_images: str = None,
        status: str = None,
        title: str = None,
        transcode_status: str = None,
        user_data: str = None,
    ):
        # 媒资业务类型
        self.business_type = business_type
        # 分类
        self.category = category
        # 封面地址
        self.cover_url = cover_url
        # 媒资创建时间
        self.create_time = create_time
        # 媒资删除时间
        self.deleted_time = deleted_time
        # 内容描述
        self.description = description
        # 待注册的媒资在相应系统中的地址
        self.input_url = input_url
        # MediaId
        self.media_id = media_id
        # 标签
        self.media_tags = media_tags
        # 媒资媒体类型
        self.media_type = media_type
        # 媒资修改时间
        self.modified_time = modified_time
        # 截图
        self.snapshots = snapshots
        # 来源
        self.source = source
        # 雪碧图
        self.sprite_images = sprite_images
        # 资源状态
        self.status = status
        # 标题
        self.title = title
        # 转码状态
        self.transcode_status = transcode_status
        # 用户数据
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.category is not None:
            result['Category'] = self.category
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.deleted_time is not None:
            result['DeletedTime'] = self.deleted_time
        if self.description is not None:
            result['Description'] = self.description
        if self.input_url is not None:
            result['InputURL'] = self.input_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_tags is not None:
            result['MediaTags'] = self.media_tags
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.snapshots is not None:
            result['Snapshots'] = self.snapshots
        if self.source is not None:
            result['Source'] = self.source
        if self.sprite_images is not None:
            result['SpriteImages'] = self.sprite_images
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        if self.transcode_status is not None:
            result['TranscodeStatus'] = self.transcode_status
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeletedTime') is not None:
            self.deleted_time = m.get('DeletedTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InputURL') is not None:
            self.input_url = m.get('InputURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaTags') is not None:
            self.media_tags = m.get('MediaTags')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Snapshots') is not None:
            self.snapshots = m.get('Snapshots')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SpriteImages') is not None:
            self.sprite_images = m.get('SpriteImages')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('TranscodeStatus') is not None:
            self.transcode_status = m.get('TranscodeStatus')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class AddEditingProjectMaterialsResponseBodyMediaInfos(TeaModel):
    def __init__(
        self,
        file_info_list: List[AddEditingProjectMaterialsResponseBodyMediaInfosFileInfoList] = None,
        media_basic_info: AddEditingProjectMaterialsResponseBodyMediaInfosMediaBasicInfo = None,
        media_id: str = None,
    ):
        # FileInfos
        self.file_info_list = file_info_list
        # BasicInfo
        self.media_basic_info = media_basic_info
        # 媒资ID
        self.media_id = media_id

    def validate(self):
        if self.file_info_list:
            for k in self.file_info_list:
                if k:
                    k.validate()
        if self.media_basic_info:
            self.media_basic_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FileInfoList'] = []
        if self.file_info_list is not None:
            for k in self.file_info_list:
                result['FileInfoList'].append(k.to_map() if k else None)
        if self.media_basic_info is not None:
            result['MediaBasicInfo'] = self.media_basic_info.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.file_info_list = []
        if m.get('FileInfoList') is not None:
            for k in m.get('FileInfoList'):
                temp_model = AddEditingProjectMaterialsResponseBodyMediaInfosFileInfoList()
                self.file_info_list.append(temp_model.from_map(k))
        if m.get('MediaBasicInfo') is not None:
            temp_model = AddEditingProjectMaterialsResponseBodyMediaInfosMediaBasicInfo()
            self.media_basic_info = temp_model.from_map(m['MediaBasicInfo'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class AddEditingProjectMaterialsResponseBody(TeaModel):
    def __init__(
        self,
        live_materials: List[AddEditingProjectMaterialsResponseBodyLiveMaterials] = None,
        media_infos: List[AddEditingProjectMaterialsResponseBodyMediaInfos] = None,
        project_id: str = None,
        project_materials: List[str] = None,
        request_id: str = None,
    ):
        self.live_materials = live_materials
        # 符合要求的媒资集合
        self.media_infos = media_infos
        self.project_id = project_id
        self.project_materials = project_materials
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.live_materials:
            for k in self.live_materials:
                if k:
                    k.validate()
        if self.media_infos:
            for k in self.media_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveMaterials'] = []
        if self.live_materials is not None:
            for k in self.live_materials:
                result['LiveMaterials'].append(k.to_map() if k else None)
        result['MediaInfos'] = []
        if self.media_infos is not None:
            for k in self.media_infos:
                result['MediaInfos'].append(k.to_map() if k else None)
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_materials is not None:
            result['ProjectMaterials'] = self.project_materials
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_materials = []
        if m.get('LiveMaterials') is not None:
            for k in m.get('LiveMaterials'):
                temp_model = AddEditingProjectMaterialsResponseBodyLiveMaterials()
                self.live_materials.append(temp_model.from_map(k))
        self.media_infos = []
        if m.get('MediaInfos') is not None:
            for k in m.get('MediaInfos'):
                temp_model = AddEditingProjectMaterialsResponseBodyMediaInfos()
                self.media_infos.append(temp_model.from_map(k))
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectMaterials') is not None:
            self.project_materials = m.get('ProjectMaterials')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddEditingProjectMaterialsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddEditingProjectMaterialsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddEditingProjectMaterialsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddFavoritePublicMediaRequest(TeaModel):
    def __init__(
        self,
        media_ids: str = None,
    ):
        self.media_ids = media_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_ids is not None:
            result['MediaIds'] = self.media_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaIds') is not None:
            self.media_ids = m.get('MediaIds')
        return self


class AddFavoritePublicMediaResponseBody(TeaModel):
    def __init__(
        self,
        ignored_list: List[str] = None,
        request_id: str = None,
    ):
        self.ignored_list = ignored_list
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ignored_list is not None:
            result['IgnoredList'] = self.ignored_list
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IgnoredList') is not None:
            self.ignored_list = m.get('IgnoredList')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddFavoritePublicMediaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddFavoritePublicMediaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddFavoritePublicMediaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddTemplateRequest(TeaModel):
    def __init__(
        self,
        config: str = None,
        cover_url: str = None,
        name: str = None,
        preview_media: str = None,
        source: str = None,
        status: str = None,
        type: str = None,
    ):
        # 参见Timeline模板Config文档
        self.config = config
        # 模板封面
        self.cover_url = cover_url
        # 模板名称
        self.name = name
        # 预览视频媒资id
        self.preview_media = preview_media
        # 模板创建来源，默认OpenAPI
        self.source = source
        # 模板状态
        self.status = status
        # 模板类型，取值范围：Timeline
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.cover_url is not None:
            result['CoverUrl'] = self.cover_url
        if self.name is not None:
            result['Name'] = self.name
        if self.preview_media is not None:
            result['PreviewMedia'] = self.preview_media
        if self.source is not None:
            result['Source'] = self.source
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('CoverUrl') is not None:
            self.cover_url = m.get('CoverUrl')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PreviewMedia') is not None:
            self.preview_media = m.get('PreviewMedia')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddTemplateResponseBodyTemplate(TeaModel):
    def __init__(
        self,
        config: str = None,
        cover_url: str = None,
        create_source: str = None,
        modified_source: str = None,
        name: str = None,
        preview_media: str = None,
        status: str = None,
        template_id: str = None,
        type: str = None,
    ):
        # 参见Timeline模板Config文档
        self.config = config
        # 模板封面
        self.cover_url = cover_url
        # 模板创建来源
        self.create_source = create_source
        # 模板修改来源
        self.modified_source = modified_source
        # 模板名称
        self.name = name
        # 预览视频媒资id
        self.preview_media = preview_media
        # 模板状态
        self.status = status
        # 模板Id
        self.template_id = template_id
        # 模板类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.cover_url is not None:
            result['CoverUrl'] = self.cover_url
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.modified_source is not None:
            result['ModifiedSource'] = self.modified_source
        if self.name is not None:
            result['Name'] = self.name
        if self.preview_media is not None:
            result['PreviewMedia'] = self.preview_media
        if self.status is not None:
            result['Status'] = self.status
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('CoverUrl') is not None:
            self.cover_url = m.get('CoverUrl')
        if m.get('CreateSource') is not None:
            self.create_source = m.get('CreateSource')
        if m.get('ModifiedSource') is not None:
            self.modified_source = m.get('ModifiedSource')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PreviewMedia') is not None:
            self.preview_media = m.get('PreviewMedia')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template: AddTemplateResponseBodyTemplate = None,
    ):
        # 请求ID
        self.request_id = request_id
        # 模板信息
        self.template = template

    def validate(self):
        if self.template:
            self.template.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template is not None:
            result['Template'] = self.template.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Template') is not None:
            temp_model = AddTemplateResponseBodyTemplate()
            self.template = temp_model.from_map(m['Template'])
        return self


class AddTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetMediaInfosRequest(TeaModel):
    def __init__(
        self,
        addition_type: str = None,
        media_ids: str = None,
    ):
        self.addition_type = addition_type
        self.media_ids = media_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addition_type is not None:
            result['AdditionType'] = self.addition_type
        if self.media_ids is not None:
            result['MediaIds'] = self.media_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdditionType') is not None:
            self.addition_type = m.get('AdditionType')
        if m.get('MediaIds') is not None:
            self.media_ids = m.get('MediaIds')
        return self


class BatchGetMediaInfosResponseBodyMediaInfosFileInfoListFileBasicInfo(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        duration: str = None,
        file_name: str = None,
        file_size: str = None,
        file_status: str = None,
        file_type: str = None,
        file_url: str = None,
        format_name: str = None,
        height: str = None,
        region: str = None,
        width: str = None,
    ):
        # 码率
        self.bitrate = bitrate
        # 时长
        self.duration = duration
        # 文件名
        self.file_name = file_name
        # 文件大小（字节）
        self.file_size = file_size
        # 文件状态
        self.file_status = file_status
        # 文件类型
        self.file_type = file_type
        # 文件oss地址
        self.file_url = file_url
        # 封装格式
        self.format_name = format_name
        # 高
        self.height = height
        # 文件存储区域
        self.region = region
        # 宽
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class BatchGetMediaInfosResponseBodyMediaInfosFileInfoList(TeaModel):
    def __init__(
        self,
        file_basic_info: BatchGetMediaInfosResponseBodyMediaInfosFileInfoListFileBasicInfo = None,
    ):
        # 文件基础信息，包含时长，大小等
        self.file_basic_info = file_basic_info

    def validate(self):
        if self.file_basic_info:
            self.file_basic_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileBasicInfo') is not None:
            temp_model = BatchGetMediaInfosResponseBodyMediaInfosFileInfoListFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        return self


class BatchGetMediaInfosResponseBodyMediaInfosMediaBasicInfo(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        category: str = None,
        cover_url: str = None,
        create_time: str = None,
        deleted_time: str = None,
        description: str = None,
        input_url: str = None,
        media_id: str = None,
        media_tags: str = None,
        media_type: str = None,
        modified_time: str = None,
        snapshots: str = None,
        source: str = None,
        sprite_images: str = None,
        status: str = None,
        title: str = None,
        transcode_status: str = None,
        user_data: str = None,
    ):
        # 媒资业务类型
        self.business_type = business_type
        # 分类
        self.category = category
        # 封面地址
        self.cover_url = cover_url
        # 媒资创建时间
        self.create_time = create_time
        # 媒资删除时间
        self.deleted_time = deleted_time
        # 内容描述
        self.description = description
        # 待注册的媒资在相应系统中的地址
        self.input_url = input_url
        # MediaId
        self.media_id = media_id
        # 标签
        self.media_tags = media_tags
        # 媒资媒体类型
        self.media_type = media_type
        # 媒资修改时间
        self.modified_time = modified_time
        # 截图
        self.snapshots = snapshots
        # 来源
        self.source = source
        # 雪碧图
        self.sprite_images = sprite_images
        # 资源状态
        self.status = status
        # 标题
        self.title = title
        # 转码状态
        self.transcode_status = transcode_status
        # 用户数据
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.category is not None:
            result['Category'] = self.category
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.deleted_time is not None:
            result['DeletedTime'] = self.deleted_time
        if self.description is not None:
            result['Description'] = self.description
        if self.input_url is not None:
            result['InputURL'] = self.input_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_tags is not None:
            result['MediaTags'] = self.media_tags
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.snapshots is not None:
            result['Snapshots'] = self.snapshots
        if self.source is not None:
            result['Source'] = self.source
        if self.sprite_images is not None:
            result['SpriteImages'] = self.sprite_images
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        if self.transcode_status is not None:
            result['TranscodeStatus'] = self.transcode_status
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeletedTime') is not None:
            self.deleted_time = m.get('DeletedTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InputURL') is not None:
            self.input_url = m.get('InputURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaTags') is not None:
            self.media_tags = m.get('MediaTags')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Snapshots') is not None:
            self.snapshots = m.get('Snapshots')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SpriteImages') is not None:
            self.sprite_images = m.get('SpriteImages')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('TranscodeStatus') is not None:
            self.transcode_status = m.get('TranscodeStatus')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class BatchGetMediaInfosResponseBodyMediaInfos(TeaModel):
    def __init__(
        self,
        file_info_list: List[BatchGetMediaInfosResponseBodyMediaInfosFileInfoList] = None,
        media_basic_info: BatchGetMediaInfosResponseBodyMediaInfosMediaBasicInfo = None,
        media_id: str = None,
    ):
        # FileInfos
        self.file_info_list = file_info_list
        # BasicInfo
        self.media_basic_info = media_basic_info
        # 媒资ID
        self.media_id = media_id

    def validate(self):
        if self.file_info_list:
            for k in self.file_info_list:
                if k:
                    k.validate()
        if self.media_basic_info:
            self.media_basic_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FileInfoList'] = []
        if self.file_info_list is not None:
            for k in self.file_info_list:
                result['FileInfoList'].append(k.to_map() if k else None)
        if self.media_basic_info is not None:
            result['MediaBasicInfo'] = self.media_basic_info.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.file_info_list = []
        if m.get('FileInfoList') is not None:
            for k in m.get('FileInfoList'):
                temp_model = BatchGetMediaInfosResponseBodyMediaInfosFileInfoList()
                self.file_info_list.append(temp_model.from_map(k))
        if m.get('MediaBasicInfo') is not None:
            temp_model = BatchGetMediaInfosResponseBodyMediaInfosMediaBasicInfo()
            self.media_basic_info = temp_model.from_map(m['MediaBasicInfo'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class BatchGetMediaInfosResponseBody(TeaModel):
    def __init__(
        self,
        media_infos: List[BatchGetMediaInfosResponseBodyMediaInfos] = None,
        request_id: str = None,
    ):
        # 符合要求的媒资集合
        self.media_infos = media_infos
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.media_infos:
            for k in self.media_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MediaInfos'] = []
        if self.media_infos is not None:
            for k in self.media_infos:
                result['MediaInfos'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.media_infos = []
        if m.get('MediaInfos') is not None:
            for k in m.get('MediaInfos'):
                temp_model = BatchGetMediaInfosResponseBodyMediaInfos()
                self.media_infos.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchGetMediaInfosResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchGetMediaInfosResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchGetMediaInfosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelFavoritePublicMediaRequest(TeaModel):
    def __init__(
        self,
        media_ids: str = None,
    ):
        self.media_ids = media_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_ids is not None:
            result['MediaIds'] = self.media_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaIds') is not None:
            self.media_ids = m.get('MediaIds')
        return self


class CancelFavoritePublicMediaResponseBody(TeaModel):
    def __init__(
        self,
        ignored_list: List[str] = None,
        request_id: str = None,
    ):
        self.ignored_list = ignored_list
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ignored_list is not None:
            result['IgnoredList'] = self.ignored_list
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IgnoredList') is not None:
            self.ignored_list = m.get('IgnoredList')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelFavoritePublicMediaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelFavoritePublicMediaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelFavoritePublicMediaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelUrlUploadJobsRequest(TeaModel):
    def __init__(
        self,
        job_ids: str = None,
        upload_urls: str = None,
    ):
        self.job_ids = job_ids
        self.upload_urls = upload_urls

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.upload_urls is not None:
            result['UploadUrls'] = self.upload_urls
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('UploadUrls') is not None:
            self.upload_urls = m.get('UploadUrls')
        return self


class CancelUrlUploadJobsResponseBody(TeaModel):
    def __init__(
        self,
        canceled_jobs: List[str] = None,
        non_exists: List[str] = None,
        request_id: str = None,
    ):
        self.canceled_jobs = canceled_jobs
        self.non_exists = non_exists
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.canceled_jobs is not None:
            result['CanceledJobs'] = self.canceled_jobs
        if self.non_exists is not None:
            result['NonExists'] = self.non_exists
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CanceledJobs') is not None:
            self.canceled_jobs = m.get('CanceledJobs')
        if m.get('NonExists') is not None:
            self.non_exists = m.get('NonExists')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelUrlUploadJobsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelUrlUploadJobsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelUrlUploadJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAuditRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        audit_content: str = None,
    ):
        self.app_id = app_id
        self.audit_content = audit_content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.audit_content is not None:
            result['AuditContent'] = self.audit_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AuditContent') is not None:
            self.audit_content = m.get('AuditContent')
        return self


class CreateAuditResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # RequestId
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAuditResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAuditResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAuditResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCustomTemplateRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        subtype: int = None,
        template_config: str = None,
        type: int = None,
    ):
        # 模板名称
        self.name = name
        # 模板子类型。
        self.subtype = subtype
        # 模板参数
        self.template_config = template_config
        # 模板类型。
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.subtype is not None:
            result['Subtype'] = self.subtype
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Subtype') is not None:
            self.subtype = m.get('Subtype')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateCustomTemplateResponseBodyCustomTemplate(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        is_default: bool = None,
        modified_time: str = None,
        status: str = None,
        subtype: str = None,
        template_config: str = None,
        template_id: str = None,
        template_name: str = None,
        type: int = None,
        type_name: str = None,
    ):
        # 模板创建时间
        self.create_time = create_time
        # 是否默认模板
        self.is_default = is_default
        # 模板修改时间
        self.modified_time = modified_time
        # 模板状态
        self.status = status
        # 模板子类型名称
        self.subtype = subtype
        # 模板参数
        self.template_config = template_config
        # 模板Id
        self.template_id = template_id
        # 模板名称
        self.template_name = template_name
        # 模板类型ID
        self.type = type
        # 模板类型名称
        self.type_name = type_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.status is not None:
            result['Status'] = self.status
        if self.subtype is not None:
            result['Subtype'] = self.subtype
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.type is not None:
            result['Type'] = self.type
        if self.type_name is not None:
            result['TypeName'] = self.type_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Subtype') is not None:
            self.subtype = m.get('Subtype')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('TypeName') is not None:
            self.type_name = m.get('TypeName')
        return self


class CreateCustomTemplateResponseBody(TeaModel):
    def __init__(
        self,
        custom_template: CreateCustomTemplateResponseBodyCustomTemplate = None,
        request_id: str = None,
    ):
        # 模板信息
        self.custom_template = custom_template
        # 请求ID
        self.request_id = request_id

    def validate(self):
        if self.custom_template:
            self.custom_template.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_template is not None:
            result['CustomTemplate'] = self.custom_template.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CustomTemplate') is not None:
            temp_model = CreateCustomTemplateResponseBodyCustomTemplate()
            self.custom_template = temp_model.from_map(m['CustomTemplate'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCustomTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCustomTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCustomTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEditingProjectRequest(TeaModel):
    def __init__(
        self,
        business_config: str = None,
        clips_param: str = None,
        cover_url: str = None,
        description: str = None,
        material_maps: str = None,
        project_type: str = None,
        template_id: str = None,
        timeline: str = None,
        title: str = None,
    ):
        # 工程业务配置。如果是直播剪辑工程必填OutputMediaConfig.StorageLocation,   Path 不填默认合成的直播片段存储在根路径下 OutputMediaTarget 不填默认oss-object，可以填vod-media 表示存储到vod  OutputMediaTarget 为vod-media 时，Path不生效。
        self.business_config = business_config
        # 模板素材参数
        self.clips_param = clips_param
        # 云剪辑工程封面
        self.cover_url = cover_url
        # 云剪辑工程描述
        self.description = description
        # 工程关联素材，多个素材以逗号（,）分隔；每种类型最多支持10个素材ID
        self.material_maps = material_maps
        # 剪辑工程类型，EditingProject: 普通剪辑工程；LiveEditingProject: 直播剪辑工程
        self.project_type = project_type
        # 模板Id
        self.template_id = template_id
        # 云剪辑工程时间线，Json格式
        self.timeline = timeline
        # 云剪辑工程标题
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_config is not None:
            result['BusinessConfig'] = self.business_config
        if self.clips_param is not None:
            result['ClipsParam'] = self.clips_param
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.description is not None:
            result['Description'] = self.description
        if self.material_maps is not None:
            result['MaterialMaps'] = self.material_maps
        if self.project_type is not None:
            result['ProjectType'] = self.project_type
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.timeline is not None:
            result['Timeline'] = self.timeline
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessConfig') is not None:
            self.business_config = m.get('BusinessConfig')
        if m.get('ClipsParam') is not None:
            self.clips_param = m.get('ClipsParam')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('MaterialMaps') is not None:
            self.material_maps = m.get('MaterialMaps')
        if m.get('ProjectType') is not None:
            self.project_type = m.get('ProjectType')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Timeline') is not None:
            self.timeline = m.get('Timeline')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class CreateEditingProjectResponseBodyProject(TeaModel):
    def __init__(
        self,
        business_config: str = None,
        business_status: str = None,
        clips_param: str = None,
        cover_url: str = None,
        create_source: str = None,
        create_time: str = None,
        description: str = None,
        duration: float = None,
        modified_source: str = None,
        modified_time: str = None,
        project_id: str = None,
        project_type: str = None,
        status: int = None,
        status_name: str = None,
        template_id: str = None,
        template_type: str = None,
        timeline: str = None,
        title: str = None,
    ):
        # 工程业务配置
        self.business_config = business_config
        # 业务状态，业务状态 /** 预约中 **/ RESERVING(0, "Reserving"), /** 预约取消 **/ RESERVATION_CANCELED(1, "ReservationCanceled"), /** 直播中 **/ BROADCASTING(3, "BroadCasting"), /** 加载失败 **/ LOADING_FAILED(4, "LoadingFailed"), /** 直播结束 **/ LIVE_FINISHED(5, "LiveFinished");
        self.business_status = business_status
        # 模板素材参数
        self.clips_param = clips_param
        # 云剪辑工程封面。
        self.cover_url = cover_url
        # 云剪辑工程创建方式  -OpenAPI  -AliyunConsole  -WebSDK -LiveEditingOpenAPI -LiveEditingConsole
        self.create_source = create_source
        # 云剪辑工程创建时间
        self.create_time = create_time
        # 云剪辑工程描述
        self.description = description
        # 云剪辑工程时长
        self.duration = duration
        # 云剪辑工程创建方式  -OpenAPI  -AliyunConsole  -WebSDK -LiveEditingOpenAPI -LiveEditingConsole
        self.modified_source = modified_source
        # 云剪辑工程编辑时间
        self.modified_time = modified_time
        # 云剪辑工程ID
        self.project_id = project_id
        # 剪辑工程类型，EditingProject: 普通剪辑工程；LiveEditingProject: 直播剪辑工程
        self.project_type = project_type
        # 云剪辑工程状态。  所有云剪辑工程状态列表：  -1:Draft  -2:Editing  -3:Producing  -4:Produced  -5:ProduceFailed  -7:Deleted
        self.status = status
        # 云剪辑状态名称，对应状态列表中状态名称。
        self.status_name = status_name
        # 模板Id
        self.template_id = template_id
        self.template_type = template_type
        # 云剪辑工程时间线，Json格式
        self.timeline = timeline
        # 云剪辑工程标题
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_config is not None:
            result['BusinessConfig'] = self.business_config
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        if self.clips_param is not None:
            result['ClipsParam'] = self.clips_param
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.modified_source is not None:
            result['ModifiedSource'] = self.modified_source
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_type is not None:
            result['ProjectType'] = self.project_type
        if self.status is not None:
            result['Status'] = self.status
        if self.status_name is not None:
            result['StatusName'] = self.status_name
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        if self.timeline is not None:
            result['Timeline'] = self.timeline
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessConfig') is not None:
            self.business_config = m.get('BusinessConfig')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        if m.get('ClipsParam') is not None:
            self.clips_param = m.get('ClipsParam')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateSource') is not None:
            self.create_source = m.get('CreateSource')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ModifiedSource') is not None:
            self.modified_source = m.get('ModifiedSource')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectType') is not None:
            self.project_type = m.get('ProjectType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusName') is not None:
            self.status_name = m.get('StatusName')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        if m.get('Timeline') is not None:
            self.timeline = m.get('Timeline')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class CreateEditingProjectResponseBody(TeaModel):
    def __init__(
        self,
        project: CreateEditingProjectResponseBodyProject = None,
        request_id: str = None,
    ):
        self.project = project
        # 请求ID
        self.request_id = request_id

    def validate(self):
        if self.project:
            self.project.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project is not None:
            result['Project'] = self.project.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Project') is not None:
            temp_model = CreateEditingProjectResponseBodyProject()
            self.project = temp_model.from_map(m['Project'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateEditingProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateEditingProjectResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEditingProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLiveRecordTemplateRequestRecordFormat(TeaModel):
    def __init__(
        self,
        cycle_duration: int = None,
        format: bytes = None,
        oss_object_prefix: bytes = None,
        slice_duration: int = None,
        slice_oss_object_prefix: bytes = None,
    ):
        self.cycle_duration = cycle_duration
        # 格式
        self.format = format
        # Oss对象名
        self.oss_object_prefix = oss_object_prefix
        # 切片时长
        self.slice_duration = slice_duration
        # 切片Oss对象名
        self.slice_oss_object_prefix = slice_oss_object_prefix

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cycle_duration is not None:
            result['CycleDuration'] = self.cycle_duration
        if self.format is not None:
            result['Format'] = self.format
        if self.oss_object_prefix is not None:
            result['OssObjectPrefix'] = self.oss_object_prefix
        if self.slice_duration is not None:
            result['SliceDuration'] = self.slice_duration
        if self.slice_oss_object_prefix is not None:
            result['SliceOssObjectPrefix'] = self.slice_oss_object_prefix
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CycleDuration') is not None:
            self.cycle_duration = m.get('CycleDuration')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('OssObjectPrefix') is not None:
            self.oss_object_prefix = m.get('OssObjectPrefix')
        if m.get('SliceDuration') is not None:
            self.slice_duration = m.get('SliceDuration')
        if m.get('SliceOssObjectPrefix') is not None:
            self.slice_oss_object_prefix = m.get('SliceOssObjectPrefix')
        return self


class CreateLiveRecordTemplateRequest(TeaModel):
    def __init__(
        self,
        name: bytes = None,
        record_format: List[CreateLiveRecordTemplateRequestRecordFormat] = None,
    ):
        # 资源名称
        self.name = name
        # 录制格式
        self.record_format = record_format

    def validate(self):
        if self.record_format:
            for k in self.record_format:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        result['RecordFormat'] = []
        if self.record_format is not None:
            for k in self.record_format:
                result['RecordFormat'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.record_format = []
        if m.get('RecordFormat') is not None:
            for k in m.get('RecordFormat'):
                temp_model = CreateLiveRecordTemplateRequestRecordFormat()
                self.record_format.append(temp_model.from_map(k))
        return self


class CreateLiveRecordTemplateShrinkRequest(TeaModel):
    def __init__(
        self,
        name: bytes = None,
        record_format_shrink: str = None,
    ):
        # 资源名称
        self.name = name
        # 录制格式
        self.record_format_shrink = record_format_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.record_format_shrink is not None:
            result['RecordFormat'] = self.record_format_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RecordFormat') is not None:
            self.record_format_shrink = m.get('RecordFormat')
        return self


class CreateLiveRecordTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template_id: bytes = None,
    ):
        self.request_id = request_id
        # 资源一级ID
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class CreateLiveRecordTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLiveRecordTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLiveRecordTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePipelineRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        priority: int = None,
        speed: str = None,
    ):
        # 管道名称
        self.name = name
        # 优先级，1-10，默认6。数值越大，优先级越高
        self.priority = priority
        # 管道类型。
        self.speed = speed

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.speed is not None:
            result['Speed'] = self.speed
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        return self


class CreatePipelineResponseBodyPipeline(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        modified_time: str = None,
        name: str = None,
        pipeline_id: str = None,
        priority: int = None,
        speed: str = None,
        status: str = None,
    ):
        # 模板创建时间
        self.create_time = create_time
        # 模板修改时间
        self.modified_time = modified_time
        # 管道名称
        self.name = name
        # 管道Id
        self.pipeline_id = pipeline_id
        # 管道优先级
        self.priority = priority
        # 管道类型
        self.speed = speed
        # 管道状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.name is not None:
            result['Name'] = self.name
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.speed is not None:
            result['Speed'] = self.speed
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreatePipelineResponseBody(TeaModel):
    def __init__(
        self,
        pipeline: CreatePipelineResponseBodyPipeline = None,
        request_id: str = None,
    ):
        # 管道信息
        self.pipeline = pipeline
        # 请求ID
        self.request_id = request_id

    def validate(self):
        if self.pipeline:
            self.pipeline.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline is not None:
            result['Pipeline'] = self.pipeline.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Pipeline') is not None:
            temp_model = CreatePipelineResponseBodyPipeline()
            self.pipeline = temp_model.from_map(m['Pipeline'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreatePipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreatePipelineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreatePipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUploadMediaRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        entity_id: str = None,
        file_info: str = None,
        media_meta_data: str = None,
        post_process_config: str = None,
        upload_target_config: str = None,
        user_data: str = None,
    ):
        self.app_id = app_id
        self.entity_id = entity_id
        self.file_info = file_info
        self.media_meta_data = media_meta_data
        self.post_process_config = post_process_config
        self.upload_target_config = upload_target_config
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.file_info is not None:
            result['FileInfo'] = self.file_info
        if self.media_meta_data is not None:
            result['MediaMetaData'] = self.media_meta_data
        if self.post_process_config is not None:
            result['PostProcessConfig'] = self.post_process_config
        if self.upload_target_config is not None:
            result['UploadTargetConfig'] = self.upload_target_config
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('FileInfo') is not None:
            self.file_info = m.get('FileInfo')
        if m.get('MediaMetaData') is not None:
            self.media_meta_data = m.get('MediaMetaData')
        if m.get('PostProcessConfig') is not None:
            self.post_process_config = m.get('PostProcessConfig')
        if m.get('UploadTargetConfig') is not None:
            self.upload_target_config = m.get('UploadTargetConfig')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class CreateUploadMediaResponseBody(TeaModel):
    def __init__(
        self,
        file_url: str = None,
        media_id: str = None,
        media_url: str = None,
        request_id: str = None,
        upload_address: str = None,
        upload_auth: str = None,
    ):
        self.file_url = file_url
        self.media_id = media_id
        self.media_url = media_url
        # RequestId
        self.request_id = request_id
        self.upload_address = upload_address
        self.upload_auth = upload_auth

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_url is not None:
            result['FileURL'] = self.file_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_url is not None:
            result['MediaURL'] = self.media_url
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.upload_address is not None:
            result['UploadAddress'] = self.upload_address
        if self.upload_auth is not None:
            result['UploadAuth'] = self.upload_auth
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileURL') is not None:
            self.file_url = m.get('FileURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaURL') is not None:
            self.media_url = m.get('MediaURL')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UploadAddress') is not None:
            self.upload_address = m.get('UploadAddress')
        if m.get('UploadAuth') is not None:
            self.upload_auth = m.get('UploadAuth')
        return self


class CreateUploadMediaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateUploadMediaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUploadMediaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUploadStreamRequest(TeaModel):
    def __init__(
        self,
        definition: str = None,
        file_extension: str = None,
        hdrtype: str = None,
        media_id: str = None,
        user_data: str = None,
    ):
        self.definition = definition
        self.file_extension = file_extension
        self.hdrtype = hdrtype
        self.media_id = media_id
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.file_extension is not None:
            result['FileExtension'] = self.file_extension
        if self.hdrtype is not None:
            result['HDRType'] = self.hdrtype
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('FileExtension') is not None:
            self.file_extension = m.get('FileExtension')
        if m.get('HDRType') is not None:
            self.hdrtype = m.get('HDRType')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class CreateUploadStreamResponseBody(TeaModel):
    def __init__(
        self,
        file_url: str = None,
        media_id: str = None,
        request_id: str = None,
        upload_address: str = None,
        upload_auth: str = None,
    ):
        self.file_url = file_url
        self.media_id = media_id
        self.request_id = request_id
        self.upload_address = upload_address
        self.upload_auth = upload_auth

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_url is not None:
            result['FileURL'] = self.file_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.upload_address is not None:
            result['UploadAddress'] = self.upload_address
        if self.upload_auth is not None:
            result['UploadAuth'] = self.upload_auth
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileURL') is not None:
            self.file_url = m.get('FileURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UploadAddress') is not None:
            self.upload_address = m.get('UploadAddress')
        if m.get('UploadAuth') is not None:
            self.upload_auth = m.get('UploadAuth')
        return self


class CreateUploadStreamResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateUploadStreamResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUploadStreamResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCategoryRequest(TeaModel):
    def __init__(
        self,
        cate_id: int = None,
    ):
        self.cate_id = cate_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        return self


class DeleteCategoryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCategoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomTemplateRequest(TeaModel):
    def __init__(
        self,
        template_id: str = None,
    ):
        # 模板ID
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteCustomTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        # 请求ID
        self.request_id = request_id
        # 是否成功
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteCustomTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCustomTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEditingProjectMaterialsRequest(TeaModel):
    def __init__(
        self,
        material_ids: str = None,
        material_type: str = None,
        project_id: str = None,
    ):
        # 素材ID
        self.material_ids = material_ids
        # 素材类型
        self.material_type = material_type
        # 云剪辑工程ID
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.material_ids is not None:
            result['MaterialIds'] = self.material_ids
        if self.material_type is not None:
            result['MaterialType'] = self.material_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaterialIds') is not None:
            self.material_ids = m.get('MaterialIds')
        if m.get('MaterialType') is not None:
            self.material_type = m.get('MaterialType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteEditingProjectMaterialsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEditingProjectMaterialsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEditingProjectMaterialsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEditingProjectMaterialsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEditingProjectsRequest(TeaModel):
    def __init__(
        self,
        project_ids: str = None,
    ):
        # 云剪辑工程ID。支持多个云剪辑工程，以逗号分隔。
        self.project_ids = project_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_ids is not None:
            result['ProjectIds'] = self.project_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectIds') is not None:
            self.project_ids = m.get('ProjectIds')
        return self


class DeleteEditingProjectsResponseBody(TeaModel):
    def __init__(
        self,
        ignored_list: str = None,
        request_id: str = None,
    ):
        self.ignored_list = ignored_list
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ignored_list is not None:
            result['IgnoredList'] = self.ignored_list
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IgnoredList') is not None:
            self.ignored_list = m.get('IgnoredList')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEditingProjectsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEditingProjectsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEditingProjectsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveTranscodeJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        # 模板Id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteLiveTranscodeJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # 请求ID
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveTranscodeJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveTranscodeJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveTranscodeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveTranscodeTemplateRequest(TeaModel):
    def __init__(
        self,
        template_id: str = None,
    ):
        # 模板Id
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteLiveTranscodeTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # 请求ID
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveTranscodeTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLiveTranscodeTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveTranscodeTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMediaInfosRequest(TeaModel):
    def __init__(
        self,
        input_urls: str = None,
        media_ids: str = None,
    ):
        # 待注册的媒资在相应系统中的地址
        self.input_urls = input_urls
        # ICE 媒资ID
        self.media_ids = media_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_urls is not None:
            result['InputURLs'] = self.input_urls
        if self.media_ids is not None:
            result['MediaIds'] = self.media_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InputURLs') is not None:
            self.input_urls = m.get('InputURLs')
        if m.get('MediaIds') is not None:
            self.media_ids = m.get('MediaIds')
        return self


class DeleteMediaInfosResponseBody(TeaModel):
    def __init__(
        self,
        ignored_list: List[str] = None,
        request_id: str = None,
    ):
        # 出现获取错误的ID或inputUr
        self.ignored_list = ignored_list
        # 请求ID
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ignored_list is not None:
            result['IgnoredList'] = self.ignored_list
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IgnoredList') is not None:
            self.ignored_list = m.get('IgnoredList')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMediaInfosResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMediaInfosResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMediaInfosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMediaProducingJobsRequest(TeaModel):
    def __init__(
        self,
        job_ids: str = None,
    ):
        self.job_ids = job_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        return self


class DeleteMediaProducingJobsResponseBody(TeaModel):
    def __init__(
        self,
        ignore_list: str = None,
        request_id: str = None,
    ):
        self.ignore_list = ignore_list
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ignore_list is not None:
            result['IgnoreList'] = self.ignore_list
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IgnoreList') is not None:
            self.ignore_list = m.get('IgnoreList')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMediaProducingJobsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteMediaProducingJobsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMediaProducingJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePipelineRequest(TeaModel):
    def __init__(
        self,
        pipeline_id: str = None,
    ):
        # 管道ID
        self.pipeline_id = pipeline_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        return self


class DeletePipelineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
    ):
        # 请求ID
        self.request_id = request_id
        # 是否成功
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeletePipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeletePipelineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePlayInfoRequest(TeaModel):
    def __init__(
        self,
        file_urls: str = None,
        media_id: str = None,
    ):
        self.file_urls = file_urls
        self.media_id = media_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_urls is not None:
            result['FileURLs'] = self.file_urls
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileURLs') is not None:
            self.file_urls = m.get('FileURLs')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class DeletePlayInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # RequestId
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePlayInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeletePlayInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePlayInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSmartJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        # 任务id，多个任务id用英文逗号分割
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteSmartJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # RequestId
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSmartJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSmartJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSmartJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTemplateRequest(TeaModel):
    def __init__(
        self,
        template_ids: str = None,
    ):
        # 模板id，多个id用英文逗号隔开
        self.template_ids = template_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_ids is not None:
            result['TemplateIds'] = self.template_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TemplateIds') is not None:
            self.template_ids = m.get('TemplateIds')
        return self


class DeleteTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # 请求ID
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBizUserTypeRequest(TeaModel):
    def __init__(
        self,
        region: str = None,
    ):
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class DescribeBizUserTypeResponseBodyData(TeaModel):
    def __init__(
        self,
        profile: str = None,
    ):
        self.profile = profile

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.profile is not None:
            result['Profile'] = self.profile
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        return self


class DescribeBizUserTypeResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribeBizUserTypeResponseBodyData] = None,
        request_id: str = None,
    ):
        self.data = data
        # Id
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeBizUserTypeResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBizUserTypeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeBizUserTypeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBizUserTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFilterConfigsRequest(TeaModel):
    def __init__(
        self,
        type: str = None,
    ):
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeFilterConfigsResponseBodyFilterConfigs(TeaModel):
    def __init__(
        self,
        filter_name: str = None,
        item_configs: str = None,
        type: str = None,
    ):
        self.filter_name = filter_name
        self.item_configs = item_configs
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.filter_name is not None:
            result['FilterName'] = self.filter_name
        if self.item_configs is not None:
            result['ItemConfigs'] = self.item_configs
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FilterName') is not None:
            self.filter_name = m.get('FilterName')
        if m.get('ItemConfigs') is not None:
            self.item_configs = m.get('ItemConfigs')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeFilterConfigsResponseBody(TeaModel):
    def __init__(
        self,
        filter_configs: List[DescribeFilterConfigsResponseBodyFilterConfigs] = None,
        request_id: str = None,
    ):
        self.filter_configs = filter_configs
        # Id
        self.request_id = request_id

    def validate(self):
        if self.filter_configs:
            for k in self.filter_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FilterConfigs'] = []
        if self.filter_configs is not None:
            for k in self.filter_configs:
                result['FilterConfigs'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.filter_configs = []
        if m.get('FilterConfigs') is not None:
            for k in m.get('FilterConfigs'):
                temp_model = DescribeFilterConfigsResponseBodyFilterConfigs()
                self.filter_configs.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeFilterConfigsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeFilterConfigsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeFilterConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLivePubExperienceMetricDataRequest(TeaModel):
    def __init__(
        self,
        begin_ts: str = None,
        domain: str = None,
        end_ts: str = None,
        metric_type: str = None,
        os: str = None,
        pub_protocol: str = None,
        terminal_type: str = None,
    ):
        self.begin_ts = begin_ts
        self.domain = domain
        self.end_ts = end_ts
        self.metric_type = metric_type
        self.os = os
        self.pub_protocol = pub_protocol
        self.terminal_type = terminal_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin_ts is not None:
            result['BeginTs'] = self.begin_ts
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.metric_type is not None:
            result['MetricType'] = self.metric_type
        if self.os is not None:
            result['Os'] = self.os
        if self.pub_protocol is not None:
            result['PubProtocol'] = self.pub_protocol
        if self.terminal_type is not None:
            result['TerminalType'] = self.terminal_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BeginTs') is not None:
            self.begin_ts = m.get('BeginTs')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('MetricType') is not None:
            self.metric_type = m.get('MetricType')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('PubProtocol') is not None:
            self.pub_protocol = m.get('PubProtocol')
        if m.get('TerminalType') is not None:
            self.terminal_type = m.get('TerminalType')
        return self


class DescribeLivePubExperienceMetricDataResponseBodyMetricList(TeaModel):
    def __init__(
        self,
        avg_score: float = None,
        max_score: float = None,
        min_score: float = None,
    ):
        self.avg_score = avg_score
        self.max_score = max_score
        self.min_score = min_score

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_score is not None:
            result['AvgScore'] = self.avg_score
        if self.max_score is not None:
            result['MaxScore'] = self.max_score
        if self.min_score is not None:
            result['MinScore'] = self.min_score
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgScore') is not None:
            self.avg_score = m.get('AvgScore')
        if m.get('MaxScore') is not None:
            self.max_score = m.get('MaxScore')
        if m.get('MinScore') is not None:
            self.min_score = m.get('MinScore')
        return self


class DescribeLivePubExperienceMetricDataResponseBody(TeaModel):
    def __init__(
        self,
        metric_list: List[DescribeLivePubExperienceMetricDataResponseBodyMetricList] = None,
        request_id: str = None,
    ):
        self.metric_list = metric_list
        # Id
        self.request_id = request_id

    def validate(self):
        if self.metric_list:
            for k in self.metric_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MetricList'] = []
        if self.metric_list is not None:
            for k in self.metric_list:
                result['MetricList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.metric_list = []
        if m.get('MetricList') is not None:
            for k in m.get('MetricList'):
                temp_model = DescribeLivePubExperienceMetricDataResponseBodyMetricList()
                self.metric_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLivePubExperienceMetricDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeLivePubExperienceMetricDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLivePubExperienceMetricDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLivePubListRequest(TeaModel):
    def __init__(
        self,
        begin_ts: str = None,
        domain: str = None,
        end_ts: str = None,
        metric_type: str = None,
        os: str = None,
        page_num: int = None,
        page_size: int = None,
        pub_protocol: str = None,
        terminal_type: str = None,
    ):
        self.begin_ts = begin_ts
        self.domain = domain
        self.end_ts = end_ts
        self.metric_type = metric_type
        self.os = os
        self.page_num = page_num
        self.page_size = page_size
        self.pub_protocol = pub_protocol
        self.terminal_type = terminal_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin_ts is not None:
            result['BeginTs'] = self.begin_ts
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.metric_type is not None:
            result['MetricType'] = self.metric_type
        if self.os is not None:
            result['Os'] = self.os
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.pub_protocol is not None:
            result['PubProtocol'] = self.pub_protocol
        if self.terminal_type is not None:
            result['TerminalType'] = self.terminal_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BeginTs') is not None:
            self.begin_ts = m.get('BeginTs')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('MetricType') is not None:
            self.metric_type = m.get('MetricType')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PubProtocol') is not None:
            self.pub_protocol = m.get('PubProtocol')
        if m.get('TerminalType') is not None:
            self.terminal_type = m.get('TerminalType')
        return self


class DescribeLivePubListResponseBodyPubInfoList(TeaModel):
    def __init__(
        self,
        area: str = None,
        cpu_usage_rate: str = None,
        domain: str = None,
        end_ts: str = None,
        fps: str = None,
        kbps: str = None,
        pub_heap_up_duration: str = None,
        pub_machine_type: str = None,
        second_play_rate: str = None,
        start_ts: str = None,
        stream_name: str = None,
    ):
        self.area = area
        self.cpu_usage_rate = cpu_usage_rate
        self.domain = domain
        self.end_ts = end_ts
        self.fps = fps
        self.kbps = kbps
        self.pub_heap_up_duration = pub_heap_up_duration
        self.pub_machine_type = pub_machine_type
        self.second_play_rate = second_play_rate
        self.start_ts = start_ts
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.area is not None:
            result['Area'] = self.area
        if self.cpu_usage_rate is not None:
            result['CpuUsageRate'] = self.cpu_usage_rate
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.kbps is not None:
            result['Kbps'] = self.kbps
        if self.pub_heap_up_duration is not None:
            result['PubHeapUpDuration'] = self.pub_heap_up_duration
        if self.pub_machine_type is not None:
            result['PubMachineType'] = self.pub_machine_type
        if self.second_play_rate is not None:
            result['SecondPlayRate'] = self.second_play_rate
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Area') is not None:
            self.area = m.get('Area')
        if m.get('CpuUsageRate') is not None:
            self.cpu_usage_rate = m.get('CpuUsageRate')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Kbps') is not None:
            self.kbps = m.get('Kbps')
        if m.get('PubHeapUpDuration') is not None:
            self.pub_heap_up_duration = m.get('PubHeapUpDuration')
        if m.get('PubMachineType') is not None:
            self.pub_machine_type = m.get('PubMachineType')
        if m.get('SecondPlayRate') is not None:
            self.second_play_rate = m.get('SecondPlayRate')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DescribeLivePubListResponseBody(TeaModel):
    def __init__(
        self,
        page_no: int = None,
        page_size: int = None,
        pub_info_list: List[DescribeLivePubListResponseBodyPubInfoList] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.page_no = page_no
        self.page_size = page_size
        self.pub_info_list = pub_info_list
        # Id
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.pub_info_list:
            for k in self.pub_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['PubInfoList'] = []
        if self.pub_info_list is not None:
            for k in self.pub_info_list:
                result['PubInfoList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.pub_info_list = []
        if m.get('PubInfoList') is not None:
            for k in m.get('PubInfoList'):
                temp_model = DescribeLivePubListResponseBodyPubInfoList()
                self.pub_info_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeLivePubListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeLivePubListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLivePubListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLivePubMetricDataRequest(TeaModel):
    def __init__(
        self,
        begin_ts: int = None,
        domain: str = None,
        end_ts: int = None,
        experience_level: str = None,
        metric_type: str = None,
        os: str = None,
        pub_protocol: str = None,
        sdk_version: str = None,
        stream_name: str = None,
        terminal_type: str = None,
    ):
        self.begin_ts = begin_ts
        self.domain = domain
        self.end_ts = end_ts
        self.experience_level = experience_level
        self.metric_type = metric_type
        self.os = os
        self.pub_protocol = pub_protocol
        self.sdk_version = sdk_version
        self.stream_name = stream_name
        self.terminal_type = terminal_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin_ts is not None:
            result['BeginTs'] = self.begin_ts
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.experience_level is not None:
            result['ExperienceLevel'] = self.experience_level
        if self.metric_type is not None:
            result['MetricType'] = self.metric_type
        if self.os is not None:
            result['Os'] = self.os
        if self.pub_protocol is not None:
            result['PubProtocol'] = self.pub_protocol
        if self.sdk_version is not None:
            result['SdkVersion'] = self.sdk_version
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.terminal_type is not None:
            result['TerminalType'] = self.terminal_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BeginTs') is not None:
            self.begin_ts = m.get('BeginTs')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('ExperienceLevel') is not None:
            self.experience_level = m.get('ExperienceLevel')
        if m.get('MetricType') is not None:
            self.metric_type = m.get('MetricType')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('PubProtocol') is not None:
            self.pub_protocol = m.get('PubProtocol')
        if m.get('SdkVersion') is not None:
            self.sdk_version = m.get('SdkVersion')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('TerminalType') is not None:
            self.terminal_type = m.get('TerminalType')
        return self


class DescribeLivePubMetricDataResponseBodyNodes(TeaModel):
    def __init__(
        self,
        duration: int = None,
        time: int = None,
    ):
        self.duration = duration
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeLivePubMetricDataResponseBody(TeaModel):
    def __init__(
        self,
        nodes: List[DescribeLivePubMetricDataResponseBodyNodes] = None,
        request_id: str = None,
    ):
        self.nodes = nodes
        # Id
        self.request_id = request_id

    def validate(self):
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = DescribeLivePubMetricDataResponseBodyNodes()
                self.nodes.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLivePubMetricDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeLivePubMetricDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLivePubMetricDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveSubExperienceMetricDataRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        begin_ts: str = None,
        end_ts: str = None,
        experience_level: str = None,
        metric_type: str = None,
        os: str = None,
        sub_protocol: str = None,
        terminal_type: str = None,
    ):
        self.app_name = app_name
        self.begin_ts = begin_ts
        self.end_ts = end_ts
        self.experience_level = experience_level
        self.metric_type = metric_type
        self.os = os
        self.sub_protocol = sub_protocol
        self.terminal_type = terminal_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.begin_ts is not None:
            result['BeginTs'] = self.begin_ts
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.experience_level is not None:
            result['ExperienceLevel'] = self.experience_level
        if self.metric_type is not None:
            result['MetricType'] = self.metric_type
        if self.os is not None:
            result['Os'] = self.os
        if self.sub_protocol is not None:
            result['SubProtocol'] = self.sub_protocol
        if self.terminal_type is not None:
            result['TerminalType'] = self.terminal_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('BeginTs') is not None:
            self.begin_ts = m.get('BeginTs')
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('ExperienceLevel') is not None:
            self.experience_level = m.get('ExperienceLevel')
        if m.get('MetricType') is not None:
            self.metric_type = m.get('MetricType')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('SubProtocol') is not None:
            self.sub_protocol = m.get('SubProtocol')
        if m.get('TerminalType') is not None:
            self.terminal_type = m.get('TerminalType')
        return self


class DescribeLiveSubExperienceMetricDataResponseBodyMetricList(TeaModel):
    def __init__(
        self,
        avg_score: float = None,
        max_score: float = None,
        min_score: float = None,
    ):
        self.avg_score = avg_score
        self.max_score = max_score
        self.min_score = min_score

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_score is not None:
            result['AvgScore'] = self.avg_score
        if self.max_score is not None:
            result['MaxScore'] = self.max_score
        if self.min_score is not None:
            result['MinScore'] = self.min_score
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgScore') is not None:
            self.avg_score = m.get('AvgScore')
        if m.get('MaxScore') is not None:
            self.max_score = m.get('MaxScore')
        if m.get('MinScore') is not None:
            self.min_score = m.get('MinScore')
        return self


class DescribeLiveSubExperienceMetricDataResponseBody(TeaModel):
    def __init__(
        self,
        metric_list: List[DescribeLiveSubExperienceMetricDataResponseBodyMetricList] = None,
        request_id: str = None,
    ):
        self.metric_list = metric_list
        # Id
        self.request_id = request_id

    def validate(self):
        if self.metric_list:
            for k in self.metric_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MetricList'] = []
        if self.metric_list is not None:
            for k in self.metric_list:
                result['MetricList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.metric_list = []
        if m.get('MetricList') is not None:
            for k in m.get('MetricList'):
                temp_model = DescribeLiveSubExperienceMetricDataResponseBodyMetricList()
                self.metric_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveSubExperienceMetricDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeLiveSubExperienceMetricDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveSubExperienceMetricDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveSubListRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        begin_ts: str = None,
        definition: str = None,
        end_ts: str = None,
        experience_level: str = None,
        item_configs: str = None,
        metric_type: str = None,
        network: str = None,
        os: str = None,
        page_no: int = None,
        page_size: int = None,
        stream_name: str = None,
        sub_protocol: str = None,
        terminal_type: str = None,
    ):
        self.app_name = app_name
        self.begin_ts = begin_ts
        self.definition = definition
        self.end_ts = end_ts
        self.experience_level = experience_level
        self.item_configs = item_configs
        self.metric_type = metric_type
        self.network = network
        self.os = os
        self.page_no = page_no
        self.page_size = page_size
        self.stream_name = stream_name
        self.sub_protocol = sub_protocol
        self.terminal_type = terminal_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.begin_ts is not None:
            result['BeginTs'] = self.begin_ts
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.experience_level is not None:
            result['ExperienceLevel'] = self.experience_level
        if self.item_configs is not None:
            result['ItemConfigs'] = self.item_configs
        if self.metric_type is not None:
            result['MetricType'] = self.metric_type
        if self.network is not None:
            result['Network'] = self.network
        if self.os is not None:
            result['Os'] = self.os
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.sub_protocol is not None:
            result['SubProtocol'] = self.sub_protocol
        if self.terminal_type is not None:
            result['TerminalType'] = self.terminal_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('BeginTs') is not None:
            self.begin_ts = m.get('BeginTs')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('ExperienceLevel') is not None:
            self.experience_level = m.get('ExperienceLevel')
        if m.get('ItemConfigs') is not None:
            self.item_configs = m.get('ItemConfigs')
        if m.get('MetricType') is not None:
            self.metric_type = m.get('MetricType')
        if m.get('Network') is not None:
            self.network = m.get('Network')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('SubProtocol') is not None:
            self.sub_protocol = m.get('SubProtocol')
        if m.get('TerminalType') is not None:
            self.terminal_type = m.get('TerminalType')
        return self


class DescribeLiveSubListResponseBodySubInfoList(TeaModel):
    def __init__(
        self,
        cache_duration: str = None,
        cpu_usage_rate: str = None,
        first_frame_duration: str = None,
        play_fps: str = None,
        second_play_rate: str = None,
        sub_net_bitrate: str = None,
        sub_rate: str = None,
        trace_id: str = None,
        video_stuck: str = None,
    ):
        self.cache_duration = cache_duration
        self.cpu_usage_rate = cpu_usage_rate
        self.first_frame_duration = first_frame_duration
        self.play_fps = play_fps
        self.second_play_rate = second_play_rate
        self.sub_net_bitrate = sub_net_bitrate
        self.sub_rate = sub_rate
        self.trace_id = trace_id
        self.video_stuck = video_stuck

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cache_duration is not None:
            result['CacheDuration'] = self.cache_duration
        if self.cpu_usage_rate is not None:
            result['CpuUsageRate'] = self.cpu_usage_rate
        if self.first_frame_duration is not None:
            result['FirstFrameDuration'] = self.first_frame_duration
        if self.play_fps is not None:
            result['PlayFps'] = self.play_fps
        if self.second_play_rate is not None:
            result['SecondPlayRate'] = self.second_play_rate
        if self.sub_net_bitrate is not None:
            result['SubNetBitrate'] = self.sub_net_bitrate
        if self.sub_rate is not None:
            result['SubRate'] = self.sub_rate
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        if self.video_stuck is not None:
            result['VideoStuck'] = self.video_stuck
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CacheDuration') is not None:
            self.cache_duration = m.get('CacheDuration')
        if m.get('CpuUsageRate') is not None:
            self.cpu_usage_rate = m.get('CpuUsageRate')
        if m.get('FirstFrameDuration') is not None:
            self.first_frame_duration = m.get('FirstFrameDuration')
        if m.get('PlayFps') is not None:
            self.play_fps = m.get('PlayFps')
        if m.get('SecondPlayRate') is not None:
            self.second_play_rate = m.get('SecondPlayRate')
        if m.get('SubNetBitrate') is not None:
            self.sub_net_bitrate = m.get('SubNetBitrate')
        if m.get('SubRate') is not None:
            self.sub_rate = m.get('SubRate')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        if m.get('VideoStuck') is not None:
            self.video_stuck = m.get('VideoStuck')
        return self


class DescribeLiveSubListResponseBody(TeaModel):
    def __init__(
        self,
        page_no: int = None,
        page_size: int = None,
        request_id: str = None,
        sub_info_list: List[DescribeLiveSubListResponseBodySubInfoList] = None,
        total_count: int = None,
    ):
        self.page_no = page_no
        self.page_size = page_size
        # Id
        self.request_id = request_id
        self.sub_info_list = sub_info_list
        self.total_count = total_count

    def validate(self):
        if self.sub_info_list:
            for k in self.sub_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SubInfoList'] = []
        if self.sub_info_list is not None:
            for k in self.sub_info_list:
                result['SubInfoList'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.sub_info_list = []
        if m.get('SubInfoList') is not None:
            for k in m.get('SubInfoList'):
                temp_model = DescribeLiveSubListResponseBodySubInfoList()
                self.sub_info_list.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeLiveSubListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeLiveSubListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveSubListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveSubMetricDataRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        begin_ts: int = None,
        definition: str = None,
        end_ts: int = None,
        experience_level: str = None,
        item_configs: str = None,
        metric_type: str = None,
        network: str = None,
        os: str = None,
        sdk_version: str = None,
        stream_name: str = None,
        sub_protocol: str = None,
        terminal_type: str = None,
    ):
        self.app_name = app_name
        self.begin_ts = begin_ts
        self.definition = definition
        self.end_ts = end_ts
        self.experience_level = experience_level
        self.item_configs = item_configs
        self.metric_type = metric_type
        self.network = network
        self.os = os
        self.sdk_version = sdk_version
        self.stream_name = stream_name
        self.sub_protocol = sub_protocol
        self.terminal_type = terminal_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.begin_ts is not None:
            result['BeginTs'] = self.begin_ts
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.experience_level is not None:
            result['ExperienceLevel'] = self.experience_level
        if self.item_configs is not None:
            result['ItemConfigs'] = self.item_configs
        if self.metric_type is not None:
            result['MetricType'] = self.metric_type
        if self.network is not None:
            result['Network'] = self.network
        if self.os is not None:
            result['Os'] = self.os
        if self.sdk_version is not None:
            result['SdkVersion'] = self.sdk_version
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.sub_protocol is not None:
            result['SubProtocol'] = self.sub_protocol
        if self.terminal_type is not None:
            result['TerminalType'] = self.terminal_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('BeginTs') is not None:
            self.begin_ts = m.get('BeginTs')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('ExperienceLevel') is not None:
            self.experience_level = m.get('ExperienceLevel')
        if m.get('ItemConfigs') is not None:
            self.item_configs = m.get('ItemConfigs')
        if m.get('MetricType') is not None:
            self.metric_type = m.get('MetricType')
        if m.get('Network') is not None:
            self.network = m.get('Network')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('SdkVersion') is not None:
            self.sdk_version = m.get('SdkVersion')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('SubProtocol') is not None:
            self.sub_protocol = m.get('SubProtocol')
        if m.get('TerminalType') is not None:
            self.terminal_type = m.get('TerminalType')
        return self


class DescribeLiveSubMetricDataResponseBodyNodes(TeaModel):
    def __init__(
        self,
        duration: int = None,
        time: int = None,
    ):
        self.duration = duration
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeLiveSubMetricDataResponseBody(TeaModel):
    def __init__(
        self,
        nodes: List[DescribeLiveSubMetricDataResponseBodyNodes] = None,
        request_id: str = None,
    ):
        self.nodes = nodes
        # Id
        self.request_id = request_id

    def validate(self):
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = DescribeLiveSubMetricDataResponseBodyNodes()
                self.nodes.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveSubMetricDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeLiveSubMetricDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveSubMetricDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterIceEditUsageRequest(TeaModel):
    def __init__(
        self,
        end_ts: int = None,
        interval: int = None,
        region: str = None,
        start_ts: int = None,
    ):
        self.end_ts = end_ts
        self.interval = interval
        self.region = region
        self.start_ts = start_ts

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.region is not None:
            result['Region'] = self.region
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterIceEditUsageResponseBodyData(TeaModel):
    def __init__(
        self,
        duration: int = None,
        profile: str = None,
        time: int = None,
    ):
        self.duration = duration
        self.profile = profile
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeMeterIceEditUsageResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribeMeterIceEditUsageResponseBodyData] = None,
        request_id: str = None,
    ):
        self.data = data
        # Id
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterIceEditUsageResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterIceEditUsageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMeterIceEditUsageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterIceEditUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterIceLiveMediaConvertUsageRequest(TeaModel):
    def __init__(
        self,
        end_ts: int = None,
        interval: int = None,
        region: str = None,
        start_ts: int = None,
    ):
        self.end_ts = end_ts
        self.interval = interval
        self.region = region
        self.start_ts = start_ts

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.region is not None:
            result['Region'] = self.region
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterIceLiveMediaConvertUsageResponseBodyData(TeaModel):
    def __init__(
        self,
        duration: int = None,
        specification: str = None,
        time: int = None,
    ):
        self.duration = duration
        self.specification = specification
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeMeterIceLiveMediaConvertUsageResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribeMeterIceLiveMediaConvertUsageResponseBodyData] = None,
        request_id: str = None,
    ):
        self.data = data
        # Id
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterIceLiveMediaConvertUsageResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterIceLiveMediaConvertUsageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMeterIceLiveMediaConvertUsageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterIceLiveMediaConvertUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterIceMediaConvertUHDUsageRequest(TeaModel):
    def __init__(
        self,
        end_ts: int = None,
        interval: str = None,
        region_id: str = None,
        start_ts: int = None,
    ):
        self.end_ts = end_ts
        self.interval = interval
        self.region_id = region_id
        self.start_ts = start_ts

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterIceMediaConvertUHDUsageResponseBodyData(TeaModel):
    def __init__(
        self,
        duration: int = None,
        specification: str = None,
        time: int = None,
    ):
        self.duration = duration
        self.specification = specification
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeMeterIceMediaConvertUHDUsageResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribeMeterIceMediaConvertUHDUsageResponseBodyData] = None,
        request_id: str = None,
    ):
        self.data = data
        # Id
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterIceMediaConvertUHDUsageResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterIceMediaConvertUHDUsageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMeterIceMediaConvertUHDUsageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterIceMediaConvertUHDUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterIceMediaConvertUsageRequest(TeaModel):
    def __init__(
        self,
        end_ts: int = None,
        interval: int = None,
        region: str = None,
        start_ts: int = None,
    ):
        self.end_ts = end_ts
        self.interval = interval
        self.region = region
        self.start_ts = start_ts

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.region is not None:
            result['Region'] = self.region
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterIceMediaConvertUsageResponseBodyData(TeaModel):
    def __init__(
        self,
        duration: int = None,
        specification: str = None,
        time: int = None,
    ):
        self.duration = duration
        self.specification = specification
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeMeterIceMediaConvertUsageResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribeMeterIceMediaConvertUsageResponseBodyData] = None,
        request_id: str = None,
    ):
        self.data = data
        # Id
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterIceMediaConvertUsageResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterIceMediaConvertUsageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMeterIceMediaConvertUsageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterIceMediaConvertUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterIceMpsAiUsageRequest(TeaModel):
    def __init__(
        self,
        end_ts: int = None,
        interval: int = None,
        region: str = None,
        start_ts: int = None,
    ):
        self.end_ts = end_ts
        self.interval = interval
        self.region = region
        self.start_ts = start_ts

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.region is not None:
            result['Region'] = self.region
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterIceMpsAiUsageResponseBodyData(TeaModel):
    def __init__(
        self,
        duration: int = None,
        time: int = None,
        type: str = None,
    ):
        self.duration = duration
        self.time = time
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.time is not None:
            result['Time'] = self.time
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeMeterIceMpsAiUsageResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribeMeterIceMpsAiUsageResponseBodyData] = None,
        request_id: str = None,
    ):
        self.data = data
        # Id
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterIceMpsAiUsageResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterIceMpsAiUsageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMeterIceMpsAiUsageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterIceMpsAiUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMeterIceSummaryRequest(TeaModel):
    def __init__(
        self,
        end_ts: int = None,
        region: str = None,
        start_ts: int = None,
    ):
        self.end_ts = end_ts
        self.region = region
        self.start_ts = start_ts

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.region is not None:
            result['Region'] = self.region
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        return self


class DescribeMeterIceSummaryResponseBodyData(TeaModel):
    def __init__(
        self,
        editing_duration: str = None,
        live_transcode_duration: int = None,
        mps_ai_duration: int = None,
        mps_transcode_duration: int = None,
        mps_transcode_uhdduration: int = None,
    ):
        self.editing_duration = editing_duration
        self.live_transcode_duration = live_transcode_duration
        self.mps_ai_duration = mps_ai_duration
        self.mps_transcode_duration = mps_transcode_duration
        self.mps_transcode_uhdduration = mps_transcode_uhdduration

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.editing_duration is not None:
            result['EditingDuration'] = self.editing_duration
        if self.live_transcode_duration is not None:
            result['LiveTranscodeDuration'] = self.live_transcode_duration
        if self.mps_ai_duration is not None:
            result['MpsAiDuration'] = self.mps_ai_duration
        if self.mps_transcode_duration is not None:
            result['MpsTranscodeDuration'] = self.mps_transcode_duration
        if self.mps_transcode_uhdduration is not None:
            result['MpsTranscodeUHDDuration'] = self.mps_transcode_uhdduration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EditingDuration') is not None:
            self.editing_duration = m.get('EditingDuration')
        if m.get('LiveTranscodeDuration') is not None:
            self.live_transcode_duration = m.get('LiveTranscodeDuration')
        if m.get('MpsAiDuration') is not None:
            self.mps_ai_duration = m.get('MpsAiDuration')
        if m.get('MpsTranscodeDuration') is not None:
            self.mps_transcode_duration = m.get('MpsTranscodeDuration')
        if m.get('MpsTranscodeUHDDuration') is not None:
            self.mps_transcode_uhdduration = m.get('MpsTranscodeUHDDuration')
        return self


class DescribeMeterIceSummaryResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribeMeterIceSummaryResponseBodyData] = None,
        request_id: str = None,
    ):
        self.data = data
        # Id
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeMeterIceSummaryResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMeterIceSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMeterIceSummaryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMeterIceSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePalyDetailRequest(TeaModel):
    def __init__(
        self,
        trace_id: str = None,
    ):
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribePalyDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        bps: str = None,
        broadcast_pace: str = None,
        codec: str = None,
        decode_stuck_time: str = None,
        definition: str = None,
        first_frame_duration: str = None,
        fps: str = None,
        is_hard_decode: str = None,
        mdat: str = None,
        moov: str = None,
        net_work_duration: str = None,
        network: str = None,
        network_stuck_time: str = None,
        os: str = None,
        play_ts: str = None,
        player_load_duration: str = None,
        player_pre_deal_duration: str = None,
        player_ready_duration: str = None,
        sdk_version: str = None,
        session_id: str = None,
        status: str = None,
        terminal_type: str = None,
    ):
        self.app_name = app_name
        self.bps = bps
        self.broadcast_pace = broadcast_pace
        self.codec = codec
        self.decode_stuck_time = decode_stuck_time
        self.definition = definition
        self.first_frame_duration = first_frame_duration
        self.fps = fps
        self.is_hard_decode = is_hard_decode
        self.mdat = mdat
        self.moov = moov
        self.net_work_duration = net_work_duration
        self.network = network
        self.network_stuck_time = network_stuck_time
        self.os = os
        self.play_ts = play_ts
        self.player_load_duration = player_load_duration
        self.player_pre_deal_duration = player_pre_deal_duration
        self.player_ready_duration = player_ready_duration
        self.sdk_version = sdk_version
        self.session_id = session_id
        self.status = status
        self.terminal_type = terminal_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.bps is not None:
            result['Bps'] = self.bps
        if self.broadcast_pace is not None:
            result['BroadcastPace'] = self.broadcast_pace
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.decode_stuck_time is not None:
            result['DecodeStuckTime'] = self.decode_stuck_time
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.first_frame_duration is not None:
            result['FirstFrameDuration'] = self.first_frame_duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.is_hard_decode is not None:
            result['IsHardDecode'] = self.is_hard_decode
        if self.mdat is not None:
            result['Mdat'] = self.mdat
        if self.moov is not None:
            result['Moov'] = self.moov
        if self.net_work_duration is not None:
            result['NetWorkDuration'] = self.net_work_duration
        if self.network is not None:
            result['Network'] = self.network
        if self.network_stuck_time is not None:
            result['NetworkStuckTime'] = self.network_stuck_time
        if self.os is not None:
            result['Os'] = self.os
        if self.play_ts is not None:
            result['PlayTs'] = self.play_ts
        if self.player_load_duration is not None:
            result['PlayerLoadDuration'] = self.player_load_duration
        if self.player_pre_deal_duration is not None:
            result['PlayerPreDealDuration'] = self.player_pre_deal_duration
        if self.player_ready_duration is not None:
            result['PlayerReadyDuration'] = self.player_ready_duration
        if self.sdk_version is not None:
            result['SdkVersion'] = self.sdk_version
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        if self.status is not None:
            result['Status'] = self.status
        if self.terminal_type is not None:
            result['TerminalType'] = self.terminal_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Bps') is not None:
            self.bps = m.get('Bps')
        if m.get('BroadcastPace') is not None:
            self.broadcast_pace = m.get('BroadcastPace')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('DecodeStuckTime') is not None:
            self.decode_stuck_time = m.get('DecodeStuckTime')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('FirstFrameDuration') is not None:
            self.first_frame_duration = m.get('FirstFrameDuration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('IsHardDecode') is not None:
            self.is_hard_decode = m.get('IsHardDecode')
        if m.get('Mdat') is not None:
            self.mdat = m.get('Mdat')
        if m.get('Moov') is not None:
            self.moov = m.get('Moov')
        if m.get('NetWorkDuration') is not None:
            self.net_work_duration = m.get('NetWorkDuration')
        if m.get('Network') is not None:
            self.network = m.get('Network')
        if m.get('NetworkStuckTime') is not None:
            self.network_stuck_time = m.get('NetworkStuckTime')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('PlayTs') is not None:
            self.play_ts = m.get('PlayTs')
        if m.get('PlayerLoadDuration') is not None:
            self.player_load_duration = m.get('PlayerLoadDuration')
        if m.get('PlayerPreDealDuration') is not None:
            self.player_pre_deal_duration = m.get('PlayerPreDealDuration')
        if m.get('PlayerReadyDuration') is not None:
            self.player_ready_duration = m.get('PlayerReadyDuration')
        if m.get('SdkVersion') is not None:
            self.sdk_version = m.get('SdkVersion')
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TerminalType') is not None:
            self.terminal_type = m.get('TerminalType')
        return self


class DescribePalyDetailResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribePalyDetailResponseBodyData] = None,
        request_id: str = None,
    ):
        self.data = data
        # Id
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribePalyDetailResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePalyDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePalyDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePalyDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePalyEventListRequest(TeaModel):
    def __init__(
        self,
        page_no: int = None,
        page_size: int = None,
        trace_id: str = None,
    ):
        self.page_no = page_no
        self.page_size = page_size
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribePalyEventListResponseBodyEventList(TeaModel):
    def __init__(
        self,
        description: str = None,
        duration: float = None,
        event_name: str = None,
        time: int = None,
        topic: str = None,
    ):
        self.description = description
        self.duration = duration
        self.event_name = event_name
        self.time = time
        self.topic = topic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.time is not None:
            result['Time'] = self.time
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class DescribePalyEventListResponseBody(TeaModel):
    def __init__(
        self,
        event_list: List[DescribePalyEventListResponseBodyEventList] = None,
        page_no: int = None,
        page_size: int = None,
        request_id: str = None,
        total_cnt: int = None,
    ):
        self.event_list = event_list
        self.page_no = page_no
        self.page_size = page_size
        # Id
        self.request_id = request_id
        self.total_cnt = total_cnt

    def validate(self):
        if self.event_list:
            for k in self.event_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventList'] = []
        if self.event_list is not None:
            for k in self.event_list:
                result['EventList'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_cnt is not None:
            result['TotalCnt'] = self.total_cnt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.event_list = []
        if m.get('EventList') is not None:
            for k in m.get('EventList'):
                temp_model = DescribePalyEventListResponseBodyEventList()
                self.event_list.append(temp_model.from_map(k))
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCnt') is not None:
            self.total_cnt = m.get('TotalCnt')
        return self


class DescribePalyEventListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePalyEventListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePalyEventListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePalyListRequest(TeaModel):
    def __init__(
        self,
        begin_ts: str = None,
        end_ts: str = None,
        order_name: str = None,
        order_type: str = None,
        page_no: int = None,
        page_size: int = None,
        play_type: str = None,
        status: str = None,
        trace_id: str = None,
    ):
        self.begin_ts = begin_ts
        self.end_ts = end_ts
        self.order_name = order_name
        self.order_type = order_type
        self.page_no = page_no
        self.page_size = page_size
        self.play_type = play_type
        self.status = status
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin_ts is not None:
            result['BeginTs'] = self.begin_ts
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.order_name is not None:
            result['OrderName'] = self.order_name
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.play_type is not None:
            result['PlayType'] = self.play_type
        if self.status is not None:
            result['Status'] = self.status
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BeginTs') is not None:
            self.begin_ts = m.get('BeginTs')
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('OrderName') is not None:
            self.order_name = m.get('OrderName')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PlayType') is not None:
            self.play_type = m.get('PlayType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribePalyListResponseBodyPlayList(TeaModel):
    def __init__(
        self,
        first_frame_duration: str = None,
        play_duration: str = None,
        play_type: str = None,
        session_id: str = None,
        status: str = None,
        stuck_duration: str = None,
        trace_id: str = None,
        video_duration: str = None,
        video_id: str = None,
    ):
        self.first_frame_duration = first_frame_duration
        self.play_duration = play_duration
        self.play_type = play_type
        self.session_id = session_id
        self.status = status
        self.stuck_duration = stuck_duration
        self.trace_id = trace_id
        self.video_duration = video_duration
        self.video_id = video_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.first_frame_duration is not None:
            result['FirstFrameDuration'] = self.first_frame_duration
        if self.play_duration is not None:
            result['PlayDuration'] = self.play_duration
        if self.play_type is not None:
            result['PlayType'] = self.play_type
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        if self.status is not None:
            result['Status'] = self.status
        if self.stuck_duration is not None:
            result['StuckDuration'] = self.stuck_duration
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        if self.video_duration is not None:
            result['VideoDuration'] = self.video_duration
        if self.video_id is not None:
            result['VideoId'] = self.video_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FirstFrameDuration') is not None:
            self.first_frame_duration = m.get('FirstFrameDuration')
        if m.get('PlayDuration') is not None:
            self.play_duration = m.get('PlayDuration')
        if m.get('PlayType') is not None:
            self.play_type = m.get('PlayType')
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StuckDuration') is not None:
            self.stuck_duration = m.get('StuckDuration')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        if m.get('VideoDuration') is not None:
            self.video_duration = m.get('VideoDuration')
        if m.get('VideoId') is not None:
            self.video_id = m.get('VideoId')
        return self


class DescribePalyListResponseBody(TeaModel):
    def __init__(
        self,
        page_no: int = None,
        page_size: int = None,
        play_list: List[DescribePalyListResponseBodyPlayList] = None,
        request_id: str = None,
        total_cnt: int = None,
    ):
        self.page_no = page_no
        self.page_size = page_size
        self.play_list = play_list
        # Id
        self.request_id = request_id
        self.total_cnt = total_cnt

    def validate(self):
        if self.play_list:
            for k in self.play_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['PlayList'] = []
        if self.play_list is not None:
            for k in self.play_list:
                result['PlayList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_cnt is not None:
            result['TotalCnt'] = self.total_cnt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.play_list = []
        if m.get('PlayList') is not None:
            for k in m.get('PlayList'):
                temp_model = DescribePalyListResponseBodyPlayList()
                self.play_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCnt') is not None:
            self.total_cnt = m.get('TotalCnt')
        return self


class DescribePalyListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePalyListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePalyListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePlayExperienceMetricDataRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        begin_ts: str = None,
        end_ts: str = None,
        experience_level: str = None,
        os: str = None,
        terminal_type: str = None,
    ):
        self.app_name = app_name
        self.begin_ts = begin_ts
        self.end_ts = end_ts
        self.experience_level = experience_level
        self.os = os
        self.terminal_type = terminal_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.begin_ts is not None:
            result['BeginTs'] = self.begin_ts
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.experience_level is not None:
            result['ExperienceLevel'] = self.experience_level
        if self.os is not None:
            result['Os'] = self.os
        if self.terminal_type is not None:
            result['TerminalType'] = self.terminal_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('BeginTs') is not None:
            self.begin_ts = m.get('BeginTs')
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('ExperienceLevel') is not None:
            self.experience_level = m.get('ExperienceLevel')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('TerminalType') is not None:
            self.terminal_type = m.get('TerminalType')
        return self


class DescribePlayExperienceMetricDataResponseBodyData(TeaModel):
    def __init__(
        self,
        avg_score: float = None,
        max_score: float = None,
        min_score: float = None,
    ):
        self.avg_score = avg_score
        self.max_score = max_score
        self.min_score = min_score

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_score is not None:
            result['AvgScore'] = self.avg_score
        if self.max_score is not None:
            result['MaxScore'] = self.max_score
        if self.min_score is not None:
            result['MinScore'] = self.min_score
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgScore') is not None:
            self.avg_score = m.get('AvgScore')
        if m.get('MaxScore') is not None:
            self.max_score = m.get('MaxScore')
        if m.get('MinScore') is not None:
            self.min_score = m.get('MinScore')
        return self


class DescribePlayExperienceMetricDataResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribePlayExperienceMetricDataResponseBodyData] = None,
        request_id: str = None,
    ):
        self.data = data
        # Id
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribePlayExperienceMetricDataResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePlayExperienceMetricDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePlayExperienceMetricDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePlayExperienceMetricDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePlayFirstFrameDurationMetricDataRequest(TeaModel):
    def __init__(
        self,
        begin_ts: str = None,
        end_ts: str = None,
        trace_id: str = None,
    ):
        self.begin_ts = begin_ts
        self.end_ts = end_ts
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin_ts is not None:
            result['BeginTs'] = self.begin_ts
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BeginTs') is not None:
            self.begin_ts = m.get('BeginTs')
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribePlayFirstFrameDurationMetricDataResponseBodyNodes(TeaModel):
    def __init__(
        self,
        duration: int = None,
        time: int = None,
    ):
        self.duration = duration
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribePlayFirstFrameDurationMetricDataResponseBody(TeaModel):
    def __init__(
        self,
        nodes: List[DescribePlayFirstFrameDurationMetricDataResponseBodyNodes] = None,
        request_id: str = None,
    ):
        self.nodes = nodes
        # Id
        self.request_id = request_id

    def validate(self):
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = DescribePlayFirstFrameDurationMetricDataResponseBodyNodes()
                self.nodes.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePlayFirstFrameDurationMetricDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePlayFirstFrameDurationMetricDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePlayFirstFrameDurationMetricDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePlayMetricDataRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        begin_ts: int = None,
        definition: str = None,
        end_ts: int = None,
        experience_level: str = None,
        item_configs: str = None,
        metric_type: str = None,
        network: str = None,
        os: str = None,
        sdk_version: str = None,
        terminal_type: str = None,
    ):
        self.app_name = app_name
        self.begin_ts = begin_ts
        self.definition = definition
        self.end_ts = end_ts
        self.experience_level = experience_level
        self.item_configs = item_configs
        self.metric_type = metric_type
        self.network = network
        self.os = os
        self.sdk_version = sdk_version
        self.terminal_type = terminal_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.begin_ts is not None:
            result['BeginTs'] = self.begin_ts
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.experience_level is not None:
            result['ExperienceLevel'] = self.experience_level
        if self.item_configs is not None:
            result['ItemConfigs'] = self.item_configs
        if self.metric_type is not None:
            result['MetricType'] = self.metric_type
        if self.network is not None:
            result['Network'] = self.network
        if self.os is not None:
            result['Os'] = self.os
        if self.sdk_version is not None:
            result['SdkVersion'] = self.sdk_version
        if self.terminal_type is not None:
            result['TerminalType'] = self.terminal_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('BeginTs') is not None:
            self.begin_ts = m.get('BeginTs')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('ExperienceLevel') is not None:
            self.experience_level = m.get('ExperienceLevel')
        if m.get('ItemConfigs') is not None:
            self.item_configs = m.get('ItemConfigs')
        if m.get('MetricType') is not None:
            self.metric_type = m.get('MetricType')
        if m.get('Network') is not None:
            self.network = m.get('Network')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('SdkVersion') is not None:
            self.sdk_version = m.get('SdkVersion')
        if m.get('TerminalType') is not None:
            self.terminal_type = m.get('TerminalType')
        return self


class DescribePlayMetricDataResponseBodyNodes(TeaModel):
    def __init__(
        self,
        x: int = None,
        y: int = None,
    ):
        self.x = x
        self.y = y

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.x is not None:
            result['X'] = self.x
        if self.y is not None:
            result['Y'] = self.y
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('X') is not None:
            self.x = m.get('X')
        if m.get('Y') is not None:
            self.y = m.get('Y')
        return self


class DescribePlayMetricDataResponseBody(TeaModel):
    def __init__(
        self,
        nodes: List[DescribePlayMetricDataResponseBodyNodes] = None,
        request_id: str = None,
    ):
        self.nodes = nodes
        # Id
        self.request_id = request_id

    def validate(self):
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = DescribePlayMetricDataResponseBodyNodes()
                self.nodes.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePlayMetricDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePlayMetricDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePlayMetricDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePlayQoeListRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        begin_ts: int = None,
        definition: str = None,
        end_ts: int = None,
        item_configs: str = None,
        metric_type: str = None,
        network: str = None,
        os: str = None,
        page_no: int = None,
        page_size: int = None,
        terminal_type: str = None,
    ):
        self.app_name = app_name
        self.begin_ts = begin_ts
        self.definition = definition
        self.end_ts = end_ts
        self.item_configs = item_configs
        self.metric_type = metric_type
        self.network = network
        self.os = os
        self.page_no = page_no
        self.page_size = page_size
        self.terminal_type = terminal_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.begin_ts is not None:
            result['BeginTs'] = self.begin_ts
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.item_configs is not None:
            result['ItemConfigs'] = self.item_configs
        if self.metric_type is not None:
            result['MetricType'] = self.metric_type
        if self.network is not None:
            result['Network'] = self.network
        if self.os is not None:
            result['Os'] = self.os
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.terminal_type is not None:
            result['TerminalType'] = self.terminal_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('BeginTs') is not None:
            self.begin_ts = m.get('BeginTs')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('ItemConfigs') is not None:
            self.item_configs = m.get('ItemConfigs')
        if m.get('MetricType') is not None:
            self.metric_type = m.get('MetricType')
        if m.get('Network') is not None:
            self.network = m.get('Network')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TerminalType') is not None:
            self.terminal_type = m.get('TerminalType')
        return self


class DescribePlayQoeListResponseBodyQoeInfoList(TeaModel):
    def __init__(
        self,
        qoe_finished_vv: float = None,
        qoe_finished_vvrate: float = None,
        qoe_ufinished_vvtime: float = None,
        qoe_uv: float = None,
        qoe_uvvduration: float = None,
        qoe_uvvtime: float = None,
        qoe_vduration: float = None,
        qoe_vvduration: float = None,
        vpsid: str = None,
    ):
        self.qoe_finished_vv = qoe_finished_vv
        self.qoe_finished_vvrate = qoe_finished_vvrate
        self.qoe_ufinished_vvtime = qoe_ufinished_vvtime
        self.qoe_uv = qoe_uv
        self.qoe_uvvduration = qoe_uvvduration
        self.qoe_uvvtime = qoe_uvvtime
        self.qoe_vduration = qoe_vduration
        self.qoe_vvduration = qoe_vvduration
        self.vpsid = vpsid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.qoe_finished_vv is not None:
            result['QoeFinishedVV'] = self.qoe_finished_vv
        if self.qoe_finished_vvrate is not None:
            result['QoeFinishedVVRate'] = self.qoe_finished_vvrate
        if self.qoe_ufinished_vvtime is not None:
            result['QoeUFinishedVVTime'] = self.qoe_ufinished_vvtime
        if self.qoe_uv is not None:
            result['QoeUV'] = self.qoe_uv
        if self.qoe_uvvduration is not None:
            result['QoeUVVDuration'] = self.qoe_uvvduration
        if self.qoe_uvvtime is not None:
            result['QoeUVVTime'] = self.qoe_uvvtime
        if self.qoe_vduration is not None:
            result['QoeVDuration'] = self.qoe_vduration
        if self.qoe_vvduration is not None:
            result['QoeVVDuration'] = self.qoe_vvduration
        if self.vpsid is not None:
            result['Vpsid'] = self.vpsid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QoeFinishedVV') is not None:
            self.qoe_finished_vv = m.get('QoeFinishedVV')
        if m.get('QoeFinishedVVRate') is not None:
            self.qoe_finished_vvrate = m.get('QoeFinishedVVRate')
        if m.get('QoeUFinishedVVTime') is not None:
            self.qoe_ufinished_vvtime = m.get('QoeUFinishedVVTime')
        if m.get('QoeUV') is not None:
            self.qoe_uv = m.get('QoeUV')
        if m.get('QoeUVVDuration') is not None:
            self.qoe_uvvduration = m.get('QoeUVVDuration')
        if m.get('QoeUVVTime') is not None:
            self.qoe_uvvtime = m.get('QoeUVVTime')
        if m.get('QoeVDuration') is not None:
            self.qoe_vduration = m.get('QoeVDuration')
        if m.get('QoeVVDuration') is not None:
            self.qoe_vvduration = m.get('QoeVVDuration')
        if m.get('Vpsid') is not None:
            self.vpsid = m.get('Vpsid')
        return self


class DescribePlayQoeListResponseBody(TeaModel):
    def __init__(
        self,
        page_no: int = None,
        page_size: int = None,
        qoe_info_list: List[DescribePlayQoeListResponseBodyQoeInfoList] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.page_no = page_no
        self.page_size = page_size
        self.qoe_info_list = qoe_info_list
        # Id
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.qoe_info_list:
            for k in self.qoe_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['QoeInfoList'] = []
        if self.qoe_info_list is not None:
            for k in self.qoe_info_list:
                result['QoeInfoList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.qoe_info_list = []
        if m.get('QoeInfoList') is not None:
            for k in m.get('QoeInfoList'):
                temp_model = DescribePlayQoeListResponseBodyQoeInfoList()
                self.qoe_info_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePlayQoeListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePlayQoeListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePlayQoeListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePlayQosListRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        begin_ts: str = None,
        definition: str = None,
        end_ts: str = None,
        item_configs: str = None,
        metric_type: str = None,
        network: str = None,
        os: str = None,
        page_no: int = None,
        page_size: int = None,
        terminal_type: str = None,
    ):
        self.app_name = app_name
        self.begin_ts = begin_ts
        self.definition = definition
        self.end_ts = end_ts
        self.item_configs = item_configs
        self.metric_type = metric_type
        self.network = network
        self.os = os
        self.page_no = page_no
        self.page_size = page_size
        self.terminal_type = terminal_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.begin_ts is not None:
            result['BeginTs'] = self.begin_ts
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.end_ts is not None:
            result['EndTs'] = self.end_ts
        if self.item_configs is not None:
            result['ItemConfigs'] = self.item_configs
        if self.metric_type is not None:
            result['MetricType'] = self.metric_type
        if self.network is not None:
            result['Network'] = self.network
        if self.os is not None:
            result['Os'] = self.os
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.terminal_type is not None:
            result['TerminalType'] = self.terminal_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('BeginTs') is not None:
            self.begin_ts = m.get('BeginTs')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('EndTs') is not None:
            self.end_ts = m.get('EndTs')
        if m.get('ItemConfigs') is not None:
            self.item_configs = m.get('ItemConfigs')
        if m.get('MetricType') is not None:
            self.metric_type = m.get('MetricType')
        if m.get('Network') is not None:
            self.network = m.get('Network')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TerminalType') is not None:
            self.terminal_type = m.get('TerminalType')
        return self


class DescribePlayQosListResponseBodyQosInfoList(TeaModel):
    def __init__(
        self,
        qos_first_frame: str = None,
        qos_kbps: str = None,
        qos_play: str = None,
        qos_play_fail: str = None,
        qos_real_play: str = None,
        qos_seed_fail_rate: str = None,
        qos_stuck_rate: str = None,
        vpsid: str = None,
    ):
        self.qos_first_frame = qos_first_frame
        self.qos_kbps = qos_kbps
        self.qos_play = qos_play
        self.qos_play_fail = qos_play_fail
        self.qos_real_play = qos_real_play
        self.qos_seed_fail_rate = qos_seed_fail_rate
        self.qos_stuck_rate = qos_stuck_rate
        self.vpsid = vpsid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.qos_first_frame is not None:
            result['QosFirstFrame'] = self.qos_first_frame
        if self.qos_kbps is not None:
            result['QosKbps'] = self.qos_kbps
        if self.qos_play is not None:
            result['QosPlay'] = self.qos_play
        if self.qos_play_fail is not None:
            result['QosPlayFail'] = self.qos_play_fail
        if self.qos_real_play is not None:
            result['QosRealPlay'] = self.qos_real_play
        if self.qos_seed_fail_rate is not None:
            result['QosSeedFailRate'] = self.qos_seed_fail_rate
        if self.qos_stuck_rate is not None:
            result['QosStuckRate'] = self.qos_stuck_rate
        if self.vpsid is not None:
            result['Vpsid'] = self.vpsid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QosFirstFrame') is not None:
            self.qos_first_frame = m.get('QosFirstFrame')
        if m.get('QosKbps') is not None:
            self.qos_kbps = m.get('QosKbps')
        if m.get('QosPlay') is not None:
            self.qos_play = m.get('QosPlay')
        if m.get('QosPlayFail') is not None:
            self.qos_play_fail = m.get('QosPlayFail')
        if m.get('QosRealPlay') is not None:
            self.qos_real_play = m.get('QosRealPlay')
        if m.get('QosSeedFailRate') is not None:
            self.qos_seed_fail_rate = m.get('QosSeedFailRate')
        if m.get('QosStuckRate') is not None:
            self.qos_stuck_rate = m.get('QosStuckRate')
        if m.get('Vpsid') is not None:
            self.vpsid = m.get('Vpsid')
        return self


class DescribePlayQosListResponseBody(TeaModel):
    def __init__(
        self,
        page_no: int = None,
        page_size: int = None,
        qos_info_list: List[DescribePlayQosListResponseBodyQosInfoList] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.page_no = page_no
        self.page_size = page_size
        self.qos_info_list = qos_info_list
        # Id
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.qos_info_list:
            for k in self.qos_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['QosInfoList'] = []
        if self.qos_info_list is not None:
            for k in self.qos_info_list:
                result['QosInfoList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.qos_info_list = []
        if m.get('QosInfoList') is not None:
            for k in m.get('QosInfoList'):
                temp_model = DescribePlayQosListResponseBodyQosInfoList()
                self.qos_info_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePlayQosListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePlayQosListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePlayQosListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeQueryConfigsRequest(TeaModel):
    def __init__(
        self,
        type: str = None,
    ):
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeQueryConfigsResponseBodyConfigs(TeaModel):
    def __init__(
        self,
        value: str = None,
    ):
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeQueryConfigsResponseBody(TeaModel):
    def __init__(
        self,
        configs: List[DescribeQueryConfigsResponseBodyConfigs] = None,
        request_id: str = None,
    ):
        self.configs = configs
        # Id
        self.request_id = request_id

    def validate(self):
        if self.configs:
            for k in self.configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Configs'] = []
        if self.configs is not None:
            for k in self.configs:
                result['Configs'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.configs = []
        if m.get('Configs') is not None:
            for k in m.get('Configs'):
                temp_model = DescribeQueryConfigsResponseBodyConfigs()
                self.configs.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeQueryConfigsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeQueryConfigsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeQueryConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DownloadResourceByResourceIdsRequest(TeaModel):
    def __init__(
        self,
        resource_ids: str = None,
    ):
        # 资源id号
        self.resource_ids = resource_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_ids is not None:
            result['ResourceIds'] = self.resource_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceIds') is not None:
            self.resource_ids = m.get('ResourceIds')
        return self


class DownloadResourceByResourceIdsResponseBody(TeaModel):
    def __init__(
        self,
        expire_time: int = None,
        request_id: str = None,
        resource_package_url: str = None,
    ):
        # 过期时间
        self.expire_time = expire_time
        # 请求Id
        self.request_id = request_id
        # 资源地址
        self.resource_package_url = resource_package_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_package_url is not None:
            result['ResourcePackageUrl'] = self.resource_package_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourcePackageUrl') is not None:
            self.resource_package_url = m.get('ResourcePackageUrl')
        return self


class DownloadResourceByResourceIdsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DownloadResourceByResourceIdsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DownloadResourceByResourceIdsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAuditConfigRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
    ):
        self.app_id = app_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        return self


class GetAuditConfigResponseBodyAudit(TeaModel):
    def __init__(
        self,
        channel: str = None,
        create_time: str = None,
        legal_switch: str = None,
        update_time: str = None,
        user_id: str = None,
    ):
        self.channel = channel
        self.create_time = create_time
        self.legal_switch = legal_switch
        self.update_time = update_time
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel is not None:
            result['Channel'] = self.channel
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.legal_switch is not None:
            result['LegalSwitch'] = self.legal_switch
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Channel') is not None:
            self.channel = m.get('Channel')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LegalSwitch') is not None:
            self.legal_switch = m.get('LegalSwitch')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetAuditConfigResponseBody(TeaModel):
    def __init__(
        self,
        audit: GetAuditConfigResponseBodyAudit = None,
        request_id: str = None,
    ):
        self.audit = audit
        self.request_id = request_id

    def validate(self):
        if self.audit:
            self.audit.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audit is not None:
            result['Audit'] = self.audit.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Audit') is not None:
            temp_model = GetAuditConfigResponseBodyAudit()
            self.audit = temp_model.from_map(m['Audit'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAuditConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAuditConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAuditConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCategoriesRequest(TeaModel):
    def __init__(
        self,
        cate_id: int = None,
        page_no: int = None,
        page_size: int = None,
        sort_by: str = None,
        type: str = None,
    ):
        self.cate_id = cate_id
        self.page_no = page_no
        self.page_size = page_size
        self.sort_by = sort_by
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetCategoriesResponseBodyCategory(TeaModel):
    def __init__(
        self,
        cate_id: int = None,
        cate_name: str = None,
        level: int = None,
        parent_id: int = None,
        type: str = None,
    ):
        self.cate_id = cate_id
        self.cate_name = cate_name
        self.level = level
        self.parent_id = parent_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.level is not None:
            result['Level'] = self.level
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetCategoriesResponseBodySubCategoriesCategory(TeaModel):
    def __init__(
        self,
        cate_id: int = None,
        cate_name: str = None,
        level: int = None,
        parent_id: int = None,
        sub_total: int = None,
        type: str = None,
    ):
        self.cate_id = cate_id
        self.cate_name = cate_name
        self.level = level
        self.parent_id = parent_id
        self.sub_total = sub_total
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.level is not None:
            result['Level'] = self.level
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.sub_total is not None:
            result['SubTotal'] = self.sub_total
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('SubTotal') is not None:
            self.sub_total = m.get('SubTotal')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetCategoriesResponseBodySubCategories(TeaModel):
    def __init__(
        self,
        category: List[GetCategoriesResponseBodySubCategoriesCategory] = None,
    ):
        self.category = category

    def validate(self):
        if self.category:
            for k in self.category:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Category'] = []
        if self.category is not None:
            for k in self.category:
                result['Category'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.category = []
        if m.get('Category') is not None:
            for k in m.get('Category'):
                temp_model = GetCategoriesResponseBodySubCategoriesCategory()
                self.category.append(temp_model.from_map(k))
        return self


class GetCategoriesResponseBody(TeaModel):
    def __init__(
        self,
        category: GetCategoriesResponseBodyCategory = None,
        request_id: str = None,
        sub_categories: GetCategoriesResponseBodySubCategories = None,
        sub_total: int = None,
    ):
        self.category = category
        self.request_id = request_id
        self.sub_categories = sub_categories
        self.sub_total = sub_total

    def validate(self):
        if self.category:
            self.category.validate()
        if self.sub_categories:
            self.sub_categories.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sub_categories is not None:
            result['SubCategories'] = self.sub_categories.to_map()
        if self.sub_total is not None:
            result['SubTotal'] = self.sub_total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            temp_model = GetCategoriesResponseBodyCategory()
            self.category = temp_model.from_map(m['Category'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SubCategories') is not None:
            temp_model = GetCategoriesResponseBodySubCategories()
            self.sub_categories = temp_model.from_map(m['SubCategories'])
        if m.get('SubTotal') is not None:
            self.sub_total = m.get('SubTotal')
        return self


class GetCategoriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCategoriesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCategoriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetClientConfigRequest(TeaModel):
    def __init__(
        self,
        bundle_id: str = None,
        pkg_name: str = None,
        pkg_signature: str = None,
    ):
        # 云端配置所对应的IOS BundleId
        self.bundle_id = bundle_id
        # 云端配置所对应的包名。
        self.pkg_name = pkg_name
        # 云端配置所对应的包签名
        self.pkg_signature = pkg_signature

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bundle_id is not None:
            result['BundleId'] = self.bundle_id
        if self.pkg_name is not None:
            result['PkgName'] = self.pkg_name
        if self.pkg_signature is not None:
            result['PkgSignature'] = self.pkg_signature
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BundleId') is not None:
            self.bundle_id = m.get('BundleId')
        if m.get('PkgName') is not None:
            self.pkg_name = m.get('PkgName')
        if m.get('PkgSignature') is not None:
            self.pkg_signature = m.get('PkgSignature')
        return self


class GetClientConfigResponseBody(TeaModel):
    def __init__(
        self,
        client_upload_bucket: str = None,
        client_upload_path: str = None,
        client_upload_storage_status: str = None,
        client_upload_storage_type: str = None,
        request_id: str = None,
    ):
        # oss bucket 名称
        self.client_upload_bucket = client_upload_bucket
        # 路径
        self.client_upload_path = client_upload_path
        # 状态
        self.client_upload_storage_status = client_upload_storage_status
        # 存储类型
        self.client_upload_storage_type = client_upload_storage_type
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_upload_bucket is not None:
            result['ClientUploadBucket'] = self.client_upload_bucket
        if self.client_upload_path is not None:
            result['ClientUploadPath'] = self.client_upload_path
        if self.client_upload_storage_status is not None:
            result['ClientUploadStorageStatus'] = self.client_upload_storage_status
        if self.client_upload_storage_type is not None:
            result['ClientUploadStorageType'] = self.client_upload_storage_type
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientUploadBucket') is not None:
            self.client_upload_bucket = m.get('ClientUploadBucket')
        if m.get('ClientUploadPath') is not None:
            self.client_upload_path = m.get('ClientUploadPath')
        if m.get('ClientUploadStorageStatus') is not None:
            self.client_upload_storage_status = m.get('ClientUploadStorageStatus')
        if m.get('ClientUploadStorageType') is not None:
            self.client_upload_storage_type = m.get('ClientUploadStorageType')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetClientConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetClientConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetClientConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCustomTemplateRequest(TeaModel):
    def __init__(
        self,
        subtype: int = None,
        template_id: str = None,
        type: int = None,
    ):
        self.subtype = subtype
        # 模板ID
        self.template_id = template_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.subtype is not None:
            result['Subtype'] = self.subtype
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Subtype') is not None:
            self.subtype = m.get('Subtype')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetCustomTemplateResponseBodyCustomTemplate(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        is_default: bool = None,
        modified_time: str = None,
        status: str = None,
        subtype: int = None,
        subtype_name: str = None,
        template_config: str = None,
        template_id: str = None,
        template_name: str = None,
        type: int = None,
        type_name: str = None,
    ):
        # 模板创建时间
        self.create_time = create_time
        # 是否默认模板
        self.is_default = is_default
        # 模板修改时间
        self.modified_time = modified_time
        # 模板状态
        self.status = status
        # 模板子类型ID
        self.subtype = subtype
        # 模板子类型名称
        self.subtype_name = subtype_name
        # 模板参数
        self.template_config = template_config
        # 模板Id
        self.template_id = template_id
        # 模板名称
        self.template_name = template_name
        # 模板类型ID
        self.type = type
        # 模板类型名称
        self.type_name = type_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.status is not None:
            result['Status'] = self.status
        if self.subtype is not None:
            result['Subtype'] = self.subtype
        if self.subtype_name is not None:
            result['SubtypeName'] = self.subtype_name
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.type is not None:
            result['Type'] = self.type
        if self.type_name is not None:
            result['TypeName'] = self.type_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Subtype') is not None:
            self.subtype = m.get('Subtype')
        if m.get('SubtypeName') is not None:
            self.subtype_name = m.get('SubtypeName')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('TypeName') is not None:
            self.type_name = m.get('TypeName')
        return self


class GetCustomTemplateResponseBody(TeaModel):
    def __init__(
        self,
        custom_template: GetCustomTemplateResponseBodyCustomTemplate = None,
        request_id: str = None,
    ):
        # 模板信息
        self.custom_template = custom_template
        # 请求ID
        self.request_id = request_id

    def validate(self):
        if self.custom_template:
            self.custom_template.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_template is not None:
            result['CustomTemplate'] = self.custom_template.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CustomTemplate') is not None:
            temp_model = GetCustomTemplateResponseBodyCustomTemplate()
            self.custom_template = temp_model.from_map(m['CustomTemplate'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetCustomTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCustomTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCustomTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDefaultStorageLocationResponseBody(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        path: str = None,
        request_id: str = None,
        status: str = None,
        storage_type: str = None,
    ):
        # oss bucket 名称
        self.bucket = bucket
        # 路径
        self.path = path
        # Id of the request
        self.request_id = request_id
        # 状态
        self.status = status
        # 存储类型
        self.storage_type = storage_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.path is not None:
            result['Path'] = self.path
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        return self


class GetDefaultStorageLocationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDefaultStorageLocationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDefaultStorageLocationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDynamicImageJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetDynamicImageJobResponseBodyDynamicImageJobInputOssFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class GetDynamicImageJobResponseBodyDynamicImageJobInput(TeaModel):
    def __init__(
        self,
        media: str = None,
        oss_file: GetDynamicImageJobResponseBodyDynamicImageJobInputOssFile = None,
        type: str = None,
    ):
        self.media = media
        # 输入类型为媒资ID时的OSS地址
        self.oss_file = oss_file
        self.type = type

    def validate(self):
        if self.oss_file:
            self.oss_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.oss_file is not None:
            result['OssFile'] = self.oss_file.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('OssFile') is not None:
            temp_model = GetDynamicImageJobResponseBodyDynamicImageJobInputOssFile()
            self.oss_file = temp_model.from_map(m['OssFile'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetDynamicImageJobResponseBodyDynamicImageJobOutputOssFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class GetDynamicImageJobResponseBodyDynamicImageJobOutput(TeaModel):
    def __init__(
        self,
        media: str = None,
        oss_file: GetDynamicImageJobResponseBodyDynamicImageJobOutputOssFile = None,
        type: str = None,
    ):
        self.media = media
        # 输出类型为媒资ID时的OSS地址
        self.oss_file = oss_file
        self.type = type

    def validate(self):
        if self.oss_file:
            self.oss_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.oss_file is not None:
            result['OssFile'] = self.oss_file.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('OssFile') is not None:
            temp_model = GetDynamicImageJobResponseBodyDynamicImageJobOutputOssFile()
            self.oss_file = temp_model.from_map(m['OssFile'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetDynamicImageJobResponseBodyDynamicImageJob(TeaModel):
    def __init__(
        self,
        code: str = None,
        create_time: str = None,
        finish_time: str = None,
        input: GetDynamicImageJobResponseBodyDynamicImageJobInput = None,
        job_id: str = None,
        message: str = None,
        modified_time: str = None,
        name: str = None,
        output: GetDynamicImageJobResponseBodyDynamicImageJobOutput = None,
        output_url: str = None,
        pipeline_id: str = None,
        status: str = None,
        submit_time: str = None,
        template_config: str = None,
        template_id: str = None,
        trigger_source: str = None,
        user_data: str = None,
    ):
        self.code = code
        self.create_time = create_time
        self.finish_time = finish_time
        self.input = input
        self.job_id = job_id
        self.message = message
        self.modified_time = modified_time
        self.name = name
        self.output = output
        self.output_url = output_url
        self.pipeline_id = pipeline_id
        self.status = status
        self.submit_time = submit_time
        self.template_config = template_config
        self.template_id = template_id
        self.trigger_source = trigger_source
        self.user_data = user_data

    def validate(self):
        if self.input:
            self.input.validate()
        if self.output:
            self.output.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.message is not None:
            result['Message'] = self.message
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.name is not None:
            result['Name'] = self.name
        if self.output is not None:
            result['Output'] = self.output.to_map()
        if self.output_url is not None:
            result['OutputUrl'] = self.output_url
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.status is not None:
            result['Status'] = self.status
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.trigger_source is not None:
            result['TriggerSource'] = self.trigger_source
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Input') is not None:
            temp_model = GetDynamicImageJobResponseBodyDynamicImageJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Output') is not None:
            temp_model = GetDynamicImageJobResponseBodyDynamicImageJobOutput()
            self.output = temp_model.from_map(m['Output'])
        if m.get('OutputUrl') is not None:
            self.output_url = m.get('OutputUrl')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TriggerSource') is not None:
            self.trigger_source = m.get('TriggerSource')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetDynamicImageJobResponseBody(TeaModel):
    def __init__(
        self,
        dynamic_image_job: GetDynamicImageJobResponseBodyDynamicImageJob = None,
        request_id: str = None,
    ):
        # 截图任务信息
        self.dynamic_image_job = dynamic_image_job
        self.request_id = request_id

    def validate(self):
        if self.dynamic_image_job:
            self.dynamic_image_job.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_image_job is not None:
            result['DynamicImageJob'] = self.dynamic_image_job.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DynamicImageJob') is not None:
            temp_model = GetDynamicImageJobResponseBodyDynamicImageJob()
            self.dynamic_image_job = temp_model.from_map(m['DynamicImageJob'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDynamicImageJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDynamicImageJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDynamicImageJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEditingProjectRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
    ):
        # 云剪辑工程ID
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetEditingProjectResponseBodyProject(TeaModel):
    def __init__(
        self,
        business_config: str = None,
        business_status: str = None,
        clips_param: str = None,
        cover_url: str = None,
        create_source: str = None,
        create_time: str = None,
        description: str = None,
        duration: int = None,
        modified_source: str = None,
        modified_time: str = None,
        project_id: str = None,
        project_type: str = None,
        status: str = None,
        template_id: str = None,
        template_type: str = None,
        timeline: str = None,
        title: str = None,
    ):
        self.business_config = business_config
        self.business_status = business_status
        # 模板素材参数
        self.clips_param = clips_param
        # 云剪辑工程封面
        self.cover_url = cover_url
        # 云剪辑工程创建来源
        self.create_source = create_source
        # 云剪辑工程创建时间
        self.create_time = create_time
        # 云剪辑工程描述
        self.description = description
        # 云剪辑工程总时长
        self.duration = duration
        # 云剪辑工程修改来源
        self.modified_source = modified_source
        # 云剪辑工程最新修改时间
        self.modified_time = modified_time
        # 云剪辑工程ID
        self.project_id = project_id
        self.project_type = project_type
        # 云剪辑工程状态
        self.status = status
        # 模板Id
        self.template_id = template_id
        # 云剪辑工程模板类型
        self.template_type = template_type
        # 云剪辑工程时间线
        self.timeline = timeline
        # 云剪辑工程标题
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_config is not None:
            result['BusinessConfig'] = self.business_config
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        if self.clips_param is not None:
            result['ClipsParam'] = self.clips_param
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.modified_source is not None:
            result['ModifiedSource'] = self.modified_source
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_type is not None:
            result['ProjectType'] = self.project_type
        if self.status is not None:
            result['Status'] = self.status
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        if self.timeline is not None:
            result['Timeline'] = self.timeline
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessConfig') is not None:
            self.business_config = m.get('BusinessConfig')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        if m.get('ClipsParam') is not None:
            self.clips_param = m.get('ClipsParam')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateSource') is not None:
            self.create_source = m.get('CreateSource')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ModifiedSource') is not None:
            self.modified_source = m.get('ModifiedSource')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectType') is not None:
            self.project_type = m.get('ProjectType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        if m.get('Timeline') is not None:
            self.timeline = m.get('Timeline')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class GetEditingProjectResponseBody(TeaModel):
    def __init__(
        self,
        project: GetEditingProjectResponseBodyProject = None,
        request_id: str = None,
    ):
        self.project = project
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.project:
            self.project.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project is not None:
            result['Project'] = self.project.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Project') is not None:
            temp_model = GetEditingProjectResponseBodyProject()
            self.project = temp_model.from_map(m['Project'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetEditingProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetEditingProjectResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEditingProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEditingProjectMaterialsRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
    ):
        # 云剪辑工程ID
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetEditingProjectMaterialsResponseBodyLiveMaterials(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        live_url: str = None,
        stream_name: str = None,
    ):
        self.app_name = app_name
        self.domain_name = domain_name
        self.live_url = live_url
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.live_url is not None:
            result['LiveUrl'] = self.live_url
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('LiveUrl') is not None:
            self.live_url = m.get('LiveUrl')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class GetEditingProjectMaterialsResponseBodyMediaInfosFileInfoListFileBasicInfo(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        duration: str = None,
        file_name: str = None,
        file_size: str = None,
        file_status: str = None,
        file_type: str = None,
        file_url: str = None,
        format_name: str = None,
        height: str = None,
        region: str = None,
        width: str = None,
    ):
        # 码率
        self.bitrate = bitrate
        # 时长
        self.duration = duration
        # 文件名
        self.file_name = file_name
        # 文件大小（字节）
        self.file_size = file_size
        # 文件状态
        self.file_status = file_status
        # 文件类型
        self.file_type = file_type
        # 文件oss地址
        self.file_url = file_url
        # 封装格式
        self.format_name = format_name
        # 高
        self.height = height
        # 文件存储区域
        self.region = region
        # 宽
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetEditingProjectMaterialsResponseBodyMediaInfosFileInfoList(TeaModel):
    def __init__(
        self,
        file_basic_info: GetEditingProjectMaterialsResponseBodyMediaInfosFileInfoListFileBasicInfo = None,
    ):
        # 文件基础信息，包含时长，大小等
        self.file_basic_info = file_basic_info

    def validate(self):
        if self.file_basic_info:
            self.file_basic_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileBasicInfo') is not None:
            temp_model = GetEditingProjectMaterialsResponseBodyMediaInfosFileInfoListFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        return self


class GetEditingProjectMaterialsResponseBodyMediaInfosMediaBasicInfo(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        category: str = None,
        cover_url: str = None,
        create_time: str = None,
        deleted_time: str = None,
        description: str = None,
        input_url: str = None,
        media_id: str = None,
        media_tags: str = None,
        media_type: str = None,
        modified_time: str = None,
        snapshots: str = None,
        source: str = None,
        sprite_images: str = None,
        status: str = None,
        title: str = None,
        transcode_status: str = None,
        user_data: str = None,
    ):
        # 媒资业务类型
        self.business_type = business_type
        # 分类
        self.category = category
        # 封面地址
        self.cover_url = cover_url
        # 媒资创建时间
        self.create_time = create_time
        # 媒资删除时间
        self.deleted_time = deleted_time
        # 内容描述
        self.description = description
        # 待注册的媒资在相应系统中的地址
        self.input_url = input_url
        # MediaId
        self.media_id = media_id
        # 标签
        self.media_tags = media_tags
        # 媒资媒体类型
        self.media_type = media_type
        # 媒资修改时间
        self.modified_time = modified_time
        # 截图
        self.snapshots = snapshots
        # 来源
        self.source = source
        # 雪碧图
        self.sprite_images = sprite_images
        # 资源状态
        self.status = status
        # 标题
        self.title = title
        # 转码状态
        self.transcode_status = transcode_status
        # 用户数据
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.category is not None:
            result['Category'] = self.category
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.deleted_time is not None:
            result['DeletedTime'] = self.deleted_time
        if self.description is not None:
            result['Description'] = self.description
        if self.input_url is not None:
            result['InputURL'] = self.input_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_tags is not None:
            result['MediaTags'] = self.media_tags
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.snapshots is not None:
            result['Snapshots'] = self.snapshots
        if self.source is not None:
            result['Source'] = self.source
        if self.sprite_images is not None:
            result['SpriteImages'] = self.sprite_images
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        if self.transcode_status is not None:
            result['TranscodeStatus'] = self.transcode_status
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeletedTime') is not None:
            self.deleted_time = m.get('DeletedTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InputURL') is not None:
            self.input_url = m.get('InputURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaTags') is not None:
            self.media_tags = m.get('MediaTags')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Snapshots') is not None:
            self.snapshots = m.get('Snapshots')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SpriteImages') is not None:
            self.sprite_images = m.get('SpriteImages')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('TranscodeStatus') is not None:
            self.transcode_status = m.get('TranscodeStatus')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetEditingProjectMaterialsResponseBodyMediaInfos(TeaModel):
    def __init__(
        self,
        file_info_list: List[GetEditingProjectMaterialsResponseBodyMediaInfosFileInfoList] = None,
        media_basic_info: GetEditingProjectMaterialsResponseBodyMediaInfosMediaBasicInfo = None,
        media_id: str = None,
    ):
        # FileInfos
        self.file_info_list = file_info_list
        # BasicInfo
        self.media_basic_info = media_basic_info
        # 媒资ID
        self.media_id = media_id

    def validate(self):
        if self.file_info_list:
            for k in self.file_info_list:
                if k:
                    k.validate()
        if self.media_basic_info:
            self.media_basic_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FileInfoList'] = []
        if self.file_info_list is not None:
            for k in self.file_info_list:
                result['FileInfoList'].append(k.to_map() if k else None)
        if self.media_basic_info is not None:
            result['MediaBasicInfo'] = self.media_basic_info.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.file_info_list = []
        if m.get('FileInfoList') is not None:
            for k in m.get('FileInfoList'):
                temp_model = GetEditingProjectMaterialsResponseBodyMediaInfosFileInfoList()
                self.file_info_list.append(temp_model.from_map(k))
        if m.get('MediaBasicInfo') is not None:
            temp_model = GetEditingProjectMaterialsResponseBodyMediaInfosMediaBasicInfo()
            self.media_basic_info = temp_model.from_map(m['MediaBasicInfo'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class GetEditingProjectMaterialsResponseBody(TeaModel):
    def __init__(
        self,
        live_materials: List[GetEditingProjectMaterialsResponseBodyLiveMaterials] = None,
        media_infos: List[GetEditingProjectMaterialsResponseBodyMediaInfos] = None,
        project_id: str = None,
        project_materials: List[str] = None,
        request_id: str = None,
    ):
        self.live_materials = live_materials
        # 符合要求的媒资集合
        self.media_infos = media_infos
        self.project_id = project_id
        self.project_materials = project_materials
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.live_materials:
            for k in self.live_materials:
                if k:
                    k.validate()
        if self.media_infos:
            for k in self.media_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveMaterials'] = []
        if self.live_materials is not None:
            for k in self.live_materials:
                result['LiveMaterials'].append(k.to_map() if k else None)
        result['MediaInfos'] = []
        if self.media_infos is not None:
            for k in self.media_infos:
                result['MediaInfos'].append(k.to_map() if k else None)
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_materials is not None:
            result['ProjectMaterials'] = self.project_materials
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.live_materials = []
        if m.get('LiveMaterials') is not None:
            for k in m.get('LiveMaterials'):
                temp_model = GetEditingProjectMaterialsResponseBodyLiveMaterials()
                self.live_materials.append(temp_model.from_map(k))
        self.media_infos = []
        if m.get('MediaInfos') is not None:
            for k in m.get('MediaInfos'):
                temp_model = GetEditingProjectMaterialsResponseBodyMediaInfos()
                self.media_infos.append(temp_model.from_map(k))
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectMaterials') is not None:
            self.project_materials = m.get('ProjectMaterials')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetEditingProjectMaterialsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetEditingProjectMaterialsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEditingProjectMaterialsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEventCallbackResponseBody(TeaModel):
    def __init__(
        self,
        auth_key: str = None,
        auth_switch: str = None,
        callback_queue_name: str = None,
        callback_type: str = None,
        callback_url: str = None,
        event_type_list: str = None,
        request_id: str = None,
    ):
        self.auth_key = auth_key
        self.auth_switch = auth_switch
        self.callback_queue_name = callback_queue_name
        self.callback_type = callback_type
        self.callback_url = callback_url
        self.event_type_list = event_type_list
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_key is not None:
            result['AuthKey'] = self.auth_key
        if self.auth_switch is not None:
            result['AuthSwitch'] = self.auth_switch
        if self.callback_queue_name is not None:
            result['CallbackQueueName'] = self.callback_queue_name
        if self.callback_type is not None:
            result['CallbackType'] = self.callback_type
        if self.callback_url is not None:
            result['CallbackURL'] = self.callback_url
        if self.event_type_list is not None:
            result['EventTypeList'] = self.event_type_list
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthKey') is not None:
            self.auth_key = m.get('AuthKey')
        if m.get('AuthSwitch') is not None:
            self.auth_switch = m.get('AuthSwitch')
        if m.get('CallbackQueueName') is not None:
            self.callback_queue_name = m.get('CallbackQueueName')
        if m.get('CallbackType') is not None:
            self.callback_type = m.get('CallbackType')
        if m.get('CallbackURL') is not None:
            self.callback_url = m.get('CallbackURL')
        if m.get('EventTypeList') is not None:
            self.event_type_list = m.get('EventTypeList')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetEventCallbackResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetEventCallbackResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEventCallbackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLiveEditingIndexFileRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        project_id: str = None,
        stream_name: str = None,
    ):
        self.app_name = app_name
        self.domain_name = domain_name
        self.project_id = project_id
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class GetLiveEditingIndexFileResponseBody(TeaModel):
    def __init__(
        self,
        index_file: str = None,
        request_id: str = None,
    ):
        self.index_file = index_file
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index_file is not None:
            result['IndexFile'] = self.index_file
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IndexFile') is not None:
            self.index_file = m.get('IndexFile')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetLiveEditingIndexFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetLiveEditingIndexFileResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetLiveEditingIndexFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLiveEditingJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        # 直播剪辑JobId
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetLiveEditingJobResponseBodyLiveEditingJobLiveStreamConfig(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        domain_name: str = None,
        stream_name: str = None,
    ):
        # 播流所属应用名称
        self.app_name = app_name
        # 播流所属域名
        self.domain_name = domain_name
        # 播流所属流名
        self.stream_name = stream_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class GetLiveEditingJobResponseBodyLiveEditingJobMediaProduceConfig(TeaModel):
    def __init__(
        self,
        mode: str = None,
    ):
        # 剪辑模式，默认Accurate
        self.mode = mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mode is not None:
            result['Mode'] = self.mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        return self


class GetLiveEditingJobResponseBodyLiveEditingJobOutputMediaConfig(TeaModel):
    def __init__(
        self,
        bitrate: int = None,
        file_name: str = None,
        height: int = None,
        media_url: str = None,
        storage_location: str = None,
        vod_template_group_id: str = None,
        width: int = None,
    ):
        # 输出成品的码率，单位为Kbps。可以不填，默认值是多个素材的最高码率
        self.bitrate = bitrate
        # 当 OutputMediaTarget 的目标为 vod-media 时，指定 fileName(包含文件后缀，不含路径）作为输出文件名
        self.file_name = file_name
        # 输出成品的高。可以不填，默认值是多个素材的最大高
        self.height = height
        # 输出成片的文件地址
        self.media_url = media_url
        # 当 OutputMediaTarget 的目标为 vod-media 时， 指定 storage location 来存储媒资到 VOD; storage location 是 VOD 中的文件存储位置， 不包含 http:// 的前缀， 如:  outin-xxxxxx.oss-cn-shanghai.aliyuncs.com
        self.storage_location = storage_location
        # 合成成片输出到vod，指定vod转码模板组。如不需要VOD转码，请填写 "VOD_NO_TRANSCODE".
        self.vod_template_group_id = vod_template_group_id
        # 输出成品的宽。可以不填，默认值是多个素材的最大宽
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.height is not None:
            result['Height'] = self.height
        if self.media_url is not None:
            result['MediaURL'] = self.media_url
        if self.storage_location is not None:
            result['StorageLocation'] = self.storage_location
        if self.vod_template_group_id is not None:
            result['VodTemplateGroupId'] = self.vod_template_group_id
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MediaURL') is not None:
            self.media_url = m.get('MediaURL')
        if m.get('StorageLocation') is not None:
            self.storage_location = m.get('StorageLocation')
        if m.get('VodTemplateGroupId') is not None:
            self.vod_template_group_id = m.get('VodTemplateGroupId')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetLiveEditingJobResponseBodyLiveEditingJob(TeaModel):
    def __init__(
        self,
        clips: str = None,
        code: str = None,
        complete_time: str = None,
        creation_time: str = None,
        job_id: str = None,
        live_stream_config: GetLiveEditingJobResponseBodyLiveEditingJobLiveStreamConfig = None,
        media_id: str = None,
        media_produce_config: GetLiveEditingJobResponseBodyLiveEditingJobMediaProduceConfig = None,
        media_url: str = None,
        message: str = None,
        modified_time: str = None,
        output_media_config: GetLiveEditingJobResponseBodyLiveEditingJobOutputMediaConfig = None,
        project_id: str = None,
        status: str = None,
        user_data: str = None,
    ):
        # 剪辑片段列表
        self.clips = clips
        # 剪辑合成作业错误码  注：作业失败时关注该字段
        self.code = code
        # 直播剪辑作业完成时间，格式为utc时间。  格式为："2021-06-21T08:01:00Z"。
        self.complete_time = complete_time
        # 直播剪辑作业创建时间，格式为utc时间。  格式为："2021-06-21T08:01:00Z"。
        self.creation_time = creation_time
        # 直播剪辑任务ID
        self.job_id = job_id
        # 直播剪辑配置
        self.live_stream_config = live_stream_config
        # 输出成品的资源Id
        self.media_id = media_id
        # 直播剪辑合成配置
        self.media_produce_config = media_produce_config
        # 输出成品的资源文件URL
        self.media_url = media_url
        # 剪辑合成作业错误信息  注：作业失败时关注该字段
        self.message = message
        # 直播剪辑作业修改时间，格式为utc时间。  格式为："2021-06-21T08:01:00Z"。
        self.modified_time = modified_time
        # 输出成片的存储配置
        self.output_media_config = output_media_config
        # 直播剪辑工程ID
        self.project_id = project_id
        # 直播剪辑作业状态，取值可能为如下值：  -Init （初始状态）  -Queuing（排队中）  -Processing（处理中）  -Success（成功）  -Failed（失败）
        self.status = status
        # 用户数据
        self.user_data = user_data

    def validate(self):
        if self.live_stream_config:
            self.live_stream_config.validate()
        if self.media_produce_config:
            self.media_produce_config.validate()
        if self.output_media_config:
            self.output_media_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clips is not None:
            result['Clips'] = self.clips
        if self.code is not None:
            result['Code'] = self.code
        if self.complete_time is not None:
            result['CompleteTime'] = self.complete_time
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.live_stream_config is not None:
            result['LiveStreamConfig'] = self.live_stream_config.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_produce_config is not None:
            result['MediaProduceConfig'] = self.media_produce_config.to_map()
        if self.media_url is not None:
            result['MediaURL'] = self.media_url
        if self.message is not None:
            result['Message'] = self.message
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.output_media_config is not None:
            result['OutputMediaConfig'] = self.output_media_config.to_map()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Clips') is not None:
            self.clips = m.get('Clips')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CompleteTime') is not None:
            self.complete_time = m.get('CompleteTime')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('LiveStreamConfig') is not None:
            temp_model = GetLiveEditingJobResponseBodyLiveEditingJobLiveStreamConfig()
            self.live_stream_config = temp_model.from_map(m['LiveStreamConfig'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaProduceConfig') is not None:
            temp_model = GetLiveEditingJobResponseBodyLiveEditingJobMediaProduceConfig()
            self.media_produce_config = temp_model.from_map(m['MediaProduceConfig'])
        if m.get('MediaURL') is not None:
            self.media_url = m.get('MediaURL')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('OutputMediaConfig') is not None:
            temp_model = GetLiveEditingJobResponseBodyLiveEditingJobOutputMediaConfig()
            self.output_media_config = temp_model.from_map(m['OutputMediaConfig'])
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetLiveEditingJobResponseBody(TeaModel):
    def __init__(
        self,
        live_editing_job: GetLiveEditingJobResponseBodyLiveEditingJob = None,
        request_id: str = None,
    ):
        # 直播剪辑任务
        self.live_editing_job = live_editing_job
        # 请求ID
        self.request_id = request_id

    def validate(self):
        if self.live_editing_job:
            self.live_editing_job.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_editing_job is not None:
            result['LiveEditingJob'] = self.live_editing_job.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LiveEditingJob') is not None:
            temp_model = GetLiveEditingJobResponseBodyLiveEditingJob()
            self.live_editing_job = temp_model.from_map(m['LiveEditingJob'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetLiveEditingJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetLiveEditingJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetLiveEditingJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLiveTranscodeJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        # 模板Id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetLiveTranscodeJobResponseBodyJobOutputStreamStreamInfos(TeaModel):
    def __init__(
        self,
        output_url: str = None,
        type: str = None,
    ):
        self.output_url = output_url
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output_url is not None:
            result['OutputUrl'] = self.output_url
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OutputUrl') is not None:
            self.output_url = m.get('OutputUrl')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetLiveTranscodeJobResponseBodyJobOutputStream(TeaModel):
    def __init__(
        self,
        stream_infos: List[GetLiveTranscodeJobResponseBodyJobOutputStreamStreamInfos] = None,
    ):
        self.stream_infos = stream_infos

    def validate(self):
        if self.stream_infos:
            for k in self.stream_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['StreamInfos'] = []
        if self.stream_infos is not None:
            for k in self.stream_infos:
                result['StreamInfos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.stream_infos = []
        if m.get('StreamInfos') is not None:
            for k in m.get('StreamInfos'):
                temp_model = GetLiveTranscodeJobResponseBodyJobOutputStreamStreamInfos()
                self.stream_infos.append(temp_model.from_map(k))
        return self


class GetLiveTranscodeJobResponseBodyJobStreamInput(TeaModel):
    def __init__(
        self,
        input_url: str = None,
        type: str = None,
    ):
        self.input_url = input_url
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_url is not None:
            result['InputUrl'] = self.input_url
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InputUrl') is not None:
            self.input_url = m.get('InputUrl')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetLiveTranscodeJobResponseBodyJob(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        job_id: str = None,
        name: str = None,
        output_stream: GetLiveTranscodeJobResponseBodyJobOutputStream = None,
        start_mode: int = None,
        status: int = None,
        stream_input: GetLiveTranscodeJobResponseBodyJobStreamInput = None,
        template_id: str = None,
        template_name: str = None,
        template_type: str = None,
    ):
        self.create_time = create_time
        self.job_id = job_id
        self.name = name
        self.output_stream = output_stream
        self.start_mode = start_mode
        self.status = status
        self.stream_input = stream_input
        self.template_id = template_id
        self.template_name = template_name
        self.template_type = template_type

    def validate(self):
        if self.output_stream:
            self.output_stream.validate()
        if self.stream_input:
            self.stream_input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.name is not None:
            result['Name'] = self.name
        if self.output_stream is not None:
            result['OutputStream'] = self.output_stream.to_map()
        if self.start_mode is not None:
            result['StartMode'] = self.start_mode
        if self.status is not None:
            result['Status'] = self.status
        if self.stream_input is not None:
            result['StreamInput'] = self.stream_input.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OutputStream') is not None:
            temp_model = GetLiveTranscodeJobResponseBodyJobOutputStream()
            self.output_stream = temp_model.from_map(m['OutputStream'])
        if m.get('StartMode') is not None:
            self.start_mode = m.get('StartMode')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StreamInput') is not None:
            temp_model = GetLiveTranscodeJobResponseBodyJobStreamInput()
            self.stream_input = temp_model.from_map(m['StreamInput'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        return self


class GetLiveTranscodeJobResponseBody(TeaModel):
    def __init__(
        self,
        job: GetLiveTranscodeJobResponseBodyJob = None,
        request_id: str = None,
    ):
        self.job = job
        # 请求ID
        self.request_id = request_id

    def validate(self):
        if self.job:
            self.job.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job is not None:
            result['Job'] = self.job.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Job') is not None:
            temp_model = GetLiveTranscodeJobResponseBodyJob()
            self.job = temp_model.from_map(m['Job'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetLiveTranscodeJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetLiveTranscodeJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetLiveTranscodeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLiveTranscodeTemplateRequest(TeaModel):
    def __init__(
        self,
        template_id: str = None,
    ):
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetLiveTranscodeTemplateResponseBodyTemplateContentTemplateConfigAudioParams(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        channels: str = None,
        codec: str = None,
        profile: str = None,
        samplerate: str = None,
    ):
        self.bitrate = bitrate
        self.channels = channels
        self.codec = codec
        self.profile = profile
        self.samplerate = samplerate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        return self


class GetLiveTranscodeTemplateResponseBodyTemplateContentTemplateConfigVideoParams(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        codec: str = None,
        fps: str = None,
        gop: str = None,
        height: str = None,
        profile: str = None,
        width: str = None,
    ):
        self.bitrate = bitrate
        self.codec = codec
        self.fps = fps
        self.gop = gop
        self.height = height
        self.profile = profile
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetLiveTranscodeTemplateResponseBodyTemplateContentTemplateConfig(TeaModel):
    def __init__(
        self,
        audio_params: GetLiveTranscodeTemplateResponseBodyTemplateContentTemplateConfigAudioParams = None,
        video_params: GetLiveTranscodeTemplateResponseBodyTemplateContentTemplateConfigVideoParams = None,
    ):
        self.audio_params = audio_params
        self.video_params = video_params

    def validate(self):
        if self.audio_params:
            self.audio_params.validate()
        if self.video_params:
            self.video_params.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_params is not None:
            result['AudioParams'] = self.audio_params.to_map()
        if self.video_params is not None:
            result['VideoParams'] = self.video_params.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AudioParams') is not None:
            temp_model = GetLiveTranscodeTemplateResponseBodyTemplateContentTemplateConfigAudioParams()
            self.audio_params = temp_model.from_map(m['AudioParams'])
        if m.get('VideoParams') is not None:
            temp_model = GetLiveTranscodeTemplateResponseBodyTemplateContentTemplateConfigVideoParams()
            self.video_params = temp_model.from_map(m['VideoParams'])
        return self


class GetLiveTranscodeTemplateResponseBodyTemplateContent(TeaModel):
    def __init__(
        self,
        category: str = None,
        create_time: str = None,
        name: str = None,
        template_config: GetLiveTranscodeTemplateResponseBodyTemplateContentTemplateConfig = None,
        template_id: str = None,
        type: str = None,
    ):
        self.category = category
        self.create_time = create_time
        self.name = name
        self.template_config = template_config
        self.template_id = template_id
        self.type = type

    def validate(self):
        if self.template_config:
            self.template_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.name is not None:
            result['Name'] = self.name
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TemplateConfig') is not None:
            temp_model = GetLiveTranscodeTemplateResponseBodyTemplateContentTemplateConfig()
            self.template_config = temp_model.from_map(m['TemplateConfig'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetLiveTranscodeTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template_content: GetLiveTranscodeTemplateResponseBodyTemplateContent = None,
    ):
        # 请求ID
        self.request_id = request_id
        self.template_content = template_content

    def validate(self):
        if self.template_content:
            self.template_content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_content is not None:
            result['TemplateContent'] = self.template_content.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateContent') is not None:
            temp_model = GetLiveTranscodeTemplateResponseBodyTemplateContent()
            self.template_content = temp_model.from_map(m['TemplateContent'])
        return self


class GetLiveTranscodeTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetLiveTranscodeTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetLiveTranscodeTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMediaAuditResultRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        media_id: str = None,
    ):
        self.app_id = app_id
        self.media_id = media_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class GetMediaAuditResultResponseBodyAudioResult(TeaModel):
    def __init__(
        self,
        label: str = None,
        scene: str = None,
        score: str = None,
        suggestion: str = None,
    ):
        self.label = label
        self.scene = scene
        self.score = score
        self.suggestion = suggestion

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.score is not None:
            result['Score'] = self.score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class GetMediaAuditResultResponseBodyCoverResult(TeaModel):
    def __init__(
        self,
        label: str = None,
        scene: str = None,
        score: str = None,
        suggestion: str = None,
    ):
        self.label = label
        self.scene = scene
        self.score = score
        self.suggestion = suggestion

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.score is not None:
            result['Score'] = self.score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class GetMediaAuditResultResponseBodyDescResult(TeaModel):
    def __init__(
        self,
        label: str = None,
        scene: str = None,
        score: str = None,
        suggestion: str = None,
    ):
        self.label = label
        self.scene = scene
        self.score = score
        self.suggestion = suggestion

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.score is not None:
            result['Score'] = self.score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class GetMediaAuditResultResponseBodyMediaAuditResult(TeaModel):
    def __init__(
        self,
        abnormal_modules: str = None,
        label: str = None,
        suggestion: str = None,
    ):
        self.abnormal_modules = abnormal_modules
        self.label = label
        self.suggestion = suggestion

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abnormal_modules is not None:
            result['AbnormalModules'] = self.abnormal_modules
        if self.label is not None:
            result['Label'] = self.label
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AbnormalModules') is not None:
            self.abnormal_modules = m.get('AbnormalModules')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class GetMediaAuditResultResponseBodyTitleResult(TeaModel):
    def __init__(
        self,
        label: str = None,
        scene: str = None,
        score: str = None,
        suggestion: str = None,
    ):
        self.label = label
        self.scene = scene
        self.score = score
        self.suggestion = suggestion

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.score is not None:
            result['Score'] = self.score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class GetMediaAuditResultResponseBodyVideoResult(TeaModel):
    def __init__(
        self,
        label: str = None,
        scene: str = None,
        score: str = None,
        suggestion: str = None,
    ):
        self.label = label
        self.scene = scene
        self.score = score
        self.suggestion = suggestion

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.score is not None:
            result['Score'] = self.score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class GetMediaAuditResultResponseBody(TeaModel):
    def __init__(
        self,
        audio_result: GetMediaAuditResultResponseBodyAudioResult = None,
        cover_result: GetMediaAuditResultResponseBodyCoverResult = None,
        desc_result: GetMediaAuditResultResponseBodyDescResult = None,
        media_audit_result: GetMediaAuditResultResponseBodyMediaAuditResult = None,
        request_id: str = None,
        title_result: GetMediaAuditResultResponseBodyTitleResult = None,
        video_result: GetMediaAuditResultResponseBodyVideoResult = None,
    ):
        self.audio_result = audio_result
        self.cover_result = cover_result
        self.desc_result = desc_result
        self.media_audit_result = media_audit_result
        # RequestId
        self.request_id = request_id
        self.title_result = title_result
        self.video_result = video_result

    def validate(self):
        if self.audio_result:
            self.audio_result.validate()
        if self.cover_result:
            self.cover_result.validate()
        if self.desc_result:
            self.desc_result.validate()
        if self.media_audit_result:
            self.media_audit_result.validate()
        if self.title_result:
            self.title_result.validate()
        if self.video_result:
            self.video_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_result is not None:
            result['AudioResult'] = self.audio_result.to_map()
        if self.cover_result is not None:
            result['CoverResult'] = self.cover_result.to_map()
        if self.desc_result is not None:
            result['DescResult'] = self.desc_result.to_map()
        if self.media_audit_result is not None:
            result['MediaAuditResult'] = self.media_audit_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.title_result is not None:
            result['TitleResult'] = self.title_result.to_map()
        if self.video_result is not None:
            result['VideoResult'] = self.video_result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AudioResult') is not None:
            temp_model = GetMediaAuditResultResponseBodyAudioResult()
            self.audio_result = temp_model.from_map(m['AudioResult'])
        if m.get('CoverResult') is not None:
            temp_model = GetMediaAuditResultResponseBodyCoverResult()
            self.cover_result = temp_model.from_map(m['CoverResult'])
        if m.get('DescResult') is not None:
            temp_model = GetMediaAuditResultResponseBodyDescResult()
            self.desc_result = temp_model.from_map(m['DescResult'])
        if m.get('MediaAuditResult') is not None:
            temp_model = GetMediaAuditResultResponseBodyMediaAuditResult()
            self.media_audit_result = temp_model.from_map(m['MediaAuditResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TitleResult') is not None:
            temp_model = GetMediaAuditResultResponseBodyTitleResult()
            self.title_result = temp_model.from_map(m['TitleResult'])
        if m.get('VideoResult') is not None:
            temp_model = GetMediaAuditResultResponseBodyVideoResult()
            self.video_result = temp_model.from_map(m['VideoResult'])
        return self


class GetMediaAuditResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMediaAuditResultResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMediaAuditResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMediaAuditResultDetailRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        media_id: str = None,
    ):
        self.app_id = app_id
        self.media_id = media_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class GetMediaAuditResultDetailResponseBodyAuditResultDetails(TeaModel):
    def __init__(
        self,
        ad_label: str = None,
        ad_score: str = None,
        live_label: str = None,
        live_score: str = None,
        logo_label: str = None,
        logo_score: str = None,
        porn_label: str = None,
        porn_score: str = None,
        terrorism_label: str = None,
        terrorism_score: str = None,
        timestamp: str = None,
        url: str = None,
    ):
        self.ad_label = ad_label
        self.ad_score = ad_score
        self.live_label = live_label
        self.live_score = live_score
        self.logo_label = logo_label
        self.logo_score = logo_score
        self.porn_label = porn_label
        self.porn_score = porn_score
        self.terrorism_label = terrorism_label
        self.terrorism_score = terrorism_score
        self.timestamp = timestamp
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ad_label is not None:
            result['AdLabel'] = self.ad_label
        if self.ad_score is not None:
            result['AdScore'] = self.ad_score
        if self.live_label is not None:
            result['LiveLabel'] = self.live_label
        if self.live_score is not None:
            result['LiveScore'] = self.live_score
        if self.logo_label is not None:
            result['LogoLabel'] = self.logo_label
        if self.logo_score is not None:
            result['LogoScore'] = self.logo_score
        if self.porn_label is not None:
            result['PornLabel'] = self.porn_label
        if self.porn_score is not None:
            result['PornScore'] = self.porn_score
        if self.terrorism_label is not None:
            result['TerrorismLabel'] = self.terrorism_label
        if self.terrorism_score is not None:
            result['TerrorismScore'] = self.terrorism_score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdLabel') is not None:
            self.ad_label = m.get('AdLabel')
        if m.get('AdScore') is not None:
            self.ad_score = m.get('AdScore')
        if m.get('LiveLabel') is not None:
            self.live_label = m.get('LiveLabel')
        if m.get('LiveScore') is not None:
            self.live_score = m.get('LiveScore')
        if m.get('LogoLabel') is not None:
            self.logo_label = m.get('LogoLabel')
        if m.get('LogoScore') is not None:
            self.logo_score = m.get('LogoScore')
        if m.get('PornLabel') is not None:
            self.porn_label = m.get('PornLabel')
        if m.get('PornScore') is not None:
            self.porn_score = m.get('PornScore')
        if m.get('TerrorismLabel') is not None:
            self.terrorism_label = m.get('TerrorismLabel')
        if m.get('TerrorismScore') is not None:
            self.terrorism_score = m.get('TerrorismScore')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class GetMediaAuditResultDetailResponseBody(TeaModel):
    def __init__(
        self,
        audit_result_details: List[GetMediaAuditResultDetailResponseBodyAuditResultDetails] = None,
        request_id: str = None,
        total: str = None,
    ):
        self.audit_result_details = audit_result_details
        # RequestId
        self.request_id = request_id
        self.total = total

    def validate(self):
        if self.audit_result_details:
            for k in self.audit_result_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AuditResultDetails'] = []
        if self.audit_result_details is not None:
            for k in self.audit_result_details:
                result['AuditResultDetails'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.audit_result_details = []
        if m.get('AuditResultDetails') is not None:
            for k in m.get('AuditResultDetails'):
                temp_model = GetMediaAuditResultDetailResponseBodyAuditResultDetails()
                self.audit_result_details.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetMediaAuditResultDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMediaAuditResultDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMediaAuditResultDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMediaInfoRequest(TeaModel):
    def __init__(
        self,
        input_url: str = None,
        media_id: str = None,
        output_type: str = None,
    ):
        self.input_url = input_url
        self.media_id = media_id
        self.output_type = output_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_url is not None:
            result['InputURL'] = self.input_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.output_type is not None:
            result['OutputType'] = self.output_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InputURL') is not None:
            self.input_url = m.get('InputURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('OutputType') is not None:
            self.output_type = m.get('OutputType')
        return self


class GetMediaInfoResponseBodyMediaInfoFileInfoListAudioStreamInfoList(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        channel_layout: str = None,
        channels: str = None,
        codec_long_name: str = None,
        codec_name: str = None,
        codec_tag: str = None,
        codec_tag_string: str = None,
        codec_time_base: str = None,
        duration: str = None,
        fps: str = None,
        index: str = None,
        lang: str = None,
        num_frames: str = None,
        profile: str = None,
        sample_fmt: str = None,
        sample_rate: str = None,
        start_time: str = None,
        timebase: str = None,
    ):
        # 码率
        self.bitrate = bitrate
        # 声道输出样式
        self.channel_layout = channel_layout
        # 声道数
        self.channels = channels
        # 编码格式长述名
        self.codec_long_name = codec_long_name
        # 编码格式简述名
        self.codec_name = codec_name
        # 编码格式标记
        self.codec_tag = codec_tag
        # 编码格式标记文本
        self.codec_tag_string = codec_tag_string
        # 编码时基
        self.codec_time_base = codec_time_base
        # 时长
        self.duration = duration
        # 音频帧率
        self.fps = fps
        # 音频流序号
        self.index = index
        # 语言
        self.lang = lang
        # 总帧数
        self.num_frames = num_frames
        # 编码预置
        self.profile = profile
        # 采样格式
        self.sample_fmt = sample_fmt
        # 采样率
        self.sample_rate = sample_rate
        # 起始时间
        self.start_time = start_time
        # 时基
        self.timebase = timebase

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.sample_rate is not None:
            result['SampleRate'] = self.sample_rate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('SampleRate') is not None:
            self.sample_rate = m.get('SampleRate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class GetMediaInfoResponseBodyMediaInfoFileInfoListFileBasicInfo(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        create_time: str = None,
        duration: str = None,
        file_name: str = None,
        file_size: str = None,
        file_status: str = None,
        file_type: str = None,
        file_url: str = None,
        format_name: str = None,
        height: str = None,
        modified_time: str = None,
        region: str = None,
        width: str = None,
    ):
        # 码率
        self.bitrate = bitrate
        self.create_time = create_time
        # 时长
        self.duration = duration
        # 文件名
        self.file_name = file_name
        # 文件大小（字节）
        self.file_size = file_size
        # 文件状态
        self.file_status = file_status
        # 文件类型
        self.file_type = file_type
        # 文件oss地址
        self.file_url = file_url
        # 封装格式
        self.format_name = format_name
        # 高
        self.height = height
        self.modified_time = modified_time
        # 文件存储区域
        self.region = region
        # 宽
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetMediaInfoResponseBodyMediaInfoFileInfoListSubtitleStreamInfoList(TeaModel):
    def __init__(
        self,
        codec_long_name: str = None,
        codec_name: str = None,
        codec_tag: str = None,
        codec_tag_string: str = None,
        codec_time_base: str = None,
        duration: str = None,
        index: str = None,
        lang: str = None,
        start_time: str = None,
        timebase: str = None,
    ):
        # 编码格式长述名
        self.codec_long_name = codec_long_name
        # 编码格式简述名
        self.codec_name = codec_name
        # 编码格式标记
        self.codec_tag = codec_tag
        # 编码格式标记文本
        self.codec_tag_string = codec_tag_string
        # 编码时基
        self.codec_time_base = codec_time_base
        # 时长
        self.duration = duration
        # 音频流序号
        self.index = index
        # 语言
        self.lang = lang
        # 起始时间
        self.start_time = start_time
        # 时基
        self.timebase = timebase

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class GetMediaInfoResponseBodyMediaInfoFileInfoListVideoStreamInfoList(TeaModel):
    def __init__(
        self,
        avg_fps: str = None,
        bitrate: str = None,
        codec_long_name: str = None,
        codec_name: str = None,
        codec_tag: str = None,
        codec_tag_string: str = None,
        codec_time_base: str = None,
        dar: str = None,
        duration: str = None,
        fps: str = None,
        has_bframes: str = None,
        height: str = None,
        index: str = None,
        lang: str = None,
        level: str = None,
        nb_frames: str = None,
        num_frames: str = None,
        pix_fmt: str = None,
        profile: str = None,
        rotate: str = None,
        sar: str = None,
        start_time: str = None,
        timebase: str = None,
        width: str = None,
    ):
        # 平均帧率
        self.avg_fps = avg_fps
        # 码率
        self.bitrate = bitrate
        # 编码格式长述名
        self.codec_long_name = codec_long_name
        # 编码格式简述名
        self.codec_name = codec_name
        # 编码格式标记
        self.codec_tag = codec_tag
        # 编码格式标记文本
        self.codec_tag_string = codec_tag_string
        # 编码时基
        self.codec_time_base = codec_time_base
        # 编码显示分辨率比
        self.dar = dar
        # 时长
        self.duration = duration
        # 视频帧率
        self.fps = fps
        # 是否有B帧
        self.has_bframes = has_bframes
        # 高
        self.height = height
        # 视频流序号
        self.index = index
        # 语言
        self.lang = lang
        # 编码等级
        self.level = level
        # 总帧数
        self.nb_frames = nb_frames
        # 总帧数
        self.num_frames = num_frames
        # 像素格式
        self.pix_fmt = pix_fmt
        # 编码预置
        self.profile = profile
        # 旋转
        self.rotate = rotate
        # 编码信号分辨率比
        self.sar = sar
        # 起始时间
        self.start_time = start_time
        # 时基
        self.timebase = timebase
        # 宽
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_fps is not None:
            result['AvgFPS'] = self.avg_fps
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.has_bframes is not None:
            result['HasBFrames'] = self.has_bframes
        if self.height is not None:
            result['Height'] = self.height
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.level is not None:
            result['Level'] = self.level
        if self.nb_frames is not None:
            result['Nb_frames'] = self.nb_frames
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgFPS') is not None:
            self.avg_fps = m.get('AvgFPS')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('HasBFrames') is not None:
            self.has_bframes = m.get('HasBFrames')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Nb_frames') is not None:
            self.nb_frames = m.get('Nb_frames')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetMediaInfoResponseBodyMediaInfoFileInfoList(TeaModel):
    def __init__(
        self,
        audio_stream_info_list: List[GetMediaInfoResponseBodyMediaInfoFileInfoListAudioStreamInfoList] = None,
        file_basic_info: GetMediaInfoResponseBodyMediaInfoFileInfoListFileBasicInfo = None,
        subtitle_stream_info_list: List[GetMediaInfoResponseBodyMediaInfoFileInfoListSubtitleStreamInfoList] = None,
        video_stream_info_list: List[GetMediaInfoResponseBodyMediaInfoFileInfoListVideoStreamInfoList] = None,
    ):
        # 音频流信息，一个媒资可能有多条音频流
        self.audio_stream_info_list = audio_stream_info_list
        # 文件基础信息，包含时长，大小等
        self.file_basic_info = file_basic_info
        # 字幕流信息，一个媒资可能有多条字幕流
        self.subtitle_stream_info_list = subtitle_stream_info_list
        # 视频流信息，一个媒资可能有多条视频流
        self.video_stream_info_list = video_stream_info_list

    def validate(self):
        if self.audio_stream_info_list:
            for k in self.audio_stream_info_list:
                if k:
                    k.validate()
        if self.file_basic_info:
            self.file_basic_info.validate()
        if self.subtitle_stream_info_list:
            for k in self.subtitle_stream_info_list:
                if k:
                    k.validate()
        if self.video_stream_info_list:
            for k in self.video_stream_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStreamInfoList'] = []
        if self.audio_stream_info_list is not None:
            for k in self.audio_stream_info_list:
                result['AudioStreamInfoList'].append(k.to_map() if k else None)
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        result['SubtitleStreamInfoList'] = []
        if self.subtitle_stream_info_list is not None:
            for k in self.subtitle_stream_info_list:
                result['SubtitleStreamInfoList'].append(k.to_map() if k else None)
        result['VideoStreamInfoList'] = []
        if self.video_stream_info_list is not None:
            for k in self.video_stream_info_list:
                result['VideoStreamInfoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.audio_stream_info_list = []
        if m.get('AudioStreamInfoList') is not None:
            for k in m.get('AudioStreamInfoList'):
                temp_model = GetMediaInfoResponseBodyMediaInfoFileInfoListAudioStreamInfoList()
                self.audio_stream_info_list.append(temp_model.from_map(k))
        if m.get('FileBasicInfo') is not None:
            temp_model = GetMediaInfoResponseBodyMediaInfoFileInfoListFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        self.subtitle_stream_info_list = []
        if m.get('SubtitleStreamInfoList') is not None:
            for k in m.get('SubtitleStreamInfoList'):
                temp_model = GetMediaInfoResponseBodyMediaInfoFileInfoListSubtitleStreamInfoList()
                self.subtitle_stream_info_list.append(temp_model.from_map(k))
        self.video_stream_info_list = []
        if m.get('VideoStreamInfoList') is not None:
            for k in m.get('VideoStreamInfoList'):
                temp_model = GetMediaInfoResponseBodyMediaInfoFileInfoListVideoStreamInfoList()
                self.video_stream_info_list.append(temp_model.from_map(k))
        return self


class GetMediaInfoResponseBodyMediaInfoMediaBasicInfo(TeaModel):
    def __init__(
        self,
        biz: str = None,
        business_type: str = None,
        cate_id: int = None,
        cate_name: str = None,
        category: str = None,
        cover_url: str = None,
        create_time: str = None,
        deleted_time: str = None,
        description: str = None,
        input_url: str = None,
        media_id: str = None,
        media_tags: str = None,
        media_type: str = None,
        modified_time: str = None,
        source: str = None,
        sprite_images: str = None,
        status: str = None,
        title: str = None,
        upload_source: str = None,
        user_data: str = None,
    ):
        self.biz = biz
        # 媒资业务类型
        self.business_type = business_type
        self.cate_id = cate_id
        self.cate_name = cate_name
        # 分类
        self.category = category
        # 封面地址
        self.cover_url = cover_url
        # 媒资创建时间
        self.create_time = create_time
        # 媒资删除时间
        self.deleted_time = deleted_time
        # 内容描述
        self.description = description
        # 待注册的媒资在相应系统中的地址
        self.input_url = input_url
        # MediaId
        self.media_id = media_id
        # 标签
        self.media_tags = media_tags
        # 媒资媒体类型
        self.media_type = media_type
        # 媒资修改时间
        self.modified_time = modified_time
        # 来源
        self.source = source
        # 雪碧图
        self.sprite_images = sprite_images
        # 资源状态
        self.status = status
        # 标题
        self.title = title
        self.upload_source = upload_source
        # 用户数据
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz is not None:
            result['Biz'] = self.biz
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.cate_name is not None:
            result['CateName'] = self.cate_name
        if self.category is not None:
            result['Category'] = self.category
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.deleted_time is not None:
            result['DeletedTime'] = self.deleted_time
        if self.description is not None:
            result['Description'] = self.description
        if self.input_url is not None:
            result['InputURL'] = self.input_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_tags is not None:
            result['MediaTags'] = self.media_tags
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.source is not None:
            result['Source'] = self.source
        if self.sprite_images is not None:
            result['SpriteImages'] = self.sprite_images
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        if self.upload_source is not None:
            result['UploadSource'] = self.upload_source
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Biz') is not None:
            self.biz = m.get('Biz')
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('CateName') is not None:
            self.cate_name = m.get('CateName')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeletedTime') is not None:
            self.deleted_time = m.get('DeletedTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InputURL') is not None:
            self.input_url = m.get('InputURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaTags') is not None:
            self.media_tags = m.get('MediaTags')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SpriteImages') is not None:
            self.sprite_images = m.get('SpriteImages')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UploadSource') is not None:
            self.upload_source = m.get('UploadSource')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetMediaInfoResponseBodyMediaInfo(TeaModel):
    def __init__(
        self,
        file_info_list: List[GetMediaInfoResponseBodyMediaInfoFileInfoList] = None,
        media_basic_info: GetMediaInfoResponseBodyMediaInfoMediaBasicInfo = None,
        media_id: str = None,
    ):
        # FileInfos
        self.file_info_list = file_info_list
        # BasicInfo
        self.media_basic_info = media_basic_info
        # 媒资ID
        self.media_id = media_id

    def validate(self):
        if self.file_info_list:
            for k in self.file_info_list:
                if k:
                    k.validate()
        if self.media_basic_info:
            self.media_basic_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FileInfoList'] = []
        if self.file_info_list is not None:
            for k in self.file_info_list:
                result['FileInfoList'].append(k.to_map() if k else None)
        if self.media_basic_info is not None:
            result['MediaBasicInfo'] = self.media_basic_info.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.file_info_list = []
        if m.get('FileInfoList') is not None:
            for k in m.get('FileInfoList'):
                temp_model = GetMediaInfoResponseBodyMediaInfoFileInfoList()
                self.file_info_list.append(temp_model.from_map(k))
        if m.get('MediaBasicInfo') is not None:
            temp_model = GetMediaInfoResponseBodyMediaInfoMediaBasicInfo()
            self.media_basic_info = temp_model.from_map(m['MediaBasicInfo'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class GetMediaInfoResponseBody(TeaModel):
    def __init__(
        self,
        media_info: GetMediaInfoResponseBodyMediaInfo = None,
        request_id: str = None,
    ):
        self.media_info = media_info
        # RequestId
        self.request_id = request_id

    def validate(self):
        if self.media_info:
            self.media_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_info is not None:
            result['MediaInfo'] = self.media_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaInfo') is not None:
            temp_model = GetMediaInfoResponseBodyMediaInfo()
            self.media_info = temp_model.from_map(m['MediaInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMediaInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMediaInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMediaInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMediaInfoJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        # 任务 id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetMediaInfoJobResponseBodyMediaInfoJobInput(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        # 媒体值：
        #       type 为 OSS 时，为 url, 支持 oss 协议和 http 协议；
        #       type 为 Media 时，为媒资 id。
        self.media = media
        # 媒体对象类型 - OSS: oss文件, Media: 媒资 ID
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoPropertyAudioStreamInfoList(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        channel_layout: str = None,
        channels: str = None,
        codec_long_name: str = None,
        codec_name: str = None,
        codec_tag: str = None,
        codec_tag_string: str = None,
        codec_time_base: str = None,
        duration: str = None,
        index: str = None,
        lang: str = None,
        sample_fmt: str = None,
        sample_rate: str = None,
        start_time: str = None,
        timebase: str = None,
    ):
        # 码率
        self.bitrate = bitrate
        # 声道布局
        self.channel_layout = channel_layout
        # 声道数
        self.channels = channels
        # 编码格式名
        self.codec_long_name = codec_long_name
        # 编码格式
        self.codec_name = codec_name
        # 编码器标签
        self.codec_tag = codec_tag
        # 编码器标签名
        self.codec_tag_string = codec_tag_string
        # 编码器时间基
        self.codec_time_base = codec_time_base
        # 时长
        self.duration = duration
        # 流序号
        self.index = index
        # 语言
        self.lang = lang
        self.sample_fmt = sample_fmt
        # 采样率
        self.sample_rate = sample_rate
        # 开始时间
        self.start_time = start_time
        # 时间基
        self.timebase = timebase

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.sample_rate is not None:
            result['SampleRate'] = self.sample_rate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('SampleRate') is not None:
            self.sample_rate = m.get('SampleRate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoPropertyFileBasicInfo(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        duration: str = None,
        file_name: str = None,
        file_size: str = None,
        file_status: str = None,
        file_type: str = None,
        file_url: str = None,
        format_name: str = None,
        height: str = None,
        media_id: str = None,
        region: str = None,
        width: str = None,
    ):
        # 视频码率
        self.bitrate = bitrate
        # 视频时长
        self.duration = duration
        # 文件名
        self.file_name = file_name
        # 文件大小
        self.file_size = file_size
        # 文件状态
        self.file_status = file_status
        # 文件类型
        self.file_type = file_type
        # 文件url
        self.file_url = file_url
        # 视频格式名称
        self.format_name = format_name
        # 高
        self.height = height
        # 媒资ID
        self.media_id = media_id
        # 文件所在区域
        self.region = region
        # 宽
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoPropertyVideoStreamInfoList(TeaModel):
    def __init__(
        self,
        avg_fps: str = None,
        bit_rate: str = None,
        codec_long_name: str = None,
        codec_name: str = None,
        codec_tag: str = None,
        codec_tag_string: str = None,
        codec_time_base: str = None,
        dar: str = None,
        duration: str = None,
        fps: str = None,
        has_bframes: str = None,
        height: str = None,
        index: str = None,
        lang: str = None,
        level: str = None,
        num_frames: str = None,
        pix_fmt: str = None,
        profile: str = None,
        rotate: str = None,
        sar: str = None,
        start_time: str = None,
        time_base: str = None,
        width: str = None,
    ):
        self.avg_fps = avg_fps
        self.bit_rate = bit_rate
        # 编码格式名
        self.codec_long_name = codec_long_name
        # 编码格式
        self.codec_name = codec_name
        # 编码格式标记
        self.codec_tag = codec_tag
        # 编码格式标记文本
        self.codec_tag_string = codec_tag_string
        self.codec_time_base = codec_time_base
        # 图像显示宽高比
        self.dar = dar
        # 时长
        self.duration = duration
        # 帧率
        self.fps = fps
        self.has_bframes = has_bframes
        # 高
        self.height = height
        # 流序号
        self.index = index
        # 语言
        self.lang = lang
        # 编码等级
        self.level = level
        # 总帧数
        self.num_frames = num_frames
        # 颜色存储格式
        self.pix_fmt = pix_fmt
        # 编码器预设
        self.profile = profile
        # 视频画面旋转角度
        self.rotate = rotate
        # 采集点数宽高比
        self.sar = sar
        # 起始时间
        self.start_time = start_time
        self.time_base = time_base
        # 宽
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_fps is not None:
            result['Avg_fps'] = self.avg_fps
        if self.bit_rate is not None:
            result['Bit_rate'] = self.bit_rate
        if self.codec_long_name is not None:
            result['Codec_long_name'] = self.codec_long_name
        if self.codec_name is not None:
            result['Codec_name'] = self.codec_name
        if self.codec_tag is not None:
            result['Codec_tag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['Codec_tag_string'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['Codec_time_base'] = self.codec_time_base
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.has_bframes is not None:
            result['Has_b_frames'] = self.has_bframes
        if self.height is not None:
            result['Height'] = self.height
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.level is not None:
            result['Level'] = self.level
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.start_time is not None:
            result['Start_time'] = self.start_time
        if self.time_base is not None:
            result['Time_base'] = self.time_base
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Avg_fps') is not None:
            self.avg_fps = m.get('Avg_fps')
        if m.get('Bit_rate') is not None:
            self.bit_rate = m.get('Bit_rate')
        if m.get('Codec_long_name') is not None:
            self.codec_long_name = m.get('Codec_long_name')
        if m.get('Codec_name') is not None:
            self.codec_name = m.get('Codec_name')
        if m.get('Codec_tag') is not None:
            self.codec_tag = m.get('Codec_tag')
        if m.get('Codec_tag_string') is not None:
            self.codec_tag_string = m.get('Codec_tag_string')
        if m.get('Codec_time_base') is not None:
            self.codec_time_base = m.get('Codec_time_base')
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Has_b_frames') is not None:
            self.has_bframes = m.get('Has_b_frames')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('Start_time') is not None:
            self.start_time = m.get('Start_time')
        if m.get('Time_base') is not None:
            self.time_base = m.get('Time_base')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoProperty(TeaModel):
    def __init__(
        self,
        audio_stream_info_list: List[GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoPropertyAudioStreamInfoList] = None,
        file_basic_info: GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoPropertyFileBasicInfo = None,
        video_stream_info_list: List[GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoPropertyVideoStreamInfoList] = None,
    ):
        # 音频流信息
        self.audio_stream_info_list = audio_stream_info_list
        # 基础文件信息
        self.file_basic_info = file_basic_info
        # 视频流信息
        self.video_stream_info_list = video_stream_info_list

    def validate(self):
        if self.audio_stream_info_list:
            for k in self.audio_stream_info_list:
                if k:
                    k.validate()
        if self.file_basic_info:
            self.file_basic_info.validate()
        if self.video_stream_info_list:
            for k in self.video_stream_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStreamInfoList'] = []
        if self.audio_stream_info_list is not None:
            for k in self.audio_stream_info_list:
                result['AudioStreamInfoList'].append(k.to_map() if k else None)
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        result['VideoStreamInfoList'] = []
        if self.video_stream_info_list is not None:
            for k in self.video_stream_info_list:
                result['VideoStreamInfoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.audio_stream_info_list = []
        if m.get('AudioStreamInfoList') is not None:
            for k in m.get('AudioStreamInfoList'):
                temp_model = GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoPropertyAudioStreamInfoList()
                self.audio_stream_info_list.append(temp_model.from_map(k))
        if m.get('FileBasicInfo') is not None:
            temp_model = GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoPropertyFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        self.video_stream_info_list = []
        if m.get('VideoStreamInfoList') is not None:
            for k in m.get('VideoStreamInfoList'):
                temp_model = GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoPropertyVideoStreamInfoList()
                self.video_stream_info_list.append(temp_model.from_map(k))
        return self


class GetMediaInfoJobResponseBodyMediaInfoJobScheduleConfig(TeaModel):
    def __init__(
        self,
        pipeline_id: str = None,
        priority: int = None,
    ):
        # 管道 id
        self.pipeline_id = pipeline_id
        # 任务优先级，取值范围：1~10
        self.priority = priority

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        return self


class GetMediaInfoJobResponseBodyMediaInfoJob(TeaModel):
    def __init__(
        self,
        async_: bool = None,
        finish_time: str = None,
        input: GetMediaInfoJobResponseBodyMediaInfoJobInput = None,
        job_id: str = None,
        media_info_property: GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoProperty = None,
        name: str = None,
        request_id: str = None,
        schedule_config: GetMediaInfoJobResponseBodyMediaInfoJobScheduleConfig = None,
        status: str = None,
        submit_result_json: Dict[str, Any] = None,
        submit_time: str = None,
        trigger_source: str = None,
        user_data: str = None,
    ):
        # 是否异步处理
        self.async_ = async_
        # 任务完成时间
        self.finish_time = finish_time
        # 任务输入
        self.input = input
        # 任务 id
        self.job_id = job_id
        # 媒体信息详情
        self.media_info_property = media_info_property
        # 任务名字
        self.name = name
        # 请求 id
        self.request_id = request_id
        # 调度信息
        self.schedule_config = schedule_config
        # 任务状态 - Init: 已提交, Success: 成功, Fail: 失败
        self.status = status
        # 任务提交信息
        self.submit_result_json = submit_result_json
        # 任务提交时间
        self.submit_time = submit_time
        # 任务来源 - API, WorkFlow, Console
        self.trigger_source = trigger_source
        # 用户数据
        self.user_data = user_data

    def validate(self):
        if self.input:
            self.input.validate()
        if self.media_info_property:
            self.media_info_property.validate()
        if self.schedule_config:
            self.schedule_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.async_ is not None:
            result['Async'] = self.async_
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.media_info_property is not None:
            result['MediaInfoProperty'] = self.media_info_property.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.schedule_config is not None:
            result['ScheduleConfig'] = self.schedule_config.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.submit_result_json is not None:
            result['SubmitResultJson'] = self.submit_result_json
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        if self.trigger_source is not None:
            result['TriggerSource'] = self.trigger_source
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Async') is not None:
            self.async_ = m.get('Async')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Input') is not None:
            temp_model = GetMediaInfoJobResponseBodyMediaInfoJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MediaInfoProperty') is not None:
            temp_model = GetMediaInfoJobResponseBodyMediaInfoJobMediaInfoProperty()
            self.media_info_property = temp_model.from_map(m['MediaInfoProperty'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScheduleConfig') is not None:
            temp_model = GetMediaInfoJobResponseBodyMediaInfoJobScheduleConfig()
            self.schedule_config = temp_model.from_map(m['ScheduleConfig'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubmitResultJson') is not None:
            self.submit_result_json = m.get('SubmitResultJson')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        if m.get('TriggerSource') is not None:
            self.trigger_source = m.get('TriggerSource')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetMediaInfoJobResponseBody(TeaModel):
    def __init__(
        self,
        media_info_job: GetMediaInfoJobResponseBodyMediaInfoJob = None,
        request_id: str = None,
    ):
        # MediaInfoJobDTO
        self.media_info_job = media_info_job
        # 请求 id
        self.request_id = request_id

    def validate(self):
        if self.media_info_job:
            self.media_info_job.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_info_job is not None:
            result['MediaInfoJob'] = self.media_info_job.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaInfoJob') is not None:
            temp_model = GetMediaInfoJobResponseBodyMediaInfoJob()
            self.media_info_job = temp_model.from_map(m['MediaInfoJob'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMediaInfoJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMediaInfoJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMediaInfoJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMediaProducingJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetMediaProducingJobResponseBodyMediaProducingJob(TeaModel):
    def __init__(
        self,
        clips_param: str = None,
        code: str = None,
        complete_time: str = None,
        create_time: str = None,
        duration: float = None,
        job_id: str = None,
        media_id: str = None,
        media_url: str = None,
        message: str = None,
        modified_time: str = None,
        project_id: str = None,
        status: str = None,
        template_id: str = None,
        timeline: str = None,
        vod_media_id: str = None,
    ):
        self.clips_param = clips_param
        self.code = code
        self.complete_time = complete_time
        self.create_time = create_time
        self.duration = duration
        self.job_id = job_id
        self.media_id = media_id
        self.media_url = media_url
        self.message = message
        self.modified_time = modified_time
        self.project_id = project_id
        self.status = status
        self.template_id = template_id
        self.timeline = timeline
        self.vod_media_id = vod_media_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clips_param is not None:
            result['ClipsParam'] = self.clips_param
        if self.code is not None:
            result['Code'] = self.code
        if self.complete_time is not None:
            result['CompleteTime'] = self.complete_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_url is not None:
            result['MediaURL'] = self.media_url
        if self.message is not None:
            result['Message'] = self.message
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.timeline is not None:
            result['Timeline'] = self.timeline
        if self.vod_media_id is not None:
            result['VodMediaId'] = self.vod_media_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClipsParam') is not None:
            self.clips_param = m.get('ClipsParam')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CompleteTime') is not None:
            self.complete_time = m.get('CompleteTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaURL') is not None:
            self.media_url = m.get('MediaURL')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Timeline') is not None:
            self.timeline = m.get('Timeline')
        if m.get('VodMediaId') is not None:
            self.vod_media_id = m.get('VodMediaId')
        return self


class GetMediaProducingJobResponseBody(TeaModel):
    def __init__(
        self,
        media_producing_job: GetMediaProducingJobResponseBodyMediaProducingJob = None,
        request_id: str = None,
    ):
        self.media_producing_job = media_producing_job
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.media_producing_job:
            self.media_producing_job.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_producing_job is not None:
            result['MediaProducingJob'] = self.media_producing_job.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaProducingJob') is not None:
            temp_model = GetMediaProducingJobResponseBodyMediaProducingJob()
            self.media_producing_job = temp_model.from_map(m['MediaProducingJob'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMediaProducingJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMediaProducingJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMediaProducingJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPipelineRequest(TeaModel):
    def __init__(
        self,
        pipeline_id: str = None,
    ):
        # 管道ID
        self.pipeline_id = pipeline_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        return self


class GetPipelineResponseBodyPipeline(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        modified_time: str = None,
        name: str = None,
        pipeline_id: str = None,
        priority: int = None,
        speed: str = None,
        status: str = None,
    ):
        # 模板创建时间
        self.create_time = create_time
        # 模板修改时间
        self.modified_time = modified_time
        # 管道名称
        self.name = name
        # 管道Id
        self.pipeline_id = pipeline_id
        # 管道优先级
        self.priority = priority
        # 管道类型
        self.speed = speed
        # 管道状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.name is not None:
            result['Name'] = self.name
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.speed is not None:
            result['Speed'] = self.speed
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetPipelineResponseBody(TeaModel):
    def __init__(
        self,
        pipeline: GetPipelineResponseBodyPipeline = None,
        request_id: str = None,
    ):
        # 管道信息
        self.pipeline = pipeline
        # 请求ID
        self.request_id = request_id

    def validate(self):
        if self.pipeline:
            self.pipeline.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline is not None:
            result['Pipeline'] = self.pipeline.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Pipeline') is not None:
            temp_model = GetPipelineResponseBodyPipeline()
            self.pipeline = temp_model.from_map(m['Pipeline'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetPipelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPipelineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPlayInfoRequest(TeaModel):
    def __init__(
        self,
        media_id: str = None,
    ):
        self.media_id = media_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class GetPlayInfoResponseBodyMediaBase(TeaModel):
    def __init__(
        self,
        cover_url: str = None,
        creation_time: str = None,
        media_id: str = None,
        media_type: str = None,
        status: str = None,
        title: str = None,
    ):
        self.cover_url = cover_url
        self.creation_time = creation_time
        self.media_id = media_id
        self.media_type = media_type
        self.status = status
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class GetPlayInfoResponseBodyPlayInfoList(TeaModel):
    def __init__(
        self,
        bit_depth: int = None,
        bitrate: str = None,
        creation_time: str = None,
        definition: str = None,
        duration: str = None,
        encrypt: int = None,
        encrypt_type: str = None,
        file_url: str = None,
        format: str = None,
        fps: str = None,
        hdrtype: str = None,
        height: int = None,
        modification_time: str = None,
        narrow_band_type: str = None,
        play_url: str = None,
        size: int = None,
        status: str = None,
        stream_type: str = None,
        trans_template_type: str = None,
        watermark_id: str = None,
        width: int = None,
    ):
        # 颜色位深
        self.bit_depth = bit_depth
        self.bitrate = bitrate
        self.creation_time = creation_time
        self.definition = definition
        self.duration = duration
        self.encrypt = encrypt
        self.encrypt_type = encrypt_type
        self.file_url = file_url
        self.format = format
        self.fps = fps
        # 视频流HDR类型
        self.hdrtype = hdrtype
        self.height = height
        self.modification_time = modification_time
        self.narrow_band_type = narrow_band_type
        self.play_url = play_url
        self.size = size
        self.status = status
        self.stream_type = stream_type
        self.trans_template_type = trans_template_type
        self.watermark_id = watermark_id
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bit_depth is not None:
            result['BitDepth'] = self.bit_depth
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.definition is not None:
            result['Definition'] = self.definition
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.encrypt is not None:
            result['Encrypt'] = self.encrypt
        if self.encrypt_type is not None:
            result['EncryptType'] = self.encrypt_type
        if self.file_url is not None:
            result['FileURL'] = self.file_url
        if self.format is not None:
            result['Format'] = self.format
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.hdrtype is not None:
            result['HDRType'] = self.hdrtype
        if self.height is not None:
            result['Height'] = self.height
        if self.modification_time is not None:
            result['ModificationTime'] = self.modification_time
        if self.narrow_band_type is not None:
            result['NarrowBandType'] = self.narrow_band_type
        if self.play_url is not None:
            result['PlayURL'] = self.play_url
        if self.size is not None:
            result['Size'] = self.size
        if self.status is not None:
            result['Status'] = self.status
        if self.stream_type is not None:
            result['StreamType'] = self.stream_type
        if self.trans_template_type is not None:
            result['TransTemplateType'] = self.trans_template_type
        if self.watermark_id is not None:
            result['WatermarkId'] = self.watermark_id
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BitDepth') is not None:
            self.bit_depth = m.get('BitDepth')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Definition') is not None:
            self.definition = m.get('Definition')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Encrypt') is not None:
            self.encrypt = m.get('Encrypt')
        if m.get('EncryptType') is not None:
            self.encrypt_type = m.get('EncryptType')
        if m.get('FileURL') is not None:
            self.file_url = m.get('FileURL')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('HDRType') is not None:
            self.hdrtype = m.get('HDRType')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('ModificationTime') is not None:
            self.modification_time = m.get('ModificationTime')
        if m.get('NarrowBandType') is not None:
            self.narrow_band_type = m.get('NarrowBandType')
        if m.get('PlayURL') is not None:
            self.play_url = m.get('PlayURL')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StreamType') is not None:
            self.stream_type = m.get('StreamType')
        if m.get('TransTemplateType') is not None:
            self.trans_template_type = m.get('TransTemplateType')
        if m.get('WatermarkId') is not None:
            self.watermark_id = m.get('WatermarkId')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetPlayInfoResponseBody(TeaModel):
    def __init__(
        self,
        media_base: GetPlayInfoResponseBodyMediaBase = None,
        play_info_list: List[GetPlayInfoResponseBodyPlayInfoList] = None,
        request_id: str = None,
    ):
        self.media_base = media_base
        self.play_info_list = play_info_list
        # RequestId
        self.request_id = request_id

    def validate(self):
        if self.media_base:
            self.media_base.validate()
        if self.play_info_list:
            for k in self.play_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_base is not None:
            result['MediaBase'] = self.media_base.to_map()
        result['PlayInfoList'] = []
        if self.play_info_list is not None:
            for k in self.play_info_list:
                result['PlayInfoList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaBase') is not None:
            temp_model = GetPlayInfoResponseBodyMediaBase()
            self.media_base = temp_model.from_map(m['MediaBase'])
        self.play_info_list = []
        if m.get('PlayInfoList') is not None:
            for k in m.get('PlayInfoList'):
                temp_model = GetPlayInfoResponseBodyPlayInfoList()
                self.play_info_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetPlayInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPlayInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPlayInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPublicMediaInfoRequest(TeaModel):
    def __init__(
        self,
        media_id: str = None,
    ):
        self.media_id = media_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class GetPublicMediaInfoResponseBodyMediaInfoDynamicMetaData(TeaModel):
    def __init__(
        self,
        data: str = None,
        type: str = None,
    ):
        # 元数据json
        self.data = data
        # 类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetPublicMediaInfoResponseBodyMediaInfoFileInfoListAudioStreamInfoList(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        channel_layout: str = None,
        channels: str = None,
        codec_long_name: str = None,
        codec_name: str = None,
        codec_tag: str = None,
        codec_tag_string: str = None,
        codec_time_base: str = None,
        duration: str = None,
        fps: str = None,
        index: str = None,
        lang: str = None,
        num_frames: str = None,
        profile: str = None,
        sample_fmt: str = None,
        sample_rate: str = None,
        start_time: str = None,
        timebase: str = None,
    ):
        # 码率
        self.bitrate = bitrate
        # 声道输出样式
        self.channel_layout = channel_layout
        # 声道数
        self.channels = channels
        # 编码格式长述名
        self.codec_long_name = codec_long_name
        # 编码格式简述名
        self.codec_name = codec_name
        # 编码格式标记
        self.codec_tag = codec_tag
        # 编码格式标记文本
        self.codec_tag_string = codec_tag_string
        # 编码时基
        self.codec_time_base = codec_time_base
        # 时长
        self.duration = duration
        # 音频帧率
        self.fps = fps
        # 音频流序号
        self.index = index
        # 语言
        self.lang = lang
        # 总帧数
        self.num_frames = num_frames
        # 编码预置
        self.profile = profile
        # 采样格式
        self.sample_fmt = sample_fmt
        # 采样率
        self.sample_rate = sample_rate
        # 起始时间
        self.start_time = start_time
        # 时基
        self.timebase = timebase

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.sample_rate is not None:
            result['SampleRate'] = self.sample_rate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('SampleRate') is not None:
            self.sample_rate = m.get('SampleRate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class GetPublicMediaInfoResponseBodyMediaInfoFileInfoListFileBasicInfo(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        duration: str = None,
        file_name: str = None,
        file_size: str = None,
        file_status: str = None,
        file_type: str = None,
        file_url: str = None,
        format_name: str = None,
        height: str = None,
        region: str = None,
        width: str = None,
    ):
        # 码率
        self.bitrate = bitrate
        # 时长
        self.duration = duration
        # 文件名
        self.file_name = file_name
        # 文件大小（字节）
        self.file_size = file_size
        # 文件状态
        self.file_status = file_status
        # 文件类型
        self.file_type = file_type
        # 文件oss地址
        self.file_url = file_url
        # 封装格式
        self.format_name = format_name
        # 高
        self.height = height
        # 文件存储区域
        self.region = region
        # 宽
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetPublicMediaInfoResponseBodyMediaInfoFileInfoListSubtitleStreamInfoList(TeaModel):
    def __init__(
        self,
        codec_long_name: str = None,
        codec_name: str = None,
        codec_tag: str = None,
        codec_tag_string: str = None,
        codec_time_base: str = None,
        duration: str = None,
        index: str = None,
        lang: str = None,
        start_time: str = None,
        timebase: str = None,
    ):
        # 编码格式长述名
        self.codec_long_name = codec_long_name
        # 编码格式简述名
        self.codec_name = codec_name
        # 编码格式标记
        self.codec_tag = codec_tag
        # 编码格式标记文本
        self.codec_tag_string = codec_tag_string
        # 编码时基
        self.codec_time_base = codec_time_base
        # 时长
        self.duration = duration
        # 音频流序号
        self.index = index
        # 语言
        self.lang = lang
        # 起始时间
        self.start_time = start_time
        # 时基
        self.timebase = timebase

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class GetPublicMediaInfoResponseBodyMediaInfoFileInfoListVideoStreamInfoList(TeaModel):
    def __init__(
        self,
        avg_fps: str = None,
        bitrate: str = None,
        codec_long_name: str = None,
        codec_name: str = None,
        codec_tag: str = None,
        codec_tag_string: str = None,
        codec_time_base: str = None,
        dar: str = None,
        duration: str = None,
        fps: str = None,
        has_bframes: str = None,
        height: str = None,
        index: str = None,
        lang: str = None,
        level: str = None,
        nb_frames: str = None,
        num_frames: str = None,
        pix_fmt: str = None,
        profile: str = None,
        rotate: str = None,
        sar: str = None,
        start_time: str = None,
        timebase: str = None,
        width: str = None,
    ):
        # 平均帧率
        self.avg_fps = avg_fps
        # 码率
        self.bitrate = bitrate
        # 编码格式长述名
        self.codec_long_name = codec_long_name
        # 编码格式简述名
        self.codec_name = codec_name
        # 编码格式标记
        self.codec_tag = codec_tag
        # 编码格式标记文本
        self.codec_tag_string = codec_tag_string
        # 编码时基
        self.codec_time_base = codec_time_base
        # 编码显示分辨率比
        self.dar = dar
        # 时长
        self.duration = duration
        # 视频帧率
        self.fps = fps
        # 是否有B帧
        self.has_bframes = has_bframes
        # 高
        self.height = height
        # 视频流序号
        self.index = index
        # 语言
        self.lang = lang
        # 编码等级
        self.level = level
        # 总帧数
        self.nb_frames = nb_frames
        # 总帧数
        self.num_frames = num_frames
        # 像素格式
        self.pix_fmt = pix_fmt
        # 编码预置
        self.profile = profile
        # 旋转
        self.rotate = rotate
        # 编码信号分辨率比
        self.sar = sar
        # 起始时间
        self.start_time = start_time
        # 时基
        self.timebase = timebase
        # 宽
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_fps is not None:
            result['AvgFPS'] = self.avg_fps
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.has_bframes is not None:
            result['HasBFrames'] = self.has_bframes
        if self.height is not None:
            result['Height'] = self.height
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.level is not None:
            result['Level'] = self.level
        if self.nb_frames is not None:
            result['Nb_frames'] = self.nb_frames
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgFPS') is not None:
            self.avg_fps = m.get('AvgFPS')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('HasBFrames') is not None:
            self.has_bframes = m.get('HasBFrames')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Nb_frames') is not None:
            self.nb_frames = m.get('Nb_frames')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetPublicMediaInfoResponseBodyMediaInfoFileInfoList(TeaModel):
    def __init__(
        self,
        audio_stream_info_list: List[GetPublicMediaInfoResponseBodyMediaInfoFileInfoListAudioStreamInfoList] = None,
        file_basic_info: GetPublicMediaInfoResponseBodyMediaInfoFileInfoListFileBasicInfo = None,
        subtitle_stream_info_list: List[GetPublicMediaInfoResponseBodyMediaInfoFileInfoListSubtitleStreamInfoList] = None,
        video_stream_info_list: List[GetPublicMediaInfoResponseBodyMediaInfoFileInfoListVideoStreamInfoList] = None,
    ):
        # 音频流信息，一个媒资可能有多条音频流
        self.audio_stream_info_list = audio_stream_info_list
        # 文件基础信息，包含时长，大小等
        self.file_basic_info = file_basic_info
        # 字幕流信息，一个媒资可能有多条字幕流
        self.subtitle_stream_info_list = subtitle_stream_info_list
        # 视频流信息，一个媒资可能有多条视频流
        self.video_stream_info_list = video_stream_info_list

    def validate(self):
        if self.audio_stream_info_list:
            for k in self.audio_stream_info_list:
                if k:
                    k.validate()
        if self.file_basic_info:
            self.file_basic_info.validate()
        if self.subtitle_stream_info_list:
            for k in self.subtitle_stream_info_list:
                if k:
                    k.validate()
        if self.video_stream_info_list:
            for k in self.video_stream_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStreamInfoList'] = []
        if self.audio_stream_info_list is not None:
            for k in self.audio_stream_info_list:
                result['AudioStreamInfoList'].append(k.to_map() if k else None)
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        result['SubtitleStreamInfoList'] = []
        if self.subtitle_stream_info_list is not None:
            for k in self.subtitle_stream_info_list:
                result['SubtitleStreamInfoList'].append(k.to_map() if k else None)
        result['VideoStreamInfoList'] = []
        if self.video_stream_info_list is not None:
            for k in self.video_stream_info_list:
                result['VideoStreamInfoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.audio_stream_info_list = []
        if m.get('AudioStreamInfoList') is not None:
            for k in m.get('AudioStreamInfoList'):
                temp_model = GetPublicMediaInfoResponseBodyMediaInfoFileInfoListAudioStreamInfoList()
                self.audio_stream_info_list.append(temp_model.from_map(k))
        if m.get('FileBasicInfo') is not None:
            temp_model = GetPublicMediaInfoResponseBodyMediaInfoFileInfoListFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        self.subtitle_stream_info_list = []
        if m.get('SubtitleStreamInfoList') is not None:
            for k in m.get('SubtitleStreamInfoList'):
                temp_model = GetPublicMediaInfoResponseBodyMediaInfoFileInfoListSubtitleStreamInfoList()
                self.subtitle_stream_info_list.append(temp_model.from_map(k))
        self.video_stream_info_list = []
        if m.get('VideoStreamInfoList') is not None:
            for k in m.get('VideoStreamInfoList'):
                temp_model = GetPublicMediaInfoResponseBodyMediaInfoFileInfoListVideoStreamInfoList()
                self.video_stream_info_list.append(temp_model.from_map(k))
        return self


class GetPublicMediaInfoResponseBodyMediaInfoMediaBasicInfo(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        category: str = None,
        cover_url: str = None,
        create_time: str = None,
        deleted_time: str = None,
        description: str = None,
        media_id: str = None,
        media_tags: str = None,
        media_type: str = None,
        modified_time: str = None,
        source: str = None,
        sprite_images: str = None,
        status: str = None,
        title: str = None,
        user_data: str = None,
    ):
        # 媒资业务类型
        self.business_type = business_type
        # 分类
        self.category = category
        # 封面地址
        self.cover_url = cover_url
        # 媒资创建时间
        self.create_time = create_time
        # 媒资删除时间
        self.deleted_time = deleted_time
        # 内容描述
        self.description = description
        # MediaId
        self.media_id = media_id
        # 标签
        self.media_tags = media_tags
        # 媒资媒体类型
        self.media_type = media_type
        # 媒资修改时间
        self.modified_time = modified_time
        # 来源
        self.source = source
        # 雪碧图
        self.sprite_images = sprite_images
        # 资源状态
        self.status = status
        # 标题
        self.title = title
        # 用户数据
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.category is not None:
            result['Category'] = self.category
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.deleted_time is not None:
            result['DeletedTime'] = self.deleted_time
        if self.description is not None:
            result['Description'] = self.description
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_tags is not None:
            result['MediaTags'] = self.media_tags
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.source is not None:
            result['Source'] = self.source
        if self.sprite_images is not None:
            result['SpriteImages'] = self.sprite_images
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeletedTime') is not None:
            self.deleted_time = m.get('DeletedTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaTags') is not None:
            self.media_tags = m.get('MediaTags')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SpriteImages') is not None:
            self.sprite_images = m.get('SpriteImages')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetPublicMediaInfoResponseBodyMediaInfo(TeaModel):
    def __init__(
        self,
        dynamic_meta_data: GetPublicMediaInfoResponseBodyMediaInfoDynamicMetaData = None,
        file_info_list: List[GetPublicMediaInfoResponseBodyMediaInfoFileInfoList] = None,
        media_basic_info: GetPublicMediaInfoResponseBodyMediaInfoMediaBasicInfo = None,
        media_id: str = None,
    ):
        # 公共媒资动态元数据
        self.dynamic_meta_data = dynamic_meta_data
        # FileInfos
        self.file_info_list = file_info_list
        # BasicInfo
        self.media_basic_info = media_basic_info
        # 媒资ID
        self.media_id = media_id

    def validate(self):
        if self.dynamic_meta_data:
            self.dynamic_meta_data.validate()
        if self.file_info_list:
            for k in self.file_info_list:
                if k:
                    k.validate()
        if self.media_basic_info:
            self.media_basic_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_meta_data is not None:
            result['DynamicMetaData'] = self.dynamic_meta_data.to_map()
        result['FileInfoList'] = []
        if self.file_info_list is not None:
            for k in self.file_info_list:
                result['FileInfoList'].append(k.to_map() if k else None)
        if self.media_basic_info is not None:
            result['MediaBasicInfo'] = self.media_basic_info.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DynamicMetaData') is not None:
            temp_model = GetPublicMediaInfoResponseBodyMediaInfoDynamicMetaData()
            self.dynamic_meta_data = temp_model.from_map(m['DynamicMetaData'])
        self.file_info_list = []
        if m.get('FileInfoList') is not None:
            for k in m.get('FileInfoList'):
                temp_model = GetPublicMediaInfoResponseBodyMediaInfoFileInfoList()
                self.file_info_list.append(temp_model.from_map(k))
        if m.get('MediaBasicInfo') is not None:
            temp_model = GetPublicMediaInfoResponseBodyMediaInfoMediaBasicInfo()
            self.media_basic_info = temp_model.from_map(m['MediaBasicInfo'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class GetPublicMediaInfoResponseBody(TeaModel):
    def __init__(
        self,
        media_info: GetPublicMediaInfoResponseBodyMediaInfo = None,
        request_id: str = None,
    ):
        self.media_info = media_info
        # RequestId
        self.request_id = request_id

    def validate(self):
        if self.media_info:
            self.media_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_info is not None:
            result['MediaInfo'] = self.media_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaInfo') is not None:
            temp_model = GetPublicMediaInfoResponseBodyMediaInfo()
            self.media_info = temp_model.from_map(m['MediaInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetPublicMediaInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPublicMediaInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPublicMediaInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSmartHandleJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        # 任务Id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetSmartHandleJobResponseBodySmartJobInfoInputConfig(TeaModel):
    def __init__(
        self,
        input_file: str = None,
    ):
        # OSS地址 或 内容库素材ID
        self.input_file = input_file

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_file is not None:
            result['InputFile'] = self.input_file
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InputFile') is not None:
            self.input_file = m.get('InputFile')
        return self


class GetSmartHandleJobResponseBodySmartJobInfoOutputConfig(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        object: str = None,
    ):
        # OSS Bucket
        self.bucket = bucket
        # OSS Object
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class GetSmartHandleJobResponseBodySmartJobInfo(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        description: str = None,
        input_config: GetSmartHandleJobResponseBodySmartJobInfoInputConfig = None,
        job_type: str = None,
        modified_time: str = None,
        output_config: GetSmartHandleJobResponseBodySmartJobInfoOutputConfig = None,
        title: str = None,
        user_id: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 任务描述
        self.description = description
        # 输入参数
        self.input_config = input_config
        # 任务类型
        self.job_type = job_type
        # 修改时间
        self.modified_time = modified_time
        # 输出配置
        self.output_config = output_config
        # 任务标题
        self.title = title
        # userid
        self.user_id = user_id

    def validate(self):
        if self.input_config:
            self.input_config.validate()
        if self.output_config:
            self.output_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.input_config is not None:
            result['InputConfig'] = self.input_config.to_map()
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.output_config is not None:
            result['OutputConfig'] = self.output_config.to_map()
        if self.title is not None:
            result['Title'] = self.title
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InputConfig') is not None:
            temp_model = GetSmartHandleJobResponseBodySmartJobInfoInputConfig()
            self.input_config = temp_model.from_map(m['InputConfig'])
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('OutputConfig') is not None:
            temp_model = GetSmartHandleJobResponseBodySmartJobInfoOutputConfig()
            self.output_config = temp_model.from_map(m['OutputConfig'])
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetSmartHandleJobResponseBody(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        output: str = None,
        request_id: str = None,
        smart_job_info: GetSmartHandleJobResponseBodySmartJobInfo = None,
        state: str = None,
        user_data: str = None,
    ):
        # 任务Id
        self.job_id = job_id
        # 任务结果
        self.output = output
        # 请求Id
        self.request_id = request_id
        # 智能任务信息
        self.smart_job_info = smart_job_info
        # 任务状态
        self.state = state
        # 用户自定义信息
        self.user_data = user_data

    def validate(self):
        if self.smart_job_info:
            self.smart_job_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.output is not None:
            result['Output'] = self.output
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.smart_job_info is not None:
            result['SmartJobInfo'] = self.smart_job_info.to_map()
        if self.state is not None:
            result['State'] = self.state
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Output') is not None:
            self.output = m.get('Output')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SmartJobInfo') is not None:
            temp_model = GetSmartHandleJobResponseBodySmartJobInfo()
            self.smart_job_info = temp_model.from_map(m['SmartJobInfo'])
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetSmartHandleJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSmartHandleJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSmartHandleJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSnapshotJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetSnapshotJobResponseBodySnapshotJobInputOssFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class GetSnapshotJobResponseBodySnapshotJobInput(TeaModel):
    def __init__(
        self,
        media: str = None,
        oss_file: GetSnapshotJobResponseBodySnapshotJobInputOssFile = None,
        type: str = None,
    ):
        self.media = media
        # 输入类型为媒资ID时的OSS地址
        self.oss_file = oss_file
        self.type = type

    def validate(self):
        if self.oss_file:
            self.oss_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.oss_file is not None:
            result['OssFile'] = self.oss_file.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('OssFile') is not None:
            temp_model = GetSnapshotJobResponseBodySnapshotJobInputOssFile()
            self.oss_file = temp_model.from_map(m['OssFile'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetSnapshotJobResponseBodySnapshotJobOutputOssFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class GetSnapshotJobResponseBodySnapshotJobOutput(TeaModel):
    def __init__(
        self,
        media: str = None,
        oss_file: GetSnapshotJobResponseBodySnapshotJobOutputOssFile = None,
        type: str = None,
    ):
        self.media = media
        # 输出类型为媒资ID时的OSS地址
        self.oss_file = oss_file
        self.type = type

    def validate(self):
        if self.oss_file:
            self.oss_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.oss_file is not None:
            result['OssFile'] = self.oss_file.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('OssFile') is not None:
            temp_model = GetSnapshotJobResponseBodySnapshotJobOutputOssFile()
            self.oss_file = temp_model.from_map(m['OssFile'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetSnapshotJobResponseBodySnapshotJob(TeaModel):
    def __init__(
        self,
        async_: bool = None,
        code: str = None,
        count: int = None,
        create_time: str = None,
        finish_time: str = None,
        input: GetSnapshotJobResponseBodySnapshotJobInput = None,
        job_id: str = None,
        message: str = None,
        modified_time: str = None,
        name: str = None,
        output: GetSnapshotJobResponseBodySnapshotJobOutput = None,
        pipeline_id: str = None,
        status: str = None,
        submit_time: str = None,
        template_config: str = None,
        template_id: str = None,
        trigger_source: str = None,
        type: str = None,
        user_data: str = None,
    ):
        self.async_ = async_
        self.code = code
        self.count = count
        self.create_time = create_time
        self.finish_time = finish_time
        self.input = input
        self.job_id = job_id
        self.message = message
        self.modified_time = modified_time
        self.name = name
        self.output = output
        self.pipeline_id = pipeline_id
        self.status = status
        self.submit_time = submit_time
        self.template_config = template_config
        self.template_id = template_id
        self.trigger_source = trigger_source
        self.type = type
        self.user_data = user_data

    def validate(self):
        if self.input:
            self.input.validate()
        if self.output:
            self.output.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.async_ is not None:
            result['Async'] = self.async_
        if self.code is not None:
            result['Code'] = self.code
        if self.count is not None:
            result['Count'] = self.count
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.message is not None:
            result['Message'] = self.message
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.name is not None:
            result['Name'] = self.name
        if self.output is not None:
            result['Output'] = self.output.to_map()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.status is not None:
            result['Status'] = self.status
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.trigger_source is not None:
            result['TriggerSource'] = self.trigger_source
        if self.type is not None:
            result['Type'] = self.type
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Async') is not None:
            self.async_ = m.get('Async')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Input') is not None:
            temp_model = GetSnapshotJobResponseBodySnapshotJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Output') is not None:
            temp_model = GetSnapshotJobResponseBodySnapshotJobOutput()
            self.output = temp_model.from_map(m['Output'])
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TriggerSource') is not None:
            self.trigger_source = m.get('TriggerSource')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetSnapshotJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        snapshot_job: GetSnapshotJobResponseBodySnapshotJob = None,
    ):
        # 请求ID
        self.request_id = request_id
        # 截图任务信息
        self.snapshot_job = snapshot_job

    def validate(self):
        if self.snapshot_job:
            self.snapshot_job.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.snapshot_job is not None:
            result['SnapshotJob'] = self.snapshot_job.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SnapshotJob') is not None:
            temp_model = GetSnapshotJobResponseBodySnapshotJob()
            self.snapshot_job = temp_model.from_map(m['SnapshotJob'])
        return self


class GetSnapshotJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSnapshotJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSnapshotJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSnapshotUrlsRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        order_by: str = None,
        page_number: int = None,
        page_size: int = None,
        timeout: int = None,
    ):
        self.job_id = job_id
        # 排列顺序。取值：Asc，Desc
        self.order_by = order_by
        self.page_number = page_number
        self.page_size = page_size
        # 鉴权超时时间
        self.timeout = timeout

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        return self


class GetSnapshotUrlsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        snapshot_urls: List[str] = None,
        total: int = None,
        web_vtturl: str = None,
    ):
        self.request_id = request_id
        # 截图URL
        self.snapshot_urls = snapshot_urls
        # 截图总数量
        self.total = total
        # WebVTT文件URL
        self.web_vtturl = web_vtturl

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.snapshot_urls is not None:
            result['SnapshotUrls'] = self.snapshot_urls
        if self.total is not None:
            result['Total'] = self.total
        if self.web_vtturl is not None:
            result['WebVTTUrl'] = self.web_vtturl
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SnapshotUrls') is not None:
            self.snapshot_urls = m.get('SnapshotUrls')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('WebVTTUrl') is not None:
            self.web_vtturl = m.get('WebVTTUrl')
        return self


class GetSnapshotUrlsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSnapshotUrlsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSnapshotUrlsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSystemTemplateRequest(TeaModel):
    def __init__(
        self,
        template_id: str = None,
    ):
        # 模板ID
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetSystemTemplateResponseBodySystemTemplate(TeaModel):
    def __init__(
        self,
        status: str = None,
        subtype: int = None,
        subtype_name: str = None,
        template_config: str = None,
        template_id: str = None,
        template_name: str = None,
        type: int = None,
        type_name: str = None,
    ):
        # 模板状态
        self.status = status
        # 模板子类型ID
        self.subtype = subtype
        # 模板子类型名称
        self.subtype_name = subtype_name
        # 模板参数
        self.template_config = template_config
        # 模板Id
        self.template_id = template_id
        # 模板名称
        self.template_name = template_name
        # 模板类型ID
        self.type = type
        # 模板类型名称
        self.type_name = type_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.subtype is not None:
            result['Subtype'] = self.subtype
        if self.subtype_name is not None:
            result['SubtypeName'] = self.subtype_name
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.type is not None:
            result['Type'] = self.type
        if self.type_name is not None:
            result['TypeName'] = self.type_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Subtype') is not None:
            self.subtype = m.get('Subtype')
        if m.get('SubtypeName') is not None:
            self.subtype_name = m.get('SubtypeName')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('TypeName') is not None:
            self.type_name = m.get('TypeName')
        return self


class GetSystemTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        system_template: GetSystemTemplateResponseBodySystemTemplate = None,
    ):
        # 请求ID
        self.request_id = request_id
        # 模板信息
        self.system_template = system_template

    def validate(self):
        if self.system_template:
            self.system_template.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.system_template is not None:
            result['SystemTemplate'] = self.system_template.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SystemTemplate') is not None:
            temp_model = GetSystemTemplateResponseBodySystemTemplate()
            self.system_template = temp_model.from_map(m['SystemTemplate'])
        return self


class GetSystemTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSystemTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSystemTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTemplateRequest(TeaModel):
    def __init__(
        self,
        related_mediaid_flag: str = None,
        template_id: str = None,
    ):
        # 是否返回模板关联素材，1返回，默认0，不返回
        self.related_mediaid_flag = related_mediaid_flag
        # 模板Id
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.related_mediaid_flag is not None:
            result['RelatedMediaidFlag'] = self.related_mediaid_flag
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RelatedMediaidFlag') is not None:
            self.related_mediaid_flag = m.get('RelatedMediaidFlag')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetTemplateResponseBodyTemplate(TeaModel):
    def __init__(
        self,
        clips_param: str = None,
        config: str = None,
        cover_url: str = None,
        create_source: str = None,
        creation_time: str = None,
        modified_source: str = None,
        modified_time: str = None,
        name: str = None,
        preview_media: str = None,
        preview_media_status: str = None,
        related_mediaids: str = None,
        status: str = None,
        template_id: str = None,
        type: str = None,
    ):
        # 提交合成任务的ClipsParam参数
        self.clips_param = clips_param
        # 模板配置
        self.config = config
        # 封面URL
        self.cover_url = cover_url
        # 创建来源
        self.create_source = create_source
        # 创建时间
        self.creation_time = creation_time
        # 修改来源
        self.modified_source = modified_source
        # 修改时间
        self.modified_time = modified_time
        # 模板名称
        self.name = name
        # 预览素材
        self.preview_media = preview_media
        # 预览素材状态
        self.preview_media_status = preview_media_status
        # 模板关联素材
        self.related_mediaids = related_mediaids
        # 模板状态
        self.status = status
        # 模板ID
        self.template_id = template_id
        # 模板类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clips_param is not None:
            result['ClipsParam'] = self.clips_param
        if self.config is not None:
            result['Config'] = self.config
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.modified_source is not None:
            result['ModifiedSource'] = self.modified_source
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.name is not None:
            result['Name'] = self.name
        if self.preview_media is not None:
            result['PreviewMedia'] = self.preview_media
        if self.preview_media_status is not None:
            result['PreviewMediaStatus'] = self.preview_media_status
        if self.related_mediaids is not None:
            result['RelatedMediaids'] = self.related_mediaids
        if self.status is not None:
            result['Status'] = self.status
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClipsParam') is not None:
            self.clips_param = m.get('ClipsParam')
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateSource') is not None:
            self.create_source = m.get('CreateSource')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('ModifiedSource') is not None:
            self.modified_source = m.get('ModifiedSource')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PreviewMedia') is not None:
            self.preview_media = m.get('PreviewMedia')
        if m.get('PreviewMediaStatus') is not None:
            self.preview_media_status = m.get('PreviewMediaStatus')
        if m.get('RelatedMediaids') is not None:
            self.related_mediaids = m.get('RelatedMediaids')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template: GetTemplateResponseBodyTemplate = None,
    ):
        # Id of the request
        self.request_id = request_id
        self.template = template

    def validate(self):
        if self.template:
            self.template.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template is not None:
            result['Template'] = self.template.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Template') is not None:
            temp_model = GetTemplateResponseBodyTemplate()
            self.template = temp_model.from_map(m['Template'])
        return self


class GetTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTemplateMaterialsRequest(TeaModel):
    def __init__(
        self,
        file_list: str = None,
        template_id: str = None,
    ):
        # 所需文件列表
        self.file_list = file_list
        # 模板Id
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_list is not None:
            result['FileList'] = self.file_list
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileList') is not None:
            self.file_list = m.get('FileList')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetTemplateMaterialsResponseBody(TeaModel):
    def __init__(
        self,
        material_urls: str = None,
        request_id: str = None,
    ):
        # 关联素材地址
        self.material_urls = material_urls
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.material_urls is not None:
            result['MaterialUrls'] = self.material_urls
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaterialUrls') is not None:
            self.material_urls = m.get('MaterialUrls')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetTemplateMaterialsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetTemplateMaterialsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetTemplateMaterialsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTranscodeJobRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
    ):
        # 任务 id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobInputGroup(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        # 媒体值：
        #       type 为 OSS 时，为 url, 支持 oss 协议和 http 协议；
        #       type 为 Media 时，为媒资 id。
        self.media = media
        # 媒体对象类型 - OSS: oss文件, Media: 媒资 ID
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupOutput(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        # 媒体值：
        #       type 为 OSS 时，为 url, 支持 oss 协议和 http 协议；
        #       type 为 Media 时，为媒资 id。
        self.media = media
        # 媒体对象类型 - OSS: oss文件, Media: 媒资 ID
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarksOverwriteParamsFile(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        # 媒体值：
        #       type 为 OSS 时，为 url, 支持 oss 协议和 http 协议；
        #       type 为 Media 时，为媒资 id。
        self.media = media
        # 媒体对象类型 - OSS: oss文件, Media: 媒资 ID
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarksOverwriteParamsTimeline(TeaModel):
    def __init__(
        self,
        duration: str = None,
        start: str = None,
    ):
        # 显示时长，秒数 或者 "ToEND"
        self.duration = duration
        # 开始时间
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarksOverwriteParams(TeaModel):
    def __init__(
        self,
        dx: str = None,
        dy: str = None,
        file: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarksOverwriteParamsFile = None,
        height: str = None,
        refer_pos: str = None,
        timeline: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarksOverwriteParamsTimeline = None,
        width: str = None,
    ):
        # 水印位置，x
        self.dx = dx
        # 水印位置，y
        self.dy = dy
        # 水印文件oss路径
        self.file = file
        # 高
        self.height = height
        # 参考位置: TopLeft, TopRight, BottomLeft, BottomRight  default: TopLeft
        self.refer_pos = refer_pos
        # 显示时间设置
        self.timeline = timeline
        # 宽
        self.width = width

    def validate(self):
        if self.file:
            self.file.validate()
        if self.timeline:
            self.timeline.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dx is not None:
            result['Dx'] = self.dx
        if self.dy is not None:
            result['Dy'] = self.dy
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.height is not None:
            result['Height'] = self.height
        if self.refer_pos is not None:
            result['ReferPos'] = self.refer_pos
        if self.timeline is not None:
            result['Timeline'] = self.timeline.to_map()
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dx') is not None:
            self.dx = m.get('Dx')
        if m.get('Dy') is not None:
            self.dy = m.get('Dy')
        if m.get('File') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarksOverwriteParamsFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('ReferPos') is not None:
            self.refer_pos = m.get('ReferPos')
        if m.get('Timeline') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarksOverwriteParamsTimeline()
            self.timeline = temp_model.from_map(m['Timeline'])
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarks(TeaModel):
    def __init__(
        self,
        overwrite_params: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarksOverwriteParams = None,
        template_id: str = None,
    ):
        # 覆盖参数, 若填写会覆盖模板对应参数
        self.overwrite_params = overwrite_params
        # 模板 id
        self.template_id = template_id

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarksOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigSubtitlesOverwriteParamsFile(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        # 媒体值：
        #       type 为 OSS 时，为 url, 支持 oss 协议和 http 协议；
        #       type 为 Media 时，为媒资 id。
        self.media = media
        # 媒体对象类型 - OSS: oss文件, Media: 媒资 ID
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigSubtitlesOverwriteParams(TeaModel):
    def __init__(
        self,
        char_enc: str = None,
        file: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigSubtitlesOverwriteParamsFile = None,
        format: str = None,
    ):
        # 文件 encoding 格式
        self.char_enc = char_enc
        # 字幕文件
        self.file = file
        # 字幕文件格式
        self.format = format

    def validate(self):
        if self.file:
            self.file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.char_enc is not None:
            result['CharEnc'] = self.char_enc
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CharEnc') is not None:
            self.char_enc = m.get('CharEnc')
        if m.get('File') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigSubtitlesOverwriteParamsFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigSubtitles(TeaModel):
    def __init__(
        self,
        overwrite_params: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigSubtitlesOverwriteParams = None,
        template_id: str = None,
    ):
        # 覆盖参数, 若填写会覆盖模板对应参数
        self.overwrite_params = overwrite_params
        # 模板 id
        self.template_id = template_id

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigSubtitlesOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTextWatermarksOverwriteParams(TeaModel):
    def __init__(
        self,
        adaptive: str = None,
        border_color: str = None,
        border_width: int = None,
        content: str = None,
        font_alpha: str = None,
        font_color: str = None,
        font_name: str = None,
        font_size: int = None,
        left: str = None,
        top: str = None,
    ):
        # 根据输出视频大小调整字体 size。 true / false, default: false
        self.adaptive = adaptive
        # 边框颜色
        self.border_color = border_color
        # 边框宽度
        self.border_width = border_width
        # 水印文本，不需要 base64 encode，字符串需要 utf-8 编码
        self.content = content
        # 透明度
        self.font_alpha = font_alpha
        # 颜色
        self.font_color = font_color
        # 字体
        self.font_name = font_name
        # 字体大小
        self.font_size = font_size
        # 水印位置，距离左边距离
        self.left = left
        # 水印位置，距离上边距离
        self.top = top

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adaptive is not None:
            result['Adaptive'] = self.adaptive
        if self.border_color is not None:
            result['BorderColor'] = self.border_color
        if self.border_width is not None:
            result['BorderWidth'] = self.border_width
        if self.content is not None:
            result['Content'] = self.content
        if self.font_alpha is not None:
            result['FontAlpha'] = self.font_alpha
        if self.font_color is not None:
            result['FontColor'] = self.font_color
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.font_size is not None:
            result['FontSize'] = self.font_size
        if self.left is not None:
            result['Left'] = self.left
        if self.top is not None:
            result['Top'] = self.top
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Adaptive') is not None:
            self.adaptive = m.get('Adaptive')
        if m.get('BorderColor') is not None:
            self.border_color = m.get('BorderColor')
        if m.get('BorderWidth') is not None:
            self.border_width = m.get('BorderWidth')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('FontAlpha') is not None:
            self.font_alpha = m.get('FontAlpha')
        if m.get('FontColor') is not None:
            self.font_color = m.get('FontColor')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('FontSize') is not None:
            self.font_size = m.get('FontSize')
        if m.get('Left') is not None:
            self.left = m.get('Left')
        if m.get('Top') is not None:
            self.top = m.get('Top')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTextWatermarks(TeaModel):
    def __init__(
        self,
        overwrite_params: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTextWatermarksOverwriteParams = None,
        template_id: str = None,
    ):
        # 覆盖参数, 若填写会覆盖模板对应参数
        self.overwrite_params = overwrite_params
        # 模板 id
        self.template_id = template_id

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTextWatermarksOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsAudioVolume(TeaModel):
    def __init__(
        self,
        integrated_loudness_target: str = None,
        loudness_range_target: str = None,
        method: str = None,
        true_peak: str = None,
    ):
        # 目标音量
        self.integrated_loudness_target = integrated_loudness_target
        # 音量范围
        self.loudness_range_target = loudness_range_target
        # 音量调整方式
        self.method = method
        # 最大峰值
        self.true_peak = true_peak

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.integrated_loudness_target is not None:
            result['IntegratedLoudnessTarget'] = self.integrated_loudness_target
        if self.loudness_range_target is not None:
            result['LoudnessRangeTarget'] = self.loudness_range_target
        if self.method is not None:
            result['Method'] = self.method
        if self.true_peak is not None:
            result['TruePeak'] = self.true_peak
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IntegratedLoudnessTarget') is not None:
            self.integrated_loudness_target = m.get('IntegratedLoudnessTarget')
        if m.get('LoudnessRangeTarget') is not None:
            self.loudness_range_target = m.get('LoudnessRangeTarget')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('TruePeak') is not None:
            self.true_peak = m.get('TruePeak')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsAudio(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        channels: str = None,
        codec: str = None,
        profile: str = None,
        remove: str = None,
        samplerate: str = None,
        volume: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsAudioVolume = None,
    ):
        # 输出文件的音频码率。
        self.bitrate = bitrate
        # 声道数。
        self.channels = channels
        # 音频编解码格式，AAC、MP3、VORBIS、FLAC。
        self.codec = codec
        # 音频编码预置。
        self.profile = profile
        # 是否删除音频流。
        self.remove = remove
        # 采样率。
        self.samplerate = samplerate
        # 音量控制
        self.volume = volume

    def validate(self):
        if self.volume:
            self.volume.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.volume is not None:
            result['Volume'] = self.volume.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Volume') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsAudioVolume()
            self.volume = temp_model.from_map(m['Volume'])
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsContainer(TeaModel):
    def __init__(
        self,
        format: str = None,
    ):
        # 容器格式
        self.format = format

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfigSegment(TeaModel):
    def __init__(
        self,
        duration: str = None,
        force_seg_time: str = None,
    ):
        # 切片时长
        self.duration = duration
        # 强制切片时间点
        self.force_seg_time = force_seg_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.force_seg_time is not None:
            result['ForceSegTime'] = self.force_seg_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ForceSegTime') is not None:
            self.force_seg_time = m.get('ForceSegTime')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfig(TeaModel):
    def __init__(
        self,
        segment: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfigSegment = None,
    ):
        # 切片设置
        self.segment = segment

    def validate(self):
        if self.segment:
            self.segment.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Segment') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsVideo(TeaModel):
    def __init__(
        self,
        abr_max: str = None,
        bitrate: str = None,
        bufsize: str = None,
        codec: str = None,
        crf: str = None,
        crop: str = None,
        fps: str = None,
        gop: str = None,
        height: str = None,
        long_short_mode: str = None,
        maxrate: str = None,
        pad: str = None,
        pix_fmt: str = None,
        preset: str = None,
        profile: str = None,
        remove: str = None,
        scan_mode: str = None,
        width: str = None,
    ):
        self.abr_max = abr_max
        # 视频平均码率。
        self.bitrate = bitrate
        # 缓冲区大小
        self.bufsize = bufsize
        # 编码格式
        self.codec = codec
        # 码率-质量控制因子。
        self.crf = crf
        # 视频画面裁切
        self.crop = crop
        # 帧率。
        self.fps = fps
        # 关键帧间最大帧数。
        self.gop = gop
        # 高。
        self.height = height
        # 是否开启横竖屏自适应（即：长短边模式）
        self.long_short_mode = long_short_mode
        # 视频码率峰值
        self.maxrate = maxrate
        # 视频贴黑边
        self.pad = pad
        # 视频颜色格式。
        self.pix_fmt = pix_fmt
        # 只有H264支持该参数
        self.preset = preset
        # 编码级别。
        self.profile = profile
        # 是否去掉视频
        self.remove = remove
        # 扫描模式。
        self.scan_mode = scan_mode
        # 宽。
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abr_max is not None:
            result['AbrMax'] = self.abr_max
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.crop is not None:
            result['Crop'] = self.crop
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.long_short_mode is not None:
            result['LongShortMode'] = self.long_short_mode
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.pad is not None:
            result['Pad'] = self.pad
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AbrMax') is not None:
            self.abr_max = m.get('AbrMax')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Crop') is not None:
            self.crop = m.get('Crop')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('LongShortMode') is not None:
            self.long_short_mode = m.get('LongShortMode')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('Pad') is not None:
            self.pad = m.get('Pad')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParams(TeaModel):
    def __init__(
        self,
        audio: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsAudio = None,
        container: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsContainer = None,
        mux_config: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfig = None,
        video: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsVideo = None,
    ):
        # audio 设置
        self.audio = audio
        # 封装格式设置
        self.container = container
        # 封装设置
        self.mux_config = mux_config
        # video 设置
        self.video = video

    def validate(self):
        if self.audio:
            self.audio.validate()
        if self.container:
            self.container.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.video:
            self.video.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.container is not None:
            result['Container'] = self.container.to_map()
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.video is not None:
            result['Video'] = self.video.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Audio') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('Container') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsContainer()
            self.container = temp_model.from_map(m['Container'])
        if m.get('MuxConfig') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('Video') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParamsVideo()
            self.video = temp_model.from_map(m['Video'])
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscode(TeaModel):
    def __init__(
        self,
        overwrite_params: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParams = None,
        template_id: str = None,
    ):
        # 覆盖参数, 若填写会覆盖模板对应参数
        self.overwrite_params = overwrite_params
        # 模板 id
        self.template_id = template_id

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscodeOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfig(TeaModel):
    def __init__(
        self,
        image_watermarks: List[GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarks] = None,
        subtitles: List[GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigSubtitles] = None,
        text_watermarks: List[GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTextWatermarks] = None,
        transcode: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscode = None,
    ):
        # 图片水印配置
        self.image_watermarks = image_watermarks
        # 字幕压制配置
        self.subtitles = subtitles
        # 文字水印配置
        self.text_watermarks = text_watermarks
        # 转码配置
        self.transcode = transcode

    def validate(self):
        if self.image_watermarks:
            for k in self.image_watermarks:
                if k:
                    k.validate()
        if self.subtitles:
            for k in self.subtitles:
                if k:
                    k.validate()
        if self.text_watermarks:
            for k in self.text_watermarks:
                if k:
                    k.validate()
        if self.transcode:
            self.transcode.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ImageWatermarks'] = []
        if self.image_watermarks is not None:
            for k in self.image_watermarks:
                result['ImageWatermarks'].append(k.to_map() if k else None)
        result['Subtitles'] = []
        if self.subtitles is not None:
            for k in self.subtitles:
                result['Subtitles'].append(k.to_map() if k else None)
        result['TextWatermarks'] = []
        if self.text_watermarks is not None:
            for k in self.text_watermarks:
                result['TextWatermarks'].append(k.to_map() if k else None)
        if self.transcode is not None:
            result['Transcode'] = self.transcode.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.image_watermarks = []
        if m.get('ImageWatermarks') is not None:
            for k in m.get('ImageWatermarks'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigImageWatermarks()
                self.image_watermarks.append(temp_model.from_map(k))
        self.subtitles = []
        if m.get('Subtitles') is not None:
            for k in m.get('Subtitles'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigSubtitles()
                self.subtitles.append(temp_model.from_map(k))
        self.text_watermarks = []
        if m.get('TextWatermarks') is not None:
            for k in m.get('TextWatermarks'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTextWatermarks()
                self.text_watermarks.append(temp_model.from_map(k))
        if m.get('Transcode') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfigTranscode()
            self.transcode = temp_model.from_map(m['Transcode'])
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobOutputGroup(TeaModel):
    def __init__(
        self,
        output: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupOutput = None,
        process_config: GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfig = None,
    ):
        # 输出媒体配置
        self.output = output
        # 任务处理配置
        self.process_config = process_config

    def validate(self):
        if self.output:
            self.output.validate()
        if self.process_config:
            self.process_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output is not None:
            result['Output'] = self.output.to_map()
        if self.process_config is not None:
            result['ProcessConfig'] = self.process_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Output') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupOutput()
            self.output = temp_model.from_map(m['Output'])
        if m.get('ProcessConfig') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroupProcessConfig()
            self.process_config = temp_model.from_map(m['ProcessConfig'])
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobScheduleConfig(TeaModel):
    def __init__(
        self,
        pipeline_id: str = None,
        priority: int = None,
    ):
        # 管道 id
        self.pipeline_id = pipeline_id
        # 任务优先级，取值范围：1~10
        self.priority = priority

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListInputGroup(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        # 媒体值：
        #       type 为 OSS 时，为 url, 支持 oss 协议和 http 协议；
        #       type 为 Media 时，为媒资 id。
        self.media = media
        # 媒体对象类型 - OSS: oss文件, Media: 媒资 ID
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMetaAudioStreamInfoList(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        channel_layout: str = None,
        channels: str = None,
        codec_long_name: str = None,
        codec_name: str = None,
        codec_tag: str = None,
        codec_tag_string: str = None,
        codec_time_base: str = None,
        duration: str = None,
        index: str = None,
        lang: str = None,
        sample_fmt: str = None,
        sample_rate: str = None,
        start_time: str = None,
        timebase: str = None,
    ):
        # 码率
        self.bitrate = bitrate
        # 声道布局
        self.channel_layout = channel_layout
        # 声道数
        self.channels = channels
        # 编码格式名
        self.codec_long_name = codec_long_name
        # 编码格式
        self.codec_name = codec_name
        # 编码器标签
        self.codec_tag = codec_tag
        # 编码器标签名
        self.codec_tag_string = codec_tag_string
        # 编码器时间基
        self.codec_time_base = codec_time_base
        # 时长
        self.duration = duration
        # 流序号
        self.index = index
        # 语言
        self.lang = lang
        self.sample_fmt = sample_fmt
        # 采样率
        self.sample_rate = sample_rate
        # 开始时间
        self.start_time = start_time
        # 时间基
        self.timebase = timebase

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.sample_rate is not None:
            result['SampleRate'] = self.sample_rate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('SampleRate') is not None:
            self.sample_rate = m.get('SampleRate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMetaFileBasicInfo(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        duration: str = None,
        file_name: str = None,
        file_size: str = None,
        file_status: str = None,
        file_type: str = None,
        file_url: str = None,
        format_name: str = None,
        height: str = None,
        media_id: str = None,
        region: str = None,
        width: str = None,
    ):
        # 视频码率
        self.bitrate = bitrate
        # 视频时长
        self.duration = duration
        # 文件名
        self.file_name = file_name
        # 文件大小
        self.file_size = file_size
        # 文件状态
        self.file_status = file_status
        # 文件类型
        self.file_type = file_type
        # 文件url
        self.file_url = file_url
        # 视频格式名称
        self.format_name = format_name
        # 高
        self.height = height
        # 媒资ID
        self.media_id = media_id
        # 文件所在区域
        self.region = region
        # 宽
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMetaVideoStreamInfoList(TeaModel):
    def __init__(
        self,
        avg_fps: str = None,
        bit_rate: str = None,
        codec_long_name: str = None,
        codec_name: str = None,
        codec_tag: str = None,
        codec_tag_string: str = None,
        codec_time_base: str = None,
        dar: str = None,
        duration: str = None,
        fps: str = None,
        has_bframes: str = None,
        height: str = None,
        index: str = None,
        lang: str = None,
        level: str = None,
        num_frames: str = None,
        pix_fmt: str = None,
        profile: str = None,
        rotate: str = None,
        sar: str = None,
        start_time: str = None,
        time_base: str = None,
        width: str = None,
    ):
        self.avg_fps = avg_fps
        self.bit_rate = bit_rate
        # 编码格式名
        self.codec_long_name = codec_long_name
        # 编码格式
        self.codec_name = codec_name
        # 编码格式标记
        self.codec_tag = codec_tag
        # 编码格式标记文本
        self.codec_tag_string = codec_tag_string
        self.codec_time_base = codec_time_base
        # 图像显示宽高比
        self.dar = dar
        # 时长
        self.duration = duration
        # 帧率
        self.fps = fps
        self.has_bframes = has_bframes
        # 高
        self.height = height
        # 流序号
        self.index = index
        # 语言
        self.lang = lang
        # 编码等级
        self.level = level
        # 总帧数
        self.num_frames = num_frames
        # 颜色存储格式
        self.pix_fmt = pix_fmt
        # 编码器预设
        self.profile = profile
        # 视频画面旋转角度
        self.rotate = rotate
        # 采集点数宽高比
        self.sar = sar
        # 起始时间
        self.start_time = start_time
        self.time_base = time_base
        # 宽
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_fps is not None:
            result['Avg_fps'] = self.avg_fps
        if self.bit_rate is not None:
            result['Bit_rate'] = self.bit_rate
        if self.codec_long_name is not None:
            result['Codec_long_name'] = self.codec_long_name
        if self.codec_name is not None:
            result['Codec_name'] = self.codec_name
        if self.codec_tag is not None:
            result['Codec_tag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['Codec_tag_string'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['Codec_time_base'] = self.codec_time_base
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.has_bframes is not None:
            result['Has_b_frames'] = self.has_bframes
        if self.height is not None:
            result['Height'] = self.height
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.level is not None:
            result['Level'] = self.level
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.start_time is not None:
            result['Start_time'] = self.start_time
        if self.time_base is not None:
            result['Time_base'] = self.time_base
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Avg_fps') is not None:
            self.avg_fps = m.get('Avg_fps')
        if m.get('Bit_rate') is not None:
            self.bit_rate = m.get('Bit_rate')
        if m.get('Codec_long_name') is not None:
            self.codec_long_name = m.get('Codec_long_name')
        if m.get('Codec_name') is not None:
            self.codec_name = m.get('Codec_name')
        if m.get('Codec_tag') is not None:
            self.codec_tag = m.get('Codec_tag')
        if m.get('Codec_tag_string') is not None:
            self.codec_tag_string = m.get('Codec_tag_string')
        if m.get('Codec_time_base') is not None:
            self.codec_time_base = m.get('Codec_time_base')
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Has_b_frames') is not None:
            self.has_bframes = m.get('Has_b_frames')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('Start_time') is not None:
            self.start_time = m.get('Start_time')
        if m.get('Time_base') is not None:
            self.time_base = m.get('Time_base')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMeta(TeaModel):
    def __init__(
        self,
        audio_stream_info_list: List[GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMetaAudioStreamInfoList] = None,
        file_basic_info: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMetaFileBasicInfo = None,
        video_stream_info_list: List[GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMetaVideoStreamInfoList] = None,
    ):
        # 音频流信息
        self.audio_stream_info_list = audio_stream_info_list
        # 基础文件信息
        self.file_basic_info = file_basic_info
        # 视频流信息
        self.video_stream_info_list = video_stream_info_list

    def validate(self):
        if self.audio_stream_info_list:
            for k in self.audio_stream_info_list:
                if k:
                    k.validate()
        if self.file_basic_info:
            self.file_basic_info.validate()
        if self.video_stream_info_list:
            for k in self.video_stream_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStreamInfoList'] = []
        if self.audio_stream_info_list is not None:
            for k in self.audio_stream_info_list:
                result['AudioStreamInfoList'].append(k.to_map() if k else None)
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        result['VideoStreamInfoList'] = []
        if self.video_stream_info_list is not None:
            for k in self.video_stream_info_list:
                result['VideoStreamInfoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.audio_stream_info_list = []
        if m.get('AudioStreamInfoList') is not None:
            for k in m.get('AudioStreamInfoList'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMetaAudioStreamInfoList()
                self.audio_stream_info_list.append(temp_model.from_map(k))
        if m.get('FileBasicInfo') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMetaFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        self.video_stream_info_list = []
        if m.get('VideoStreamInfoList') is not None:
            for k in m.get('VideoStreamInfoList'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMetaVideoStreamInfoList()
                self.video_stream_info_list.append(temp_model.from_map(k))
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutput(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        # 媒体值：
        #       type 为 OSS 时，为 url, 支持 oss 协议和 http 协议；
        #       type 为 Media 时，为媒资 id。
        self.media = media
        # 媒体对象类型 - OSS: oss文件, Media: 媒资 ID
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarksOverwriteParamsFile(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        # 媒体值：
        #       type 为 OSS 时，为 url, 支持 oss 协议和 http 协议；
        #       type 为 Media 时，为媒资 id。
        self.media = media
        # 媒体对象类型 - OSS: oss文件, Media: 媒资 ID
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarksOverwriteParamsTimeline(TeaModel):
    def __init__(
        self,
        duration: str = None,
        start: str = None,
    ):
        # 显示时长，秒数 或者 "ToEND"
        self.duration = duration
        # 开始时间
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarksOverwriteParams(TeaModel):
    def __init__(
        self,
        dx: str = None,
        dy: str = None,
        file: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarksOverwriteParamsFile = None,
        height: str = None,
        refer_pos: str = None,
        timeline: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarksOverwriteParamsTimeline = None,
        width: str = None,
    ):
        # 水印位置，x
        self.dx = dx
        # 水印位置，y
        self.dy = dy
        # 水印文件oss路径
        self.file = file
        # 高
        self.height = height
        # 参考位置: TopLeft, TopRight, BottomLeft, BottomRight  default: TopLeft
        self.refer_pos = refer_pos
        # 显示时间设置
        self.timeline = timeline
        # 宽
        self.width = width

    def validate(self):
        if self.file:
            self.file.validate()
        if self.timeline:
            self.timeline.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dx is not None:
            result['Dx'] = self.dx
        if self.dy is not None:
            result['Dy'] = self.dy
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.height is not None:
            result['Height'] = self.height
        if self.refer_pos is not None:
            result['ReferPos'] = self.refer_pos
        if self.timeline is not None:
            result['Timeline'] = self.timeline.to_map()
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dx') is not None:
            self.dx = m.get('Dx')
        if m.get('Dy') is not None:
            self.dy = m.get('Dy')
        if m.get('File') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarksOverwriteParamsFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('ReferPos') is not None:
            self.refer_pos = m.get('ReferPos')
        if m.get('Timeline') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarksOverwriteParamsTimeline()
            self.timeline = temp_model.from_map(m['Timeline'])
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarks(TeaModel):
    def __init__(
        self,
        overwrite_params: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarksOverwriteParams = None,
        template_id: str = None,
    ):
        # 覆盖参数, 若填写会覆盖模板对应参数
        self.overwrite_params = overwrite_params
        # 模板 id
        self.template_id = template_id

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarksOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigSubtitlesOverwriteParamsFile(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        # 媒体值：
        #       type 为 OSS 时，为 url, 支持 oss 协议和 http 协议；
        #       type 为 Media 时，为媒资 id。
        self.media = media
        # 媒体对象类型 - OSS: oss文件, Media: 媒资 ID
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigSubtitlesOverwriteParams(TeaModel):
    def __init__(
        self,
        char_enc: str = None,
        file: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigSubtitlesOverwriteParamsFile = None,
        format: str = None,
    ):
        # 文件 encoding 格式
        self.char_enc = char_enc
        # 字幕文件
        self.file = file
        # 字幕文件格式
        self.format = format

    def validate(self):
        if self.file:
            self.file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.char_enc is not None:
            result['CharEnc'] = self.char_enc
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CharEnc') is not None:
            self.char_enc = m.get('CharEnc')
        if m.get('File') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigSubtitlesOverwriteParamsFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigSubtitles(TeaModel):
    def __init__(
        self,
        overwrite_params: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigSubtitlesOverwriteParams = None,
        template_id: str = None,
    ):
        # 覆盖参数, 若填写会覆盖模板对应参数
        self.overwrite_params = overwrite_params
        # 模板 id
        self.template_id = template_id

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigSubtitlesOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTextWatermarksOverwriteParams(TeaModel):
    def __init__(
        self,
        adaptive: str = None,
        border_color: str = None,
        border_width: int = None,
        content: str = None,
        font_alpha: str = None,
        font_color: str = None,
        font_name: str = None,
        font_size: int = None,
        left: str = None,
        top: str = None,
    ):
        # 根据输出视频大小调整字体 size。 true / false, default: false
        self.adaptive = adaptive
        # 边框颜色
        self.border_color = border_color
        # 边框宽度
        self.border_width = border_width
        # 水印文本，不需要 base64 encode，字符串需要 utf-8 编码
        self.content = content
        # 透明度
        self.font_alpha = font_alpha
        # 颜色
        self.font_color = font_color
        # 字体
        self.font_name = font_name
        # 字体大小
        self.font_size = font_size
        # 水印位置，距离左边距离
        self.left = left
        # 水印位置，距离上边距离
        self.top = top

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adaptive is not None:
            result['Adaptive'] = self.adaptive
        if self.border_color is not None:
            result['BorderColor'] = self.border_color
        if self.border_width is not None:
            result['BorderWidth'] = self.border_width
        if self.content is not None:
            result['Content'] = self.content
        if self.font_alpha is not None:
            result['FontAlpha'] = self.font_alpha
        if self.font_color is not None:
            result['FontColor'] = self.font_color
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.font_size is not None:
            result['FontSize'] = self.font_size
        if self.left is not None:
            result['Left'] = self.left
        if self.top is not None:
            result['Top'] = self.top
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Adaptive') is not None:
            self.adaptive = m.get('Adaptive')
        if m.get('BorderColor') is not None:
            self.border_color = m.get('BorderColor')
        if m.get('BorderWidth') is not None:
            self.border_width = m.get('BorderWidth')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('FontAlpha') is not None:
            self.font_alpha = m.get('FontAlpha')
        if m.get('FontColor') is not None:
            self.font_color = m.get('FontColor')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('FontSize') is not None:
            self.font_size = m.get('FontSize')
        if m.get('Left') is not None:
            self.left = m.get('Left')
        if m.get('Top') is not None:
            self.top = m.get('Top')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTextWatermarks(TeaModel):
    def __init__(
        self,
        overwrite_params: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTextWatermarksOverwriteParams = None,
        template_id: str = None,
    ):
        # 覆盖参数, 若填写会覆盖模板对应参数
        self.overwrite_params = overwrite_params
        # 模板 id
        self.template_id = template_id

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTextWatermarksOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsAudioVolume(TeaModel):
    def __init__(
        self,
        integrated_loudness_target: str = None,
        loudness_range_target: str = None,
        method: str = None,
        true_peak: str = None,
    ):
        # 目标音量
        self.integrated_loudness_target = integrated_loudness_target
        # 音量范围
        self.loudness_range_target = loudness_range_target
        # 音量调整方式
        self.method = method
        # 最大峰值
        self.true_peak = true_peak

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.integrated_loudness_target is not None:
            result['IntegratedLoudnessTarget'] = self.integrated_loudness_target
        if self.loudness_range_target is not None:
            result['LoudnessRangeTarget'] = self.loudness_range_target
        if self.method is not None:
            result['Method'] = self.method
        if self.true_peak is not None:
            result['TruePeak'] = self.true_peak
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IntegratedLoudnessTarget') is not None:
            self.integrated_loudness_target = m.get('IntegratedLoudnessTarget')
        if m.get('LoudnessRangeTarget') is not None:
            self.loudness_range_target = m.get('LoudnessRangeTarget')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('TruePeak') is not None:
            self.true_peak = m.get('TruePeak')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsAudio(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        channels: str = None,
        codec: str = None,
        profile: str = None,
        remove: str = None,
        samplerate: str = None,
        volume: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsAudioVolume = None,
    ):
        # 输出文件的音频码率。
        self.bitrate = bitrate
        # 声道数。
        self.channels = channels
        # 音频编解码格式，AAC、MP3、VORBIS、FLAC。
        self.codec = codec
        # 音频编码预置。
        self.profile = profile
        # 是否删除音频流。
        self.remove = remove
        # 采样率。
        self.samplerate = samplerate
        # 音量控制
        self.volume = volume

    def validate(self):
        if self.volume:
            self.volume.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.volume is not None:
            result['Volume'] = self.volume.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Volume') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsAudioVolume()
            self.volume = temp_model.from_map(m['Volume'])
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsContainer(TeaModel):
    def __init__(
        self,
        format: str = None,
    ):
        # 容器格式
        self.format = format

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsMuxConfigSegment(TeaModel):
    def __init__(
        self,
        duration: str = None,
        force_seg_time: str = None,
    ):
        # 切片时长
        self.duration = duration
        # 强制切片时间点
        self.force_seg_time = force_seg_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.force_seg_time is not None:
            result['ForceSegTime'] = self.force_seg_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ForceSegTime') is not None:
            self.force_seg_time = m.get('ForceSegTime')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsMuxConfig(TeaModel):
    def __init__(
        self,
        segment: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsMuxConfigSegment = None,
    ):
        # 切片设置
        self.segment = segment

    def validate(self):
        if self.segment:
            self.segment.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Segment') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsVideo(TeaModel):
    def __init__(
        self,
        abr_max: str = None,
        bitrate: str = None,
        bufsize: str = None,
        codec: str = None,
        crf: str = None,
        crop: str = None,
        fps: str = None,
        gop: str = None,
        height: str = None,
        long_short_mode: str = None,
        maxrate: str = None,
        pad: str = None,
        pix_fmt: str = None,
        preset: str = None,
        profile: str = None,
        remove: str = None,
        scan_mode: str = None,
        width: str = None,
    ):
        self.abr_max = abr_max
        # 视频平均码率。
        self.bitrate = bitrate
        # 缓冲区大小
        self.bufsize = bufsize
        # 编码格式
        self.codec = codec
        # 码率-质量控制因子。
        self.crf = crf
        # 视频画面裁切
        self.crop = crop
        # 帧率。
        self.fps = fps
        # 关键帧间最大帧数。
        self.gop = gop
        # 高。
        self.height = height
        # 是否开启横竖屏自适应（即：长短边模式）
        self.long_short_mode = long_short_mode
        # 视频码率峰值
        self.maxrate = maxrate
        # 视频贴黑边
        self.pad = pad
        # 视频颜色格式。
        self.pix_fmt = pix_fmt
        # 只有H264支持该参数
        self.preset = preset
        # 编码级别。
        self.profile = profile
        # 是否去掉视频
        self.remove = remove
        # 扫描模式。
        self.scan_mode = scan_mode
        # 宽。
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abr_max is not None:
            result['AbrMax'] = self.abr_max
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.crop is not None:
            result['Crop'] = self.crop
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.long_short_mode is not None:
            result['LongShortMode'] = self.long_short_mode
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.pad is not None:
            result['Pad'] = self.pad
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AbrMax') is not None:
            self.abr_max = m.get('AbrMax')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Crop') is not None:
            self.crop = m.get('Crop')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('LongShortMode') is not None:
            self.long_short_mode = m.get('LongShortMode')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('Pad') is not None:
            self.pad = m.get('Pad')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParams(TeaModel):
    def __init__(
        self,
        audio: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsAudio = None,
        container: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsContainer = None,
        mux_config: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsMuxConfig = None,
        video: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsVideo = None,
    ):
        # audio 设置
        self.audio = audio
        # 封装格式设置
        self.container = container
        # 封装设置
        self.mux_config = mux_config
        # video 设置
        self.video = video

    def validate(self):
        if self.audio:
            self.audio.validate()
        if self.container:
            self.container.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.video:
            self.video.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.container is not None:
            result['Container'] = self.container.to_map()
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.video is not None:
            result['Video'] = self.video.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Audio') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('Container') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsContainer()
            self.container = temp_model.from_map(m['Container'])
        if m.get('MuxConfig') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('Video') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParamsVideo()
            self.video = temp_model.from_map(m['Video'])
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscode(TeaModel):
    def __init__(
        self,
        overwrite_params: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParams = None,
        template_id: str = None,
    ):
        # 覆盖参数, 若填写会覆盖模板对应参数
        self.overwrite_params = overwrite_params
        # 模板 id
        self.template_id = template_id

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscodeOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfig(TeaModel):
    def __init__(
        self,
        image_watermarks: List[GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarks] = None,
        subtitles: List[GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigSubtitles] = None,
        text_watermarks: List[GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTextWatermarks] = None,
        transcode: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscode = None,
    ):
        # 图片水印配置
        self.image_watermarks = image_watermarks
        # 字幕压制配置
        self.subtitles = subtitles
        # 文字水印配置
        self.text_watermarks = text_watermarks
        # 转码配置
        self.transcode = transcode

    def validate(self):
        if self.image_watermarks:
            for k in self.image_watermarks:
                if k:
                    k.validate()
        if self.subtitles:
            for k in self.subtitles:
                if k:
                    k.validate()
        if self.text_watermarks:
            for k in self.text_watermarks:
                if k:
                    k.validate()
        if self.transcode:
            self.transcode.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ImageWatermarks'] = []
        if self.image_watermarks is not None:
            for k in self.image_watermarks:
                result['ImageWatermarks'].append(k.to_map() if k else None)
        result['Subtitles'] = []
        if self.subtitles is not None:
            for k in self.subtitles:
                result['Subtitles'].append(k.to_map() if k else None)
        result['TextWatermarks'] = []
        if self.text_watermarks is not None:
            for k in self.text_watermarks:
                result['TextWatermarks'].append(k.to_map() if k else None)
        if self.transcode is not None:
            result['Transcode'] = self.transcode.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.image_watermarks = []
        if m.get('ImageWatermarks') is not None:
            for k in m.get('ImageWatermarks'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigImageWatermarks()
                self.image_watermarks.append(temp_model.from_map(k))
        self.subtitles = []
        if m.get('Subtitles') is not None:
            for k in m.get('Subtitles'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigSubtitles()
                self.subtitles.append(temp_model.from_map(k))
        self.text_watermarks = []
        if m.get('TextWatermarks') is not None:
            for k in m.get('TextWatermarks'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTextWatermarks()
                self.text_watermarks.append(temp_model.from_map(k))
        if m.get('Transcode') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfigTranscode()
            self.transcode = temp_model.from_map(m['Transcode'])
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListScheduleConfig(TeaModel):
    def __init__(
        self,
        pipeline_id: str = None,
        priority: int = None,
    ):
        # 管道 id
        self.pipeline_id = pipeline_id
        # 任务优先级，取值范围：1~10
        self.priority = priority

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobList(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        finish_time: str = None,
        input_group: List[GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListInputGroup] = None,
        job_id: str = None,
        job_index: int = None,
        name: str = None,
        out_file_meta: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMeta = None,
        output: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutput = None,
        parent_job_id: str = None,
        process_config: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfig = None,
        request_id: str = None,
        schedule_config: GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListScheduleConfig = None,
        status: str = None,
        submit_result_json: Dict[str, Any] = None,
        submit_time: str = None,
        user_data: str = None,
    ):
        # 任务创建时间
        self.create_time = create_time
        # 任务结束时间
        self.finish_time = finish_time
        # 任务输入组 (目前只支持单个输入)
        self.input_group = input_group
        # 子任务 id
        self.job_id = job_id
        # 子任务在整个任务中的索引号
        self.job_index = job_index
        # 任务名
        self.name = name
        # 任务生成视频 media 信息
        self.out_file_meta = out_file_meta
        # 输出媒体配置
        self.output = output
        # 主任务 id
        self.parent_job_id = parent_job_id
        # 转码处理配置
        self.process_config = process_config
        # 请求 id
        self.request_id = request_id
        # 任务调度信息
        self.schedule_config = schedule_config
        # 转码任务任务状态 - Init: 已提交, Processing: 转码中, Success: 转码成功, Fail: 转码失败, Deleted: 已删除
        self.status = status
        # 任务提交结果
        self.submit_result_json = submit_result_json
        # 任务提交时间
        self.submit_time = submit_time
        # 用户数据
        self.user_data = user_data

    def validate(self):
        if self.input_group:
            for k in self.input_group:
                if k:
                    k.validate()
        if self.out_file_meta:
            self.out_file_meta.validate()
        if self.output:
            self.output.validate()
        if self.process_config:
            self.process_config.validate()
        if self.schedule_config:
            self.schedule_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        result['InputGroup'] = []
        if self.input_group is not None:
            for k in self.input_group:
                result['InputGroup'].append(k.to_map() if k else None)
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_index is not None:
            result['JobIndex'] = self.job_index
        if self.name is not None:
            result['Name'] = self.name
        if self.out_file_meta is not None:
            result['OutFileMeta'] = self.out_file_meta.to_map()
        if self.output is not None:
            result['Output'] = self.output.to_map()
        if self.parent_job_id is not None:
            result['ParentJobId'] = self.parent_job_id
        if self.process_config is not None:
            result['ProcessConfig'] = self.process_config.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.schedule_config is not None:
            result['ScheduleConfig'] = self.schedule_config.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.submit_result_json is not None:
            result['SubmitResultJson'] = self.submit_result_json
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        self.input_group = []
        if m.get('InputGroup') is not None:
            for k in m.get('InputGroup'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListInputGroup()
                self.input_group.append(temp_model.from_map(k))
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobIndex') is not None:
            self.job_index = m.get('JobIndex')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OutFileMeta') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutFileMeta()
            self.out_file_meta = temp_model.from_map(m['OutFileMeta'])
        if m.get('Output') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListOutput()
            self.output = temp_model.from_map(m['Output'])
        if m.get('ParentJobId') is not None:
            self.parent_job_id = m.get('ParentJobId')
        if m.get('ProcessConfig') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListProcessConfig()
            self.process_config = temp_model.from_map(m['ProcessConfig'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScheduleConfig') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobListScheduleConfig()
            self.schedule_config = temp_model.from_map(m['ScheduleConfig'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubmitResultJson') is not None:
            self.submit_result_json = m.get('SubmitResultJson')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetTranscodeJobResponseBodyTranscodeParentJob(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        finish_time: str = None,
        input_group: List[GetTranscodeJobResponseBodyTranscodeParentJobInputGroup] = None,
        job_count: int = None,
        name: str = None,
        output_group: List[GetTranscodeJobResponseBodyTranscodeParentJobOutputGroup] = None,
        parent_job_id: str = None,
        percent: int = None,
        request_id: str = None,
        schedule_config: GetTranscodeJobResponseBodyTranscodeParentJobScheduleConfig = None,
        status: str = None,
        submit_time: str = None,
        transcode_job_list: List[GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobList] = None,
        trigger_source: str = None,
        user_data: str = None,
    ):
        # 任务创建时间
        self.create_time = create_time
        # 任务结束时间
        self.finish_time = finish_time
        # 任务输入组 (目前只支持单个输入)
        self.input_group = input_group
        # 子任务数量
        self.job_count = job_count
        # 任务名
        self.name = name
        # 任务输出组
        self.output_group = output_group
        # 主任务 id
        self.parent_job_id = parent_job_id
        # 任务完成百分比
        self.percent = percent
        # 提交任务时请求 id
        self.request_id = request_id
        # 任务调度配置
        self.schedule_config = schedule_config
        # 任务状态 Success: 有子任务成功, Fail: 所有子任务失败
        self.status = status
        # 任务提交时间
        self.submit_time = submit_time
        # 子任务列表
        self.transcode_job_list = transcode_job_list
        # 任务来源 - API, WorkFlow, Console
        self.trigger_source = trigger_source
        # 用户数据
        self.user_data = user_data

    def validate(self):
        if self.input_group:
            for k in self.input_group:
                if k:
                    k.validate()
        if self.output_group:
            for k in self.output_group:
                if k:
                    k.validate()
        if self.schedule_config:
            self.schedule_config.validate()
        if self.transcode_job_list:
            for k in self.transcode_job_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        result['InputGroup'] = []
        if self.input_group is not None:
            for k in self.input_group:
                result['InputGroup'].append(k.to_map() if k else None)
        if self.job_count is not None:
            result['JobCount'] = self.job_count
        if self.name is not None:
            result['Name'] = self.name
        result['OutputGroup'] = []
        if self.output_group is not None:
            for k in self.output_group:
                result['OutputGroup'].append(k.to_map() if k else None)
        if self.parent_job_id is not None:
            result['ParentJobId'] = self.parent_job_id
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.schedule_config is not None:
            result['ScheduleConfig'] = self.schedule_config.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        result['TranscodeJobList'] = []
        if self.transcode_job_list is not None:
            for k in self.transcode_job_list:
                result['TranscodeJobList'].append(k.to_map() if k else None)
        if self.trigger_source is not None:
            result['TriggerSource'] = self.trigger_source
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        self.input_group = []
        if m.get('InputGroup') is not None:
            for k in m.get('InputGroup'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobInputGroup()
                self.input_group.append(temp_model.from_map(k))
        if m.get('JobCount') is not None:
            self.job_count = m.get('JobCount')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.output_group = []
        if m.get('OutputGroup') is not None:
            for k in m.get('OutputGroup'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobOutputGroup()
                self.output_group.append(temp_model.from_map(k))
        if m.get('ParentJobId') is not None:
            self.parent_job_id = m.get('ParentJobId')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScheduleConfig') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJobScheduleConfig()
            self.schedule_config = temp_model.from_map(m['ScheduleConfig'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        self.transcode_job_list = []
        if m.get('TranscodeJobList') is not None:
            for k in m.get('TranscodeJobList'):
                temp_model = GetTranscodeJobResponseBodyTranscodeParentJobTranscodeJobList()
                self.transcode_job_list.append(temp_model.from_map(k))
        if m.get('TriggerSource') is not None:
            self.trigger_source = m.get('TriggerSource')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetTranscodeJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        transcode_parent_job: GetTranscodeJobResponseBodyTranscodeParentJob = None,
    ):
        # 请求 id
        self.request_id = request_id
        # TranscodeParentJobWithSubJobDTO
        self.transcode_parent_job = transcode_parent_job

    def validate(self):
        if self.transcode_parent_job:
            self.transcode_parent_job.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.transcode_parent_job is not None:
            result['TranscodeParentJob'] = self.transcode_parent_job.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TranscodeParentJob') is not None:
            temp_model = GetTranscodeJobResponseBodyTranscodeParentJob()
            self.transcode_parent_job = temp_model.from_map(m['TranscodeParentJob'])
        return self


class GetTranscodeJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetTranscodeJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetTranscodeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetUrlUploadInfosRequest(TeaModel):
    def __init__(
        self,
        job_ids: str = None,
        upload_urls: str = None,
    ):
        self.job_ids = job_ids
        self.upload_urls = upload_urls

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.upload_urls is not None:
            result['UploadURLs'] = self.upload_urls
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('UploadURLs') is not None:
            self.upload_urls = m.get('UploadURLs')
        return self


class GetUrlUploadInfosResponseBodyURLUploadInfoList(TeaModel):
    def __init__(
        self,
        complete_time: str = None,
        creation_time: str = None,
        error_code: str = None,
        error_message: str = None,
        file_size: str = None,
        job_id: str = None,
        media_id: str = None,
        status: str = None,
        upload_url: str = None,
        user_data: str = None,
    ):
        self.complete_time = complete_time
        self.creation_time = creation_time
        self.error_code = error_code
        self.error_message = error_message
        self.file_size = file_size
        self.job_id = job_id
        self.media_id = media_id
        self.status = status
        self.upload_url = upload_url
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.complete_time is not None:
            result['CompleteTime'] = self.complete_time
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.status is not None:
            result['Status'] = self.status
        if self.upload_url is not None:
            result['UploadURL'] = self.upload_url
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompleteTime') is not None:
            self.complete_time = m.get('CompleteTime')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UploadURL') is not None:
            self.upload_url = m.get('UploadURL')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class GetUrlUploadInfosResponseBody(TeaModel):
    def __init__(
        self,
        non_exists: List[str] = None,
        request_id: str = None,
        urlupload_info_list: List[GetUrlUploadInfosResponseBodyURLUploadInfoList] = None,
    ):
        self.non_exists = non_exists
        self.request_id = request_id
        self.urlupload_info_list = urlupload_info_list

    def validate(self):
        if self.urlupload_info_list:
            for k in self.urlupload_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.non_exists is not None:
            result['NonExists'] = self.non_exists
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['URLUploadInfoList'] = []
        if self.urlupload_info_list is not None:
            for k in self.urlupload_info_list:
                result['URLUploadInfoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NonExists') is not None:
            self.non_exists = m.get('NonExists')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.urlupload_info_list = []
        if m.get('URLUploadInfoList') is not None:
            for k in m.get('URLUploadInfoList'):
                temp_model = GetUrlUploadInfosResponseBodyURLUploadInfoList()
                self.urlupload_info_list.append(temp_model.from_map(k))
        return self


class GetUrlUploadInfosResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetUrlUploadInfosResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetUrlUploadInfosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAllPublicMediaTagsRequest(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        entity_id: str = None,
    ):
        # 媒资业务类型
        self.business_type = business_type
        self.entity_id = entity_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        return self


class ListAllPublicMediaTagsResponseBodyMediaTagListOptions(TeaModel):
    def __init__(
        self,
        option_chinese_name: str = None,
        option_english_name: str = None,
        option_id: str = None,
    ):
        self.option_chinese_name = option_chinese_name
        self.option_english_name = option_english_name
        self.option_id = option_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.option_chinese_name is not None:
            result['OptionChineseName'] = self.option_chinese_name
        if self.option_english_name is not None:
            result['OptionEnglishName'] = self.option_english_name
        if self.option_id is not None:
            result['OptionId'] = self.option_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OptionChineseName') is not None:
            self.option_chinese_name = m.get('OptionChineseName')
        if m.get('OptionEnglishName') is not None:
            self.option_english_name = m.get('OptionEnglishName')
        if m.get('OptionId') is not None:
            self.option_id = m.get('OptionId')
        return self


class ListAllPublicMediaTagsResponseBodyMediaTagList(TeaModel):
    def __init__(
        self,
        media_tag_id: str = None,
        media_tag_name_chinese: str = None,
        media_tag_name_english: str = None,
        options: List[ListAllPublicMediaTagsResponseBodyMediaTagListOptions] = None,
    ):
        # 素材标签id
        self.media_tag_id = media_tag_id
        # 素材标签中文名
        self.media_tag_name_chinese = media_tag_name_chinese
        # 素材标签英文名
        self.media_tag_name_english = media_tag_name_english
        self.options = options

    def validate(self):
        if self.options:
            for k in self.options:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_tag_id is not None:
            result['MediaTagId'] = self.media_tag_id
        if self.media_tag_name_chinese is not None:
            result['MediaTagNameChinese'] = self.media_tag_name_chinese
        if self.media_tag_name_english is not None:
            result['MediaTagNameEnglish'] = self.media_tag_name_english
        result['Options'] = []
        if self.options is not None:
            for k in self.options:
                result['Options'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaTagId') is not None:
            self.media_tag_id = m.get('MediaTagId')
        if m.get('MediaTagNameChinese') is not None:
            self.media_tag_name_chinese = m.get('MediaTagNameChinese')
        if m.get('MediaTagNameEnglish') is not None:
            self.media_tag_name_english = m.get('MediaTagNameEnglish')
        self.options = []
        if m.get('Options') is not None:
            for k in m.get('Options'):
                temp_model = ListAllPublicMediaTagsResponseBodyMediaTagListOptions()
                self.options.append(temp_model.from_map(k))
        return self


class ListAllPublicMediaTagsResponseBody(TeaModel):
    def __init__(
        self,
        media_tag_list: List[ListAllPublicMediaTagsResponseBodyMediaTagList] = None,
        request_id: str = None,
    ):
        # 公共素材库标签列表
        self.media_tag_list = media_tag_list
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.media_tag_list:
            for k in self.media_tag_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MediaTagList'] = []
        if self.media_tag_list is not None:
            for k in self.media_tag_list:
                result['MediaTagList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.media_tag_list = []
        if m.get('MediaTagList') is not None:
            for k in m.get('MediaTagList'):
                temp_model = ListAllPublicMediaTagsResponseBodyMediaTagList()
                self.media_tag_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAllPublicMediaTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListAllPublicMediaTagsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAllPublicMediaTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCustomTemplatesRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        order_by: str = None,
        page_number: int = None,
        page_size: int = None,
        subtype: str = None,
        template_id: str = None,
        type: str = None,
    ):
        # 模板名称
        self.name = name
        # 排序顺序：CreateTimeDesc 和 CreateTimeAsc
        self.order_by = order_by
        # 分页数目
        self.page_number = page_number
        # 分页大小
        self.page_size = page_size
        # 模板子类型ID
        self.subtype = subtype
        # 模板ID
        self.template_id = template_id
        # 模板类型。逗号分隔
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.subtype is not None:
            result['Subtype'] = self.subtype
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Subtype') is not None:
            self.subtype = m.get('Subtype')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListCustomTemplatesResponseBodyCustomTemplateList(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        is_default: bool = None,
        modified_time: str = None,
        status: str = None,
        subtype: int = None,
        subtype_name: str = None,
        template_config: str = None,
        template_id: str = None,
        template_name: str = None,
        type: int = None,
        type_name: str = None,
    ):
        # 模板创建时间
        self.create_time = create_time
        # 是否默认模板
        self.is_default = is_default
        # 模板修改时间
        self.modified_time = modified_time
        # 模板状态
        self.status = status
        # 模板子类型ID
        self.subtype = subtype
        # 模板子类型名称
        self.subtype_name = subtype_name
        # 模板参数
        self.template_config = template_config
        # 模板Id
        self.template_id = template_id
        # 模板名称
        self.template_name = template_name
        # 模板类型ID
        self.type = type
        # 模板类型名称
        self.type_name = type_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.status is not None:
            result['Status'] = self.status
        if self.subtype is not None:
            result['Subtype'] = self.subtype
        if self.subtype_name is not None:
            result['SubtypeName'] = self.subtype_name
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.type is not None:
            result['Type'] = self.type
        if self.type_name is not None:
            result['TypeName'] = self.type_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Subtype') is not None:
            self.subtype = m.get('Subtype')
        if m.get('SubtypeName') is not None:
            self.subtype_name = m.get('SubtypeName')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('TypeName') is not None:
            self.type_name = m.get('TypeName')
        return self


class ListCustomTemplatesResponseBody(TeaModel):
    def __init__(
        self,
        custom_template_list: List[ListCustomTemplatesResponseBodyCustomTemplateList] = None,
        request_id: str = None,
        total: int = None,
    ):
        # 模板信息列表
        self.custom_template_list = custom_template_list
        # 请求ID
        self.request_id = request_id
        # 模板总数
        self.total = total

    def validate(self):
        if self.custom_template_list:
            for k in self.custom_template_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CustomTemplateList'] = []
        if self.custom_template_list is not None:
            for k in self.custom_template_list:
                result['CustomTemplateList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.custom_template_list = []
        if m.get('CustomTemplateList') is not None:
            for k in m.get('CustomTemplateList'):
                temp_model = ListCustomTemplatesResponseBodyCustomTemplateList()
                self.custom_template_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListCustomTemplatesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListCustomTemplatesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCustomTemplatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDynamicImageJobsRequest(TeaModel):
    def __init__(
        self,
        end_of_create_time: str = None,
        job_id: str = None,
        next_page_token: str = None,
        order_by: str = None,
        page_size: int = None,
        start_of_create_time: str = None,
        status: str = None,
    ):
        self.end_of_create_time = end_of_create_time
        # 任务ID
        self.job_id = job_id
        # 连续分页查询时下一页的标记
        self.next_page_token = next_page_token
        # 排序顺序：CreateTimeDesc 和 CreateTimeAsc
        self.order_by = order_by
        self.page_size = page_size
        self.start_of_create_time = start_of_create_time
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_of_create_time is not None:
            result['EndOfCreateTime'] = self.end_of_create_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_of_create_time is not None:
            result['StartOfCreateTime'] = self.start_of_create_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndOfCreateTime') is not None:
            self.end_of_create_time = m.get('EndOfCreateTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartOfCreateTime') is not None:
            self.start_of_create_time = m.get('StartOfCreateTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListDynamicImageJobsResponseBodyJobsInput(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        self.media = media
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListDynamicImageJobsResponseBodyJobsOutput(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        self.media = media
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListDynamicImageJobsResponseBodyJobs(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        finish_time: str = None,
        input: ListDynamicImageJobsResponseBodyJobsInput = None,
        job_id: str = None,
        modified_time: str = None,
        name: str = None,
        output: ListDynamicImageJobsResponseBodyJobsOutput = None,
        pipeline_id: str = None,
        status: str = None,
        submit_time: str = None,
        template_id: str = None,
        trigger_source: str = None,
    ):
        self.create_time = create_time
        self.finish_time = finish_time
        self.input = input
        self.job_id = job_id
        self.modified_time = modified_time
        self.name = name
        self.output = output
        self.pipeline_id = pipeline_id
        self.status = status
        self.submit_time = submit_time
        self.template_id = template_id
        self.trigger_source = trigger_source

    def validate(self):
        if self.input:
            self.input.validate()
        if self.output:
            self.output.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.name is not None:
            result['Name'] = self.name
        if self.output is not None:
            result['Output'] = self.output.to_map()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.status is not None:
            result['Status'] = self.status
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.trigger_source is not None:
            result['TriggerSource'] = self.trigger_source
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Input') is not None:
            temp_model = ListDynamicImageJobsResponseBodyJobsInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Output') is not None:
            temp_model = ListDynamicImageJobsResponseBodyJobsOutput()
            self.output = temp_model.from_map(m['Output'])
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TriggerSource') is not None:
            self.trigger_source = m.get('TriggerSource')
        return self


class ListDynamicImageJobsResponseBody(TeaModel):
    def __init__(
        self,
        jobs: List[ListDynamicImageJobsResponseBodyJobs] = None,
        next_page_token: str = None,
        request_id: str = None,
    ):
        self.jobs = jobs
        self.next_page_token = next_page_token
        self.request_id = request_id

    def validate(self):
        if self.jobs:
            for k in self.jobs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Jobs'] = []
        if self.jobs is not None:
            for k in self.jobs:
                result['Jobs'].append(k.to_map() if k else None)
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.jobs = []
        if m.get('Jobs') is not None:
            for k in m.get('Jobs'):
                temp_model = ListDynamicImageJobsResponseBodyJobs()
                self.jobs.append(temp_model.from_map(k))
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListDynamicImageJobsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListDynamicImageJobsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListDynamicImageJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLiveRecordTemplatesRequest(TeaModel):
    def __init__(
        self,
        keyword: str = None,
        page_no: int = None,
        page_size: int = None,
        sort_by: str = None,
        template_ids: List[str] = None,
        type: str = None,
    ):
        self.keyword = keyword
        self.page_no = page_no
        self.page_size = page_size
        self.sort_by = sort_by
        self.template_ids = template_ids
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.template_ids is not None:
            result['TemplateIds'] = self.template_ids
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('TemplateIds') is not None:
            self.template_ids = m.get('TemplateIds')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListLiveRecordTemplatesResponseBodyRecordTemplateListRecordFormatList(TeaModel):
    def __init__(
        self,
        cycle_duration: bytes = None,
        format: bytes = None,
        oss_object_prefix: bytes = None,
        slice_duration: int = None,
        slice_oss_object_prefix: bytes = None,
    ):
        # 录制周期时长
        self.cycle_duration = cycle_duration
        # 格式
        self.format = format
        # Oss对象名
        self.oss_object_prefix = oss_object_prefix
        # 切片时长
        self.slice_duration = slice_duration
        # 切片Oss对象名
        self.slice_oss_object_prefix = slice_oss_object_prefix

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cycle_duration is not None:
            result['CycleDuration'] = self.cycle_duration
        if self.format is not None:
            result['Format'] = self.format
        if self.oss_object_prefix is not None:
            result['OssObjectPrefix'] = self.oss_object_prefix
        if self.slice_duration is not None:
            result['SliceDuration'] = self.slice_duration
        if self.slice_oss_object_prefix is not None:
            result['SliceOssObjectPrefix'] = self.slice_oss_object_prefix
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CycleDuration') is not None:
            self.cycle_duration = m.get('CycleDuration')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('OssObjectPrefix') is not None:
            self.oss_object_prefix = m.get('OssObjectPrefix')
        if m.get('SliceDuration') is not None:
            self.slice_duration = m.get('SliceDuration')
        if m.get('SliceOssObjectPrefix') is not None:
            self.slice_oss_object_prefix = m.get('SliceOssObjectPrefix')
        return self


class ListLiveRecordTemplatesResponseBodyRecordTemplateList(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        last_modified: str = None,
        name: bytes = None,
        record_format_list: List[ListLiveRecordTemplatesResponseBodyRecordTemplateListRecordFormatList] = None,
        template_id: bytes = None,
        type: bytes = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 最后修改时间
        self.last_modified = last_modified
        # 资源名称
        self.name = name
        # 录制格式
        self.record_format_list = record_format_list
        # 资源一级ID
        self.template_id = template_id
        # 资源名称
        self.type = type

    def validate(self):
        if self.record_format_list:
            for k in self.record_format_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_modified is not None:
            result['LastModified'] = self.last_modified
        if self.name is not None:
            result['Name'] = self.name
        result['RecordFormatList'] = []
        if self.record_format_list is not None:
            for k in self.record_format_list:
                result['RecordFormatList'].append(k.to_map() if k else None)
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastModified') is not None:
            self.last_modified = m.get('LastModified')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.record_format_list = []
        if m.get('RecordFormatList') is not None:
            for k in m.get('RecordFormatList'):
                temp_model = ListLiveRecordTemplatesResponseBodyRecordTemplateListRecordFormatList()
                self.record_format_list.append(temp_model.from_map(k))
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListLiveRecordTemplatesResponseBody(TeaModel):
    def __init__(
        self,
        page_no: int = None,
        page_size: int = None,
        record_template_list: List[ListLiveRecordTemplatesResponseBodyRecordTemplateList] = None,
        request_id: str = None,
        sort_by: str = None,
        total_count: int = None,
    ):
        self.page_no = page_no
        self.page_size = page_size
        # 数组，返回示例目录。
        self.record_template_list = record_template_list
        # Id of the request
        self.request_id = request_id
        self.sort_by = sort_by
        # 总记录数。
        self.total_count = total_count

    def validate(self):
        if self.record_template_list:
            for k in self.record_template_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['RecordTemplateList'] = []
        if self.record_template_list is not None:
            for k in self.record_template_list:
                result['RecordTemplateList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.record_template_list = []
        if m.get('RecordTemplateList') is not None:
            for k in m.get('RecordTemplateList'):
                temp_model = ListLiveRecordTemplatesResponseBodyRecordTemplateList()
                self.record_template_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListLiveRecordTemplatesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListLiveRecordTemplatesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListLiveRecordTemplatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLiveTranscodeJobsRequest(TeaModel):
    def __init__(
        self,
        key_word: str = None,
        page_no: int = None,
        page_size: int = None,
        sort_by: str = None,
        start_mode: int = None,
        status: int = None,
        type: str = None,
    ):
        self.key_word = key_word
        self.page_no = page_no
        self.page_size = page_size
        self.sort_by = sort_by
        self.start_mode = start_mode
        self.status = status
        # 模板Id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key_word is not None:
            result['KeyWord'] = self.key_word
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.start_mode is not None:
            result['StartMode'] = self.start_mode
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('KeyWord') is not None:
            self.key_word = m.get('KeyWord')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('StartMode') is not None:
            self.start_mode = m.get('StartMode')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListLiveTranscodeJobsResponseBodyJobListOutputStreamStreamInfos(TeaModel):
    def __init__(
        self,
        output_url: str = None,
        type: str = None,
    ):
        self.output_url = output_url
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output_url is not None:
            result['OutputUrl'] = self.output_url
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OutputUrl') is not None:
            self.output_url = m.get('OutputUrl')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListLiveTranscodeJobsResponseBodyJobListOutputStream(TeaModel):
    def __init__(
        self,
        stream_infos: List[ListLiveTranscodeJobsResponseBodyJobListOutputStreamStreamInfos] = None,
    ):
        self.stream_infos = stream_infos

    def validate(self):
        if self.stream_infos:
            for k in self.stream_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['StreamInfos'] = []
        if self.stream_infos is not None:
            for k in self.stream_infos:
                result['StreamInfos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.stream_infos = []
        if m.get('StreamInfos') is not None:
            for k in m.get('StreamInfos'):
                temp_model = ListLiveTranscodeJobsResponseBodyJobListOutputStreamStreamInfos()
                self.stream_infos.append(temp_model.from_map(k))
        return self


class ListLiveTranscodeJobsResponseBodyJobListStreamInput(TeaModel):
    def __init__(
        self,
        input_url: str = None,
        type: str = None,
    ):
        self.input_url = input_url
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_url is not None:
            result['InputUrl'] = self.input_url
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InputUrl') is not None:
            self.input_url = m.get('InputUrl')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListLiveTranscodeJobsResponseBodyJobList(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        job_id: str = None,
        name: str = None,
        output_stream: ListLiveTranscodeJobsResponseBodyJobListOutputStream = None,
        start_mode: int = None,
        status: int = None,
        stream_input: ListLiveTranscodeJobsResponseBodyJobListStreamInput = None,
        template_id: str = None,
        template_name: str = None,
        template_type: str = None,
    ):
        self.create_time = create_time
        self.job_id = job_id
        self.name = name
        self.output_stream = output_stream
        self.start_mode = start_mode
        self.status = status
        self.stream_input = stream_input
        self.template_id = template_id
        self.template_name = template_name
        self.template_type = template_type

    def validate(self):
        if self.output_stream:
            self.output_stream.validate()
        if self.stream_input:
            self.stream_input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.name is not None:
            result['Name'] = self.name
        if self.output_stream is not None:
            result['OutputStream'] = self.output_stream.to_map()
        if self.start_mode is not None:
            result['StartMode'] = self.start_mode
        if self.status is not None:
            result['Status'] = self.status
        if self.stream_input is not None:
            result['StreamInput'] = self.stream_input.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OutputStream') is not None:
            temp_model = ListLiveTranscodeJobsResponseBodyJobListOutputStream()
            self.output_stream = temp_model.from_map(m['OutputStream'])
        if m.get('StartMode') is not None:
            self.start_mode = m.get('StartMode')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StreamInput') is not None:
            temp_model = ListLiveTranscodeJobsResponseBodyJobListStreamInput()
            self.stream_input = temp_model.from_map(m['StreamInput'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        return self


class ListLiveTranscodeJobsResponseBody(TeaModel):
    def __init__(
        self,
        job_list: List[ListLiveTranscodeJobsResponseBodyJobList] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.job_list = job_list
        # 请求ID
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.job_list:
            for k in self.job_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['JobList'] = []
        if self.job_list is not None:
            for k in self.job_list:
                result['JobList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.job_list = []
        if m.get('JobList') is not None:
            for k in m.get('JobList'):
                temp_model = ListLiveTranscodeJobsResponseBodyJobList()
                self.job_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListLiveTranscodeJobsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListLiveTranscodeJobsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListLiveTranscodeJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLiveTranscodeTemplatesRequest(TeaModel):
    def __init__(
        self,
        category: str = None,
        key_word: str = None,
        page_no: int = None,
        page_size: int = None,
        sort_by: str = None,
        type: str = None,
        video_codec: str = None,
    ):
        self.category = category
        self.key_word = key_word
        self.page_no = page_no
        self.page_size = page_size
        self.sort_by = sort_by
        # 模板Id
        self.type = type
        self.video_codec = video_codec

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.key_word is not None:
            result['KeyWord'] = self.key_word
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.type is not None:
            result['Type'] = self.type
        if self.video_codec is not None:
            result['VideoCodec'] = self.video_codec
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('KeyWord') is not None:
            self.key_word = m.get('KeyWord')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VideoCodec') is not None:
            self.video_codec = m.get('VideoCodec')
        return self


class ListLiveTranscodeTemplatesResponseBodyTemplateContentListTemplateConfigAudioParams(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        channels: str = None,
        codec: str = None,
        profile: str = None,
        samplerate: str = None,
    ):
        self.bitrate = bitrate
        self.channels = channels
        self.codec = codec
        self.profile = profile
        self.samplerate = samplerate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        return self


class ListLiveTranscodeTemplatesResponseBodyTemplateContentListTemplateConfigVideoParams(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        codec: str = None,
        fps: str = None,
        gop: str = None,
        height: str = None,
        profile: str = None,
        width: str = None,
    ):
        self.bitrate = bitrate
        self.codec = codec
        self.fps = fps
        self.gop = gop
        self.height = height
        self.profile = profile
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListLiveTranscodeTemplatesResponseBodyTemplateContentListTemplateConfig(TeaModel):
    def __init__(
        self,
        audio_params: ListLiveTranscodeTemplatesResponseBodyTemplateContentListTemplateConfigAudioParams = None,
        video_params: ListLiveTranscodeTemplatesResponseBodyTemplateContentListTemplateConfigVideoParams = None,
    ):
        self.audio_params = audio_params
        self.video_params = video_params

    def validate(self):
        if self.audio_params:
            self.audio_params.validate()
        if self.video_params:
            self.video_params.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_params is not None:
            result['AudioParams'] = self.audio_params.to_map()
        if self.video_params is not None:
            result['VideoParams'] = self.video_params.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AudioParams') is not None:
            temp_model = ListLiveTranscodeTemplatesResponseBodyTemplateContentListTemplateConfigAudioParams()
            self.audio_params = temp_model.from_map(m['AudioParams'])
        if m.get('VideoParams') is not None:
            temp_model = ListLiveTranscodeTemplatesResponseBodyTemplateContentListTemplateConfigVideoParams()
            self.video_params = temp_model.from_map(m['VideoParams'])
        return self


class ListLiveTranscodeTemplatesResponseBodyTemplateContentList(TeaModel):
    def __init__(
        self,
        category: str = None,
        create_time: str = None,
        name: str = None,
        template_config: ListLiveTranscodeTemplatesResponseBodyTemplateContentListTemplateConfig = None,
        template_id: str = None,
        type: str = None,
    ):
        self.category = category
        self.create_time = create_time
        self.name = name
        self.template_config = template_config
        self.template_id = template_id
        self.type = type

    def validate(self):
        if self.template_config:
            self.template_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.name is not None:
            result['Name'] = self.name
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TemplateConfig') is not None:
            temp_model = ListLiveTranscodeTemplatesResponseBodyTemplateContentListTemplateConfig()
            self.template_config = temp_model.from_map(m['TemplateConfig'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListLiveTranscodeTemplatesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template_content_list: List[ListLiveTranscodeTemplatesResponseBodyTemplateContentList] = None,
        total_count: int = None,
    ):
        # 请求ID
        self.request_id = request_id
        self.template_content_list = template_content_list
        self.total_count = total_count

    def validate(self):
        if self.template_content_list:
            for k in self.template_content_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TemplateContentList'] = []
        if self.template_content_list is not None:
            for k in self.template_content_list:
                result['TemplateContentList'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.template_content_list = []
        if m.get('TemplateContentList') is not None:
            for k in m.get('TemplateContentList'):
                temp_model = ListLiveTranscodeTemplatesResponseBodyTemplateContentList()
                self.template_content_list.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListLiveTranscodeTemplatesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListLiveTranscodeTemplatesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListLiveTranscodeTemplatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListMediaBasicInfosRequest(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        end_time: str = None,
        include_file_basic_info: bool = None,
        max_results: int = None,
        media_id: str = None,
        media_type: str = None,
        next_token: str = None,
        sort_by: str = None,
        source: str = None,
        start_time: str = None,
        status: str = None,
    ):
        # 媒资业务类型
        self.business_type = business_type
        # 结束时间
        self.end_time = end_time
        # 返回值中是否包含文件基础信息
        self.include_file_basic_info = include_file_basic_info
        # 分页大小
        self.max_results = max_results
        # 媒资ID，单个媒资ID支持前缀匹配
        self.media_id = media_id
        # 媒资媒体类型
        self.media_type = media_type
        # 页号
        self.next_token = next_token
        # 排序
        self.sort_by = sort_by
        # 来源
        self.source = source
        # 创建时间
        self.start_time = start_time
        # 资源状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.include_file_basic_info is not None:
            result['IncludeFileBasicInfo'] = self.include_file_basic_info
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.source is not None:
            result['Source'] = self.source
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IncludeFileBasicInfo') is not None:
            self.include_file_basic_info = m.get('IncludeFileBasicInfo')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListMediaBasicInfosResponseBodyMediaInfosFileInfoListFileBasicInfo(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        create_time: str = None,
        duration: str = None,
        file_name: str = None,
        file_size: str = None,
        file_status: str = None,
        file_type: str = None,
        file_url: str = None,
        format_name: str = None,
        height: str = None,
        modified_time: str = None,
        region: str = None,
        width: str = None,
    ):
        # 码率
        self.bitrate = bitrate
        self.create_time = create_time
        # 时长
        self.duration = duration
        # 文件名
        self.file_name = file_name
        # 文件大小（字节）
        self.file_size = file_size
        # 文件状态
        self.file_status = file_status
        self.file_type = file_type
        # 文件oss地址
        self.file_url = file_url
        # 封装格式
        self.format_name = format_name
        # 高
        self.height = height
        self.modified_time = modified_time
        # 文件存储区域
        self.region = region
        # 宽
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListMediaBasicInfosResponseBodyMediaInfosFileInfoList(TeaModel):
    def __init__(
        self,
        file_basic_info: ListMediaBasicInfosResponseBodyMediaInfosFileInfoListFileBasicInfo = None,
    ):
        # 文件基础信息，包含时长，大小等
        self.file_basic_info = file_basic_info

    def validate(self):
        if self.file_basic_info:
            self.file_basic_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileBasicInfo') is not None:
            temp_model = ListMediaBasicInfosResponseBodyMediaInfosFileInfoListFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        return self


class ListMediaBasicInfosResponseBodyMediaInfosMediaBasicInfo(TeaModel):
    def __init__(
        self,
        biz: str = None,
        business_type: str = None,
        cate_id: int = None,
        category: str = None,
        cover_url: str = None,
        create_time: str = None,
        deleted_time: str = None,
        description: str = None,
        input_url: str = None,
        media_id: str = None,
        media_tags: str = None,
        media_type: str = None,
        modified_time: str = None,
        snapshots: str = None,
        source: str = None,
        sprite_images: str = None,
        status: str = None,
        title: str = None,
        transcode_status: str = None,
        upload_source: str = None,
        user_data: str = None,
    ):
        self.biz = biz
        # 媒资业务类型
        self.business_type = business_type
        self.cate_id = cate_id
        # 分类
        self.category = category
        # 封面地址
        self.cover_url = cover_url
        # 媒资创建时间
        self.create_time = create_time
        # 媒资删除时间
        self.deleted_time = deleted_time
        # 内容描述
        self.description = description
        # 待注册的媒资在相应系统中的地址
        self.input_url = input_url
        # MediaId
        self.media_id = media_id
        # 标签
        self.media_tags = media_tags
        # 媒资媒体类型
        self.media_type = media_type
        # 媒资修改时间
        self.modified_time = modified_time
        # 截图
        self.snapshots = snapshots
        # 来源
        self.source = source
        # 雪碧图
        self.sprite_images = sprite_images
        # 资源状态
        self.status = status
        # 标题
        self.title = title
        # 转码状态
        self.transcode_status = transcode_status
        self.upload_source = upload_source
        # 用户数据
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz is not None:
            result['Biz'] = self.biz
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.category is not None:
            result['Category'] = self.category
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.deleted_time is not None:
            result['DeletedTime'] = self.deleted_time
        if self.description is not None:
            result['Description'] = self.description
        if self.input_url is not None:
            result['InputURL'] = self.input_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_tags is not None:
            result['MediaTags'] = self.media_tags
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.snapshots is not None:
            result['Snapshots'] = self.snapshots
        if self.source is not None:
            result['Source'] = self.source
        if self.sprite_images is not None:
            result['SpriteImages'] = self.sprite_images
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        if self.transcode_status is not None:
            result['TranscodeStatus'] = self.transcode_status
        if self.upload_source is not None:
            result['UploadSource'] = self.upload_source
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Biz') is not None:
            self.biz = m.get('Biz')
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeletedTime') is not None:
            self.deleted_time = m.get('DeletedTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InputURL') is not None:
            self.input_url = m.get('InputURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaTags') is not None:
            self.media_tags = m.get('MediaTags')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Snapshots') is not None:
            self.snapshots = m.get('Snapshots')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SpriteImages') is not None:
            self.sprite_images = m.get('SpriteImages')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('TranscodeStatus') is not None:
            self.transcode_status = m.get('TranscodeStatus')
        if m.get('UploadSource') is not None:
            self.upload_source = m.get('UploadSource')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class ListMediaBasicInfosResponseBodyMediaInfos(TeaModel):
    def __init__(
        self,
        file_info_list: List[ListMediaBasicInfosResponseBodyMediaInfosFileInfoList] = None,
        media_basic_info: ListMediaBasicInfosResponseBodyMediaInfosMediaBasicInfo = None,
        media_id: str = None,
    ):
        # FileInfos
        self.file_info_list = file_info_list
        # BasicInfo
        self.media_basic_info = media_basic_info
        # 媒资ID
        self.media_id = media_id

    def validate(self):
        if self.file_info_list:
            for k in self.file_info_list:
                if k:
                    k.validate()
        if self.media_basic_info:
            self.media_basic_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FileInfoList'] = []
        if self.file_info_list is not None:
            for k in self.file_info_list:
                result['FileInfoList'].append(k.to_map() if k else None)
        if self.media_basic_info is not None:
            result['MediaBasicInfo'] = self.media_basic_info.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.file_info_list = []
        if m.get('FileInfoList') is not None:
            for k in m.get('FileInfoList'):
                temp_model = ListMediaBasicInfosResponseBodyMediaInfosFileInfoList()
                self.file_info_list.append(temp_model.from_map(k))
        if m.get('MediaBasicInfo') is not None:
            temp_model = ListMediaBasicInfosResponseBodyMediaInfosMediaBasicInfo()
            self.media_basic_info = temp_model.from_map(m['MediaBasicInfo'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class ListMediaBasicInfosResponseBody(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        media_infos: List[ListMediaBasicInfosResponseBodyMediaInfos] = None,
        next_token: str = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.max_results = max_results
        # 符合要求的媒资集合
        self.media_infos = media_infos
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        # 符合要求的媒资总数
        self.total_count = total_count

    def validate(self):
        if self.media_infos:
            for k in self.media_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        result['MediaInfos'] = []
        if self.media_infos is not None:
            for k in self.media_infos:
                result['MediaInfos'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        self.media_infos = []
        if m.get('MediaInfos') is not None:
            for k in m.get('MediaInfos'):
                temp_model = ListMediaBasicInfosResponseBodyMediaInfos()
                self.media_infos.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListMediaBasicInfosResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListMediaBasicInfosResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListMediaBasicInfosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListMediaInfoJobsRequest(TeaModel):
    def __init__(
        self,
        end_of_create_time: str = None,
        job_id: str = None,
        next_page_token: str = None,
        order_by: str = None,
        page_size: int = None,
        start_of_create_time: str = None,
        status: str = None,
    ):
        # 任务创建时间筛选条件的结束时间
        self.end_of_create_time = end_of_create_time
        # 按 jobId 筛选
        self.job_id = job_id
        # 连续分页查询时下一页的标记 (第一页没有)
        self.next_page_token = next_page_token
        # 排序顺序，目前只支持两种：CreateTimeDesc 和 CreateTimeAsc
        self.order_by = order_by
        self.page_size = page_size
        # 任务创建时间筛选条件的起始时间
        self.start_of_create_time = start_of_create_time
        # 任务状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_of_create_time is not None:
            result['EndOfCreateTime'] = self.end_of_create_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_of_create_time is not None:
            result['StartOfCreateTime'] = self.start_of_create_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndOfCreateTime') is not None:
            self.end_of_create_time = m.get('EndOfCreateTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartOfCreateTime') is not None:
            self.start_of_create_time = m.get('StartOfCreateTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListMediaInfoJobsResponseBodyJobsInput(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        # 媒体值：
        #       type 为 OSS 时，为 url, 支持 oss 协议和 http 协议；
        #       type 为 Media 时，为媒资 id。
        self.media = media
        # 媒体对象类型 - OSS: oss文件, Media: 媒资 ID
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListMediaInfoJobsResponseBodyJobsMediaInfoPropertyAudioStreamInfoList(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        channel_layout: str = None,
        channels: str = None,
        codec_long_name: str = None,
        codec_name: str = None,
        codec_tag: str = None,
        codec_tag_string: str = None,
        codec_time_base: str = None,
        duration: str = None,
        index: str = None,
        lang: str = None,
        sample_fmt: str = None,
        sample_rate: str = None,
        start_time: str = None,
        timebase: str = None,
    ):
        # 码率
        self.bitrate = bitrate
        # 声道布局
        self.channel_layout = channel_layout
        # 声道数
        self.channels = channels
        # 编码格式名
        self.codec_long_name = codec_long_name
        # 编码格式
        self.codec_name = codec_name
        # 编码器标签
        self.codec_tag = codec_tag
        # 编码器标签名
        self.codec_tag_string = codec_tag_string
        # 编码器时间基
        self.codec_time_base = codec_time_base
        # 时长
        self.duration = duration
        # 流序号
        self.index = index
        # 语言
        self.lang = lang
        self.sample_fmt = sample_fmt
        # 采样率
        self.sample_rate = sample_rate
        # 开始时间
        self.start_time = start_time
        # 时间基
        self.timebase = timebase

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channel_layout is not None:
            result['ChannelLayout'] = self.channel_layout
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec_long_name is not None:
            result['CodecLongName'] = self.codec_long_name
        if self.codec_name is not None:
            result['CodecName'] = self.codec_name
        if self.codec_tag is not None:
            result['CodecTag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['CodecTagString'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['CodecTimeBase'] = self.codec_time_base
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.sample_fmt is not None:
            result['SampleFmt'] = self.sample_fmt
        if self.sample_rate is not None:
            result['SampleRate'] = self.sample_rate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.timebase is not None:
            result['Timebase'] = self.timebase
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('ChannelLayout') is not None:
            self.channel_layout = m.get('ChannelLayout')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('CodecLongName') is not None:
            self.codec_long_name = m.get('CodecLongName')
        if m.get('CodecName') is not None:
            self.codec_name = m.get('CodecName')
        if m.get('CodecTag') is not None:
            self.codec_tag = m.get('CodecTag')
        if m.get('CodecTagString') is not None:
            self.codec_tag_string = m.get('CodecTagString')
        if m.get('CodecTimeBase') is not None:
            self.codec_time_base = m.get('CodecTimeBase')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SampleFmt') is not None:
            self.sample_fmt = m.get('SampleFmt')
        if m.get('SampleRate') is not None:
            self.sample_rate = m.get('SampleRate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Timebase') is not None:
            self.timebase = m.get('Timebase')
        return self


class ListMediaInfoJobsResponseBodyJobsMediaInfoPropertyFileBasicInfo(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        duration: str = None,
        file_name: str = None,
        file_size: str = None,
        file_status: str = None,
        file_type: str = None,
        file_url: str = None,
        format_name: str = None,
        height: str = None,
        media_id: str = None,
        region: str = None,
        width: str = None,
    ):
        # 视频码率
        self.bitrate = bitrate
        # 视频时长
        self.duration = duration
        # 文件名
        self.file_name = file_name
        # 文件大小
        self.file_size = file_size
        # 文件状态
        self.file_status = file_status
        # 文件类型
        self.file_type = file_type
        # 文件url
        self.file_url = file_url
        # 视频格式名称
        self.format_name = format_name
        # 高
        self.height = height
        # 媒资ID
        self.media_id = media_id
        # 文件所在区域
        self.region = region
        # 宽
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListMediaInfoJobsResponseBodyJobsMediaInfoPropertyVideoStreamInfoList(TeaModel):
    def __init__(
        self,
        avg_fps: str = None,
        bit_rate: str = None,
        codec_long_name: str = None,
        codec_name: str = None,
        codec_tag: str = None,
        codec_tag_string: str = None,
        codec_time_base: str = None,
        dar: str = None,
        duration: str = None,
        fps: str = None,
        has_bframes: str = None,
        height: str = None,
        index: str = None,
        lang: str = None,
        level: str = None,
        num_frames: str = None,
        pix_fmt: str = None,
        profile: str = None,
        rotate: str = None,
        sar: str = None,
        start_time: str = None,
        time_base: str = None,
        width: str = None,
    ):
        self.avg_fps = avg_fps
        self.bit_rate = bit_rate
        # 编码格式名
        self.codec_long_name = codec_long_name
        # 编码格式
        self.codec_name = codec_name
        # 编码格式标记
        self.codec_tag = codec_tag
        # 编码格式标记文本
        self.codec_tag_string = codec_tag_string
        self.codec_time_base = codec_time_base
        # 图像显示宽高比
        self.dar = dar
        # 时长
        self.duration = duration
        # 帧率
        self.fps = fps
        self.has_bframes = has_bframes
        # 高
        self.height = height
        # 流序号
        self.index = index
        # 语言
        self.lang = lang
        # 编码等级
        self.level = level
        # 总帧数
        self.num_frames = num_frames
        # 颜色存储格式
        self.pix_fmt = pix_fmt
        # 编码器预设
        self.profile = profile
        # 视频画面旋转角度
        self.rotate = rotate
        # 采集点数宽高比
        self.sar = sar
        # 起始时间
        self.start_time = start_time
        self.time_base = time_base
        # 宽
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_fps is not None:
            result['Avg_fps'] = self.avg_fps
        if self.bit_rate is not None:
            result['Bit_rate'] = self.bit_rate
        if self.codec_long_name is not None:
            result['Codec_long_name'] = self.codec_long_name
        if self.codec_name is not None:
            result['Codec_name'] = self.codec_name
        if self.codec_tag is not None:
            result['Codec_tag'] = self.codec_tag
        if self.codec_tag_string is not None:
            result['Codec_tag_string'] = self.codec_tag_string
        if self.codec_time_base is not None:
            result['Codec_time_base'] = self.codec_time_base
        if self.dar is not None:
            result['Dar'] = self.dar
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.has_bframes is not None:
            result['Has_b_frames'] = self.has_bframes
        if self.height is not None:
            result['Height'] = self.height
        if self.index is not None:
            result['Index'] = self.index
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.level is not None:
            result['Level'] = self.level
        if self.num_frames is not None:
            result['NumFrames'] = self.num_frames
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.rotate is not None:
            result['Rotate'] = self.rotate
        if self.sar is not None:
            result['Sar'] = self.sar
        if self.start_time is not None:
            result['Start_time'] = self.start_time
        if self.time_base is not None:
            result['Time_base'] = self.time_base
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Avg_fps') is not None:
            self.avg_fps = m.get('Avg_fps')
        if m.get('Bit_rate') is not None:
            self.bit_rate = m.get('Bit_rate')
        if m.get('Codec_long_name') is not None:
            self.codec_long_name = m.get('Codec_long_name')
        if m.get('Codec_name') is not None:
            self.codec_name = m.get('Codec_name')
        if m.get('Codec_tag') is not None:
            self.codec_tag = m.get('Codec_tag')
        if m.get('Codec_tag_string') is not None:
            self.codec_tag_string = m.get('Codec_tag_string')
        if m.get('Codec_time_base') is not None:
            self.codec_time_base = m.get('Codec_time_base')
        if m.get('Dar') is not None:
            self.dar = m.get('Dar')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Has_b_frames') is not None:
            self.has_bframes = m.get('Has_b_frames')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('NumFrames') is not None:
            self.num_frames = m.get('NumFrames')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Rotate') is not None:
            self.rotate = m.get('Rotate')
        if m.get('Sar') is not None:
            self.sar = m.get('Sar')
        if m.get('Start_time') is not None:
            self.start_time = m.get('Start_time')
        if m.get('Time_base') is not None:
            self.time_base = m.get('Time_base')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListMediaInfoJobsResponseBodyJobsMediaInfoProperty(TeaModel):
    def __init__(
        self,
        audio_stream_info_list: List[ListMediaInfoJobsResponseBodyJobsMediaInfoPropertyAudioStreamInfoList] = None,
        file_basic_info: ListMediaInfoJobsResponseBodyJobsMediaInfoPropertyFileBasicInfo = None,
        video_stream_info_list: List[ListMediaInfoJobsResponseBodyJobsMediaInfoPropertyVideoStreamInfoList] = None,
    ):
        # 音频流信息
        self.audio_stream_info_list = audio_stream_info_list
        # 基础文件信息
        self.file_basic_info = file_basic_info
        # 视频流信息
        self.video_stream_info_list = video_stream_info_list

    def validate(self):
        if self.audio_stream_info_list:
            for k in self.audio_stream_info_list:
                if k:
                    k.validate()
        if self.file_basic_info:
            self.file_basic_info.validate()
        if self.video_stream_info_list:
            for k in self.video_stream_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioStreamInfoList'] = []
        if self.audio_stream_info_list is not None:
            for k in self.audio_stream_info_list:
                result['AudioStreamInfoList'].append(k.to_map() if k else None)
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        result['VideoStreamInfoList'] = []
        if self.video_stream_info_list is not None:
            for k in self.video_stream_info_list:
                result['VideoStreamInfoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.audio_stream_info_list = []
        if m.get('AudioStreamInfoList') is not None:
            for k in m.get('AudioStreamInfoList'):
                temp_model = ListMediaInfoJobsResponseBodyJobsMediaInfoPropertyAudioStreamInfoList()
                self.audio_stream_info_list.append(temp_model.from_map(k))
        if m.get('FileBasicInfo') is not None:
            temp_model = ListMediaInfoJobsResponseBodyJobsMediaInfoPropertyFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        self.video_stream_info_list = []
        if m.get('VideoStreamInfoList') is not None:
            for k in m.get('VideoStreamInfoList'):
                temp_model = ListMediaInfoJobsResponseBodyJobsMediaInfoPropertyVideoStreamInfoList()
                self.video_stream_info_list.append(temp_model.from_map(k))
        return self


class ListMediaInfoJobsResponseBodyJobsScheduleConfig(TeaModel):
    def __init__(
        self,
        pipeline_id: str = None,
        priority: int = None,
    ):
        # 管道 id
        self.pipeline_id = pipeline_id
        # 任务优先级，取值范围：1~10
        self.priority = priority

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        return self


class ListMediaInfoJobsResponseBodyJobs(TeaModel):
    def __init__(
        self,
        async_: bool = None,
        finish_time: str = None,
        input: ListMediaInfoJobsResponseBodyJobsInput = None,
        job_id: str = None,
        media_info_property: ListMediaInfoJobsResponseBodyJobsMediaInfoProperty = None,
        name: str = None,
        request_id: str = None,
        schedule_config: ListMediaInfoJobsResponseBodyJobsScheduleConfig = None,
        status: str = None,
        submit_result_json: Dict[str, Any] = None,
        submit_time: str = None,
        trigger_source: str = None,
        user_data: str = None,
    ):
        # 是否异步处理
        self.async_ = async_
        # 任务完成时间
        self.finish_time = finish_time
        # 任务输入
        self.input = input
        # 任务 id
        self.job_id = job_id
        # 媒体信息详情
        self.media_info_property = media_info_property
        # 任务名字
        self.name = name
        # 请求 id
        self.request_id = request_id
        # 调度信息
        self.schedule_config = schedule_config
        # 任务状态 - Init: 已提交, Success: 成功, Fail: 失败
        self.status = status
        # 任务提交信息
        self.submit_result_json = submit_result_json
        # 任务提交时间
        self.submit_time = submit_time
        # 任务来源 - API, WorkFlow, Console
        self.trigger_source = trigger_source
        # 用户数据
        self.user_data = user_data

    def validate(self):
        if self.input:
            self.input.validate()
        if self.media_info_property:
            self.media_info_property.validate()
        if self.schedule_config:
            self.schedule_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.async_ is not None:
            result['Async'] = self.async_
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.media_info_property is not None:
            result['MediaInfoProperty'] = self.media_info_property.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.schedule_config is not None:
            result['ScheduleConfig'] = self.schedule_config.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.submit_result_json is not None:
            result['SubmitResultJson'] = self.submit_result_json
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        if self.trigger_source is not None:
            result['TriggerSource'] = self.trigger_source
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Async') is not None:
            self.async_ = m.get('Async')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Input') is not None:
            temp_model = ListMediaInfoJobsResponseBodyJobsInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MediaInfoProperty') is not None:
            temp_model = ListMediaInfoJobsResponseBodyJobsMediaInfoProperty()
            self.media_info_property = temp_model.from_map(m['MediaInfoProperty'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScheduleConfig') is not None:
            temp_model = ListMediaInfoJobsResponseBodyJobsScheduleConfig()
            self.schedule_config = temp_model.from_map(m['ScheduleConfig'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubmitResultJson') is not None:
            self.submit_result_json = m.get('SubmitResultJson')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        if m.get('TriggerSource') is not None:
            self.trigger_source = m.get('TriggerSource')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class ListMediaInfoJobsResponseBody(TeaModel):
    def __init__(
        self,
        jobs: List[ListMediaInfoJobsResponseBodyJobs] = None,
        next_page_token: str = None,
        request_id: str = None,
    ):
        self.jobs = jobs
        self.next_page_token = next_page_token
        # 请求 id
        self.request_id = request_id

    def validate(self):
        if self.jobs:
            for k in self.jobs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Jobs'] = []
        if self.jobs is not None:
            for k in self.jobs:
                result['Jobs'].append(k.to_map() if k else None)
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.jobs = []
        if m.get('Jobs') is not None:
            for k in m.get('Jobs'):
                temp_model = ListMediaInfoJobsResponseBodyJobs()
                self.jobs.append(temp_model.from_map(k))
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListMediaInfoJobsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListMediaInfoJobsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListMediaInfoJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPipelinesRequest(TeaModel):
    def __init__(
        self,
        speed: str = None,
    ):
        # 管道类型。
        self.speed = speed

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.speed is not None:
            result['Speed'] = self.speed
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        return self


class ListPipelinesResponseBodyPipelineList(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        modified_time: str = None,
        name: str = None,
        pipeline_id: str = None,
        priority: int = None,
        speed: str = None,
        status: str = None,
    ):
        # 模板创建时间
        self.create_time = create_time
        # 模板修改时间
        self.modified_time = modified_time
        # 管道名称
        self.name = name
        # 管道Id
        self.pipeline_id = pipeline_id
        # 管道优先级
        self.priority = priority
        # 管道类型
        self.speed = speed
        # 管道状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.name is not None:
            result['Name'] = self.name
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.speed is not None:
            result['Speed'] = self.speed
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListPipelinesResponseBody(TeaModel):
    def __init__(
        self,
        pipeline_list: List[ListPipelinesResponseBodyPipelineList] = None,
        request_id: str = None,
    ):
        self.pipeline_list = pipeline_list
        # 请求ID
        self.request_id = request_id

    def validate(self):
        if self.pipeline_list:
            for k in self.pipeline_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PipelineList'] = []
        if self.pipeline_list is not None:
            for k in self.pipeline_list:
                result['PipelineList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.pipeline_list = []
        if m.get('PipelineList') is not None:
            for k in m.get('PipelineList'):
                temp_model = ListPipelinesResponseBodyPipelineList()
                self.pipeline_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListPipelinesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListPipelinesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPipelinesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPublicMediaBasicInfosRequest(TeaModel):
    def __init__(
        self,
        include_file_basic_info: bool = None,
        max_results: int = None,
        media_tag_id: str = None,
        next_token: str = None,
    ):
        # 返回值中是否包含文件基础信息
        self.include_file_basic_info = include_file_basic_info
        # 分页大小
        self.max_results = max_results
        # 标签
        self.media_tag_id = media_tag_id
        # 下一次读取的位置
        self.next_token = next_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.include_file_basic_info is not None:
            result['IncludeFileBasicInfo'] = self.include_file_basic_info
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.media_tag_id is not None:
            result['MediaTagId'] = self.media_tag_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IncludeFileBasicInfo') is not None:
            self.include_file_basic_info = m.get('IncludeFileBasicInfo')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('MediaTagId') is not None:
            self.media_tag_id = m.get('MediaTagId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class ListPublicMediaBasicInfosResponseBodyMediaInfosFileInfoListFileBasicInfo(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        duration: str = None,
        file_name: str = None,
        file_size: str = None,
        file_status: str = None,
        file_type: str = None,
        file_url: str = None,
        format_name: str = None,
        height: str = None,
        region: str = None,
        width: str = None,
    ):
        # 码率
        self.bitrate = bitrate
        # 时长
        self.duration = duration
        # 文件名
        self.file_name = file_name
        # 文件大小（字节）
        self.file_size = file_size
        # 文件状态
        self.file_status = file_status
        # 文件类型
        self.file_type = file_type
        # 文件oss地址
        self.file_url = file_url
        # 封装格式
        self.format_name = format_name
        # 高
        self.height = height
        # 文件存储区域
        self.region = region
        # 宽
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileStatus') is not None:
            self.file_status = m.get('FileStatus')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('FormatName') is not None:
            self.format_name = m.get('FormatName')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListPublicMediaBasicInfosResponseBodyMediaInfosFileInfoList(TeaModel):
    def __init__(
        self,
        file_basic_info: ListPublicMediaBasicInfosResponseBodyMediaInfosFileInfoListFileBasicInfo = None,
    ):
        # 文件基础信息，包含时长，大小等
        self.file_basic_info = file_basic_info

    def validate(self):
        if self.file_basic_info:
            self.file_basic_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_basic_info is not None:
            result['FileBasicInfo'] = self.file_basic_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileBasicInfo') is not None:
            temp_model = ListPublicMediaBasicInfosResponseBodyMediaInfosFileInfoListFileBasicInfo()
            self.file_basic_info = temp_model.from_map(m['FileBasicInfo'])
        return self


class ListPublicMediaBasicInfosResponseBodyMediaInfosMediaBasicInfo(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        category: str = None,
        cover_url: str = None,
        create_time: str = None,
        deleted_time: str = None,
        description: str = None,
        input_url: str = None,
        media_id: str = None,
        media_tags: str = None,
        media_type: str = None,
        modified_time: str = None,
        snapshots: str = None,
        source: str = None,
        status: str = None,
        title: str = None,
        transcode_status: str = None,
        user_data: str = None,
    ):
        # 媒资业务类型
        self.business_type = business_type
        # 分类
        self.category = category
        # 封面地址
        self.cover_url = cover_url
        # 媒资创建时间
        self.create_time = create_time
        # 媒资删除时间
        self.deleted_time = deleted_time
        # 内容描述
        self.description = description
        # 待注册的媒资在相应系统中的地址
        self.input_url = input_url
        # MediaId
        self.media_id = media_id
        # 标签
        self.media_tags = media_tags
        # 媒资媒体类型
        self.media_type = media_type
        # 媒资修改时间
        self.modified_time = modified_time
        # 截图
        self.snapshots = snapshots
        # 来源
        self.source = source
        # 资源状态
        self.status = status
        # 标题
        self.title = title
        # 转码状态
        self.transcode_status = transcode_status
        # 用户数据
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.category is not None:
            result['Category'] = self.category
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.deleted_time is not None:
            result['DeletedTime'] = self.deleted_time
        if self.description is not None:
            result['Description'] = self.description
        if self.input_url is not None:
            result['InputURL'] = self.input_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.media_tags is not None:
            result['MediaTags'] = self.media_tags
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.snapshots is not None:
            result['Snapshots'] = self.snapshots
        if self.source is not None:
            result['Source'] = self.source
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        if self.transcode_status is not None:
            result['TranscodeStatus'] = self.transcode_status
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeletedTime') is not None:
            self.deleted_time = m.get('DeletedTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InputURL') is not None:
            self.input_url = m.get('InputURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('MediaTags') is not None:
            self.media_tags = m.get('MediaTags')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Snapshots') is not None:
            self.snapshots = m.get('Snapshots')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('TranscodeStatus') is not None:
            self.transcode_status = m.get('TranscodeStatus')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class ListPublicMediaBasicInfosResponseBodyMediaInfos(TeaModel):
    def __init__(
        self,
        file_info_list: List[ListPublicMediaBasicInfosResponseBodyMediaInfosFileInfoList] = None,
        media_basic_info: ListPublicMediaBasicInfosResponseBodyMediaInfosMediaBasicInfo = None,
        media_id: str = None,
    ):
        # FileInfos
        self.file_info_list = file_info_list
        # BasicInfo
        self.media_basic_info = media_basic_info
        # 媒资ID
        self.media_id = media_id

    def validate(self):
        if self.file_info_list:
            for k in self.file_info_list:
                if k:
                    k.validate()
        if self.media_basic_info:
            self.media_basic_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FileInfoList'] = []
        if self.file_info_list is not None:
            for k in self.file_info_list:
                result['FileInfoList'].append(k.to_map() if k else None)
        if self.media_basic_info is not None:
            result['MediaBasicInfo'] = self.media_basic_info.to_map()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.file_info_list = []
        if m.get('FileInfoList') is not None:
            for k in m.get('FileInfoList'):
                temp_model = ListPublicMediaBasicInfosResponseBodyMediaInfosFileInfoList()
                self.file_info_list.append(temp_model.from_map(k))
        if m.get('MediaBasicInfo') is not None:
            temp_model = ListPublicMediaBasicInfosResponseBodyMediaInfosMediaBasicInfo()
            self.media_basic_info = temp_model.from_map(m['MediaBasicInfo'])
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class ListPublicMediaBasicInfosResponseBody(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        media_infos: List[ListPublicMediaBasicInfosResponseBodyMediaInfos] = None,
        next_token: str = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.max_results = max_results
        # 符合要求的媒资集合
        self.media_infos = media_infos
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        # 符合要求的媒资总数
        self.total_count = total_count

    def validate(self):
        if self.media_infos:
            for k in self.media_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        result['MediaInfos'] = []
        if self.media_infos is not None:
            for k in self.media_infos:
                result['MediaInfos'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        self.media_infos = []
        if m.get('MediaInfos') is not None:
            for k in m.get('MediaInfos'):
                temp_model = ListPublicMediaBasicInfosResponseBodyMediaInfos()
                self.media_infos.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListPublicMediaBasicInfosResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListPublicMediaBasicInfosResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListPublicMediaBasicInfosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSmartJobsRequest(TeaModel):
    def __init__(
        self,
        job_state: str = None,
        job_type: str = None,
        max_results: int = None,
        next_token: str = None,
        page_no: int = None,
        page_size: int = None,
        sort_by: str = None,
    ):
        # 任务状态
        self.job_state = job_state
        # 任务类型
        self.job_type = job_type
        # 分页大小。最大不超过100。  默认值：10
        self.max_results = max_results
        # 当前开始读取的位置
        self.next_token = next_token
        # 当前页码。默认值为1。
        self.page_no = page_no
        # 分页大小，每页显示条数。默认值为10，最大值为100。
        self.page_size = page_size
        # 排序参数，默认根据创建时间倒序
        self.sort_by = sort_by

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_state is not None:
            result['JobState'] = self.job_state
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobState') is not None:
            self.job_state = m.get('JobState')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        return self


class ListSmartJobsResponseBodySmartJobListInputConfig(TeaModel):
    def __init__(
        self,
        input_file: str = None,
        keyword: str = None,
    ):
        # 文件信息
        self.input_file = input_file
        # 关键词信息
        self.keyword = keyword

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_file is not None:
            result['InputFile'] = self.input_file
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InputFile') is not None:
            self.input_file = m.get('InputFile')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        return self


class ListSmartJobsResponseBodySmartJobListOutputConfig(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        object: str = None,
    ):
        # OSS Bucket
        self.bucket = bucket
        # OSS Object
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class ListSmartJobsResponseBodySmartJobList(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        description: str = None,
        editing_config: str = None,
        input_config: ListSmartJobsResponseBodySmartJobListInputConfig = None,
        job_id: str = None,
        job_state: str = None,
        job_type: str = None,
        modified_time: str = None,
        output_config: ListSmartJobsResponseBodySmartJobListOutputConfig = None,
        title: str = None,
        user_data: str = None,
        user_id: int = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 任务描述
        self.description = description
        # 输入配置
        self.editing_config = editing_config
        # 任务输入配置
        self.input_config = input_config
        # 任务Id
        self.job_id = job_id
        # 任务状态
        self.job_state = job_state
        # 任务类型
        self.job_type = job_type
        # 最后修改时间
        self.modified_time = modified_time
        # 任务输出配置
        self.output_config = output_config
        # 任务标题
        self.title = title
        # 用户自定义字段
        self.user_data = user_data
        # 用户Id
        self.user_id = user_id

    def validate(self):
        if self.input_config:
            self.input_config.validate()
        if self.output_config:
            self.output_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.editing_config is not None:
            result['EditingConfig'] = self.editing_config
        if self.input_config is not None:
            result['InputConfig'] = self.input_config.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_state is not None:
            result['JobState'] = self.job_state
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.output_config is not None:
            result['OutputConfig'] = self.output_config.to_map()
        if self.title is not None:
            result['Title'] = self.title
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EditingConfig') is not None:
            self.editing_config = m.get('EditingConfig')
        if m.get('InputConfig') is not None:
            temp_model = ListSmartJobsResponseBodySmartJobListInputConfig()
            self.input_config = temp_model.from_map(m['InputConfig'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobState') is not None:
            self.job_state = m.get('JobState')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('OutputConfig') is not None:
            temp_model = ListSmartJobsResponseBodySmartJobListOutputConfig()
            self.output_config = temp_model.from_map(m['OutputConfig'])
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ListSmartJobsResponseBody(TeaModel):
    def __init__(
        self,
        max_results: str = None,
        next_token: str = None,
        request_id: str = None,
        smart_job_list: List[ListSmartJobsResponseBodySmartJobList] = None,
        total_count: str = None,
    ):
        # 本次请求所返回的最大记录条数，最后一页前每页记录条数为MaxResults取值。  例如：  正例：10,10,5，反例：10,5,10
        self.max_results = max_results
        # 用来表示当前调用返回读取到的位置，空代表数据已经读取完毕。
        self.next_token = next_token
        # 请求ID。
        self.request_id = request_id
        self.smart_job_list = smart_job_list
        # 本次请求条件下的数据总量，此参数为可选参数，默认可不返回。
        self.total_count = total_count

    def validate(self):
        if self.smart_job_list:
            for k in self.smart_job_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SmartJobList'] = []
        if self.smart_job_list is not None:
            for k in self.smart_job_list:
                result['SmartJobList'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.smart_job_list = []
        if m.get('SmartJobList') is not None:
            for k in m.get('SmartJobList'):
                temp_model = ListSmartJobsResponseBodySmartJobList()
                self.smart_job_list.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListSmartJobsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListSmartJobsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListSmartJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSnapshotJobsRequest(TeaModel):
    def __init__(
        self,
        end_of_create_time: str = None,
        job_id: str = None,
        next_page_token: str = None,
        order_by: str = None,
        page_size: int = None,
        start_of_create_time: str = None,
        status: str = None,
    ):
        self.end_of_create_time = end_of_create_time
        self.job_id = job_id
        # 连续分页查询时下一页的标记
        self.next_page_token = next_page_token
        # 排序顺序：CreateTimeDesc 和 CreateTimeAsc
        self.order_by = order_by
        self.page_size = page_size
        self.start_of_create_time = start_of_create_time
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_of_create_time is not None:
            result['EndOfCreateTime'] = self.end_of_create_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_of_create_time is not None:
            result['StartOfCreateTime'] = self.start_of_create_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndOfCreateTime') is not None:
            self.end_of_create_time = m.get('EndOfCreateTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartOfCreateTime') is not None:
            self.start_of_create_time = m.get('StartOfCreateTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListSnapshotJobsResponseBodyJobsInput(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        self.media = media
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListSnapshotJobsResponseBodyJobsOutput(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        self.media = media
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListSnapshotJobsResponseBodyJobs(TeaModel):
    def __init__(
        self,
        async_: bool = None,
        count: int = None,
        create_time: str = None,
        finish_time: str = None,
        input: ListSnapshotJobsResponseBodyJobsInput = None,
        job_id: str = None,
        modified_time: str = None,
        name: str = None,
        output: ListSnapshotJobsResponseBodyJobsOutput = None,
        pipeline_id: str = None,
        status: str = None,
        submit_time: str = None,
        template_id: str = None,
        trigger_source: str = None,
        type: str = None,
    ):
        self.async_ = async_
        self.count = count
        self.create_time = create_time
        self.finish_time = finish_time
        self.input = input
        self.job_id = job_id
        self.modified_time = modified_time
        self.name = name
        self.output = output
        self.pipeline_id = pipeline_id
        self.status = status
        self.submit_time = submit_time
        self.template_id = template_id
        self.trigger_source = trigger_source
        self.type = type

    def validate(self):
        if self.input:
            self.input.validate()
        if self.output:
            self.output.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.async_ is not None:
            result['Async'] = self.async_
        if self.count is not None:
            result['Count'] = self.count
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.name is not None:
            result['Name'] = self.name
        if self.output is not None:
            result['Output'] = self.output.to_map()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.status is not None:
            result['Status'] = self.status
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.trigger_source is not None:
            result['TriggerSource'] = self.trigger_source
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Async') is not None:
            self.async_ = m.get('Async')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Input') is not None:
            temp_model = ListSnapshotJobsResponseBodyJobsInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Output') is not None:
            temp_model = ListSnapshotJobsResponseBodyJobsOutput()
            self.output = temp_model.from_map(m['Output'])
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TriggerSource') is not None:
            self.trigger_source = m.get('TriggerSource')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListSnapshotJobsResponseBody(TeaModel):
    def __init__(
        self,
        jobs: List[ListSnapshotJobsResponseBodyJobs] = None,
        next_page_token: str = None,
        request_id: str = None,
    ):
        self.jobs = jobs
        self.next_page_token = next_page_token
        # 请求ID
        self.request_id = request_id

    def validate(self):
        if self.jobs:
            for k in self.jobs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Jobs'] = []
        if self.jobs is not None:
            for k in self.jobs:
                result['Jobs'].append(k.to_map() if k else None)
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.jobs = []
        if m.get('Jobs') is not None:
            for k in m.get('Jobs'):
                temp_model = ListSnapshotJobsResponseBodyJobs()
                self.jobs.append(temp_model.from_map(k))
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListSnapshotJobsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListSnapshotJobsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListSnapshotJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSystemTemplatesRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        page_number: int = None,
        page_size: int = None,
        status: str = None,
        subtype: str = None,
        template_id: str = None,
        type: str = None,
    ):
        # 模板名称
        self.name = name
        # 分页数目
        self.page_number = page_number
        # 分页大小
        self.page_size = page_size
        # 模板状态：Normal正常，Invisible不可见，ALL全部
        self.status = status
        # 模板子类型ID
        self.subtype = subtype
        # 模板ID
        self.template_id = template_id
        # 模板类型。逗号分隔
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        if self.subtype is not None:
            result['Subtype'] = self.subtype
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Subtype') is not None:
            self.subtype = m.get('Subtype')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListSystemTemplatesResponseBodySystemTemplateList(TeaModel):
    def __init__(
        self,
        status: str = None,
        subtype: int = None,
        subtype_name: str = None,
        template_config: str = None,
        template_id: str = None,
        template_name: str = None,
        type: int = None,
        type_name: str = None,
    ):
        # 模板状态
        self.status = status
        # 模板子类型ID
        self.subtype = subtype
        # 模板子类型名称
        self.subtype_name = subtype_name
        # 模板参数
        self.template_config = template_config
        # 模板Id
        self.template_id = template_id
        # 模板名称
        self.template_name = template_name
        # 模板类型ID
        self.type = type
        # 模板类型名称
        self.type_name = type_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.subtype is not None:
            result['Subtype'] = self.subtype
        if self.subtype_name is not None:
            result['SubtypeName'] = self.subtype_name
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.type is not None:
            result['Type'] = self.type
        if self.type_name is not None:
            result['TypeName'] = self.type_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Subtype') is not None:
            self.subtype = m.get('Subtype')
        if m.get('SubtypeName') is not None:
            self.subtype_name = m.get('SubtypeName')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('TypeName') is not None:
            self.type_name = m.get('TypeName')
        return self


class ListSystemTemplatesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        system_template_list: List[ListSystemTemplatesResponseBodySystemTemplateList] = None,
        total: int = None,
    ):
        # 请求ID
        self.request_id = request_id
        # 模板信息列表
        self.system_template_list = system_template_list
        # 模板总数
        self.total = total

    def validate(self):
        if self.system_template_list:
            for k in self.system_template_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SystemTemplateList'] = []
        if self.system_template_list is not None:
            for k in self.system_template_list:
                result['SystemTemplateList'].append(k.to_map() if k else None)
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.system_template_list = []
        if m.get('SystemTemplateList') is not None:
            for k in m.get('SystemTemplateList'):
                temp_model = ListSystemTemplatesResponseBodySystemTemplateList()
                self.system_template_list.append(temp_model.from_map(k))
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSystemTemplatesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListSystemTemplatesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListSystemTemplatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTemplatesRequest(TeaModel):
    def __init__(
        self,
        create_source: str = None,
        keyword: str = None,
        page_no: int = None,
        page_size: int = None,
        sort_type: str = None,
        status: str = None,
        type: str = None,
    ):
        # 创建来源
        self.create_source = create_source
        # 搜索关键词，可以根据模板id和title搜索
        self.keyword = keyword
        # 当前页码。默认值为1。
        self.page_no = page_no
        # 分页大小，每页显示条数。默认值为10，最大值为100。
        self.page_size = page_size
        # 排序参数，默认根据创建时间倒序
        self.sort_type = sort_type
        # 模板状态
        self.status = status
        # 模板类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_type is not None:
            result['SortType'] = self.sort_type
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateSource') is not None:
            self.create_source = m.get('CreateSource')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortType') is not None:
            self.sort_type = m.get('SortType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListTemplatesResponseBodyTemplates(TeaModel):
    def __init__(
        self,
        clips_param: str = None,
        config: str = None,
        cover_url: str = None,
        create_source: str = None,
        creation_time: str = None,
        modified_source: str = None,
        modified_time: str = None,
        name: str = None,
        preview_media: str = None,
        preview_media_status: str = None,
        status: str = None,
        template_id: str = None,
        type: str = None,
    ):
        # ClipsParam
        self.clips_param = clips_param
        # 模板配置
        self.config = config
        # 封面URL
        self.cover_url = cover_url
        # 创建来源
        self.create_source = create_source
        # 创建时间
        self.creation_time = creation_time
        # 修改来源
        self.modified_source = modified_source
        # 修改时间
        self.modified_time = modified_time
        # 模板名称
        self.name = name
        # 预览素材
        self.preview_media = preview_media
        # 预览素材状态
        self.preview_media_status = preview_media_status
        # 模板状态
        self.status = status
        # 模板ID
        self.template_id = template_id
        # 模板类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clips_param is not None:
            result['ClipsParam'] = self.clips_param
        if self.config is not None:
            result['Config'] = self.config
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.modified_source is not None:
            result['ModifiedSource'] = self.modified_source
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.name is not None:
            result['Name'] = self.name
        if self.preview_media is not None:
            result['PreviewMedia'] = self.preview_media
        if self.preview_media_status is not None:
            result['PreviewMediaStatus'] = self.preview_media_status
        if self.status is not None:
            result['Status'] = self.status
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClipsParam') is not None:
            self.clips_param = m.get('ClipsParam')
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateSource') is not None:
            self.create_source = m.get('CreateSource')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('ModifiedSource') is not None:
            self.modified_source = m.get('ModifiedSource')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PreviewMedia') is not None:
            self.preview_media = m.get('PreviewMedia')
        if m.get('PreviewMediaStatus') is not None:
            self.preview_media_status = m.get('PreviewMediaStatus')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListTemplatesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        templates: List[ListTemplatesResponseBodyTemplates] = None,
        total_count: int = None,
    ):
        # 请求ID
        self.request_id = request_id
        self.templates = templates
        # 本次请求条件下的数据总量。
        self.total_count = total_count

    def validate(self):
        if self.templates:
            for k in self.templates:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Templates'] = []
        if self.templates is not None:
            for k in self.templates:
                result['Templates'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.templates = []
        if m.get('Templates') is not None:
            for k in m.get('Templates'):
                temp_model = ListTemplatesResponseBodyTemplates()
                self.templates.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListTemplatesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListTemplatesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTemplatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTranscodeJobsRequest(TeaModel):
    def __init__(
        self,
        end_of_create_time: str = None,
        job_id: str = None,
        next_page_token: str = None,
        order_by: str = None,
        page_size: int = None,
        start_of_create_time: str = None,
        status: str = None,
    ):
        # 任务创建时间筛选条件的结束时间
        self.end_of_create_time = end_of_create_time
        # 按 jobId 筛选
        self.job_id = job_id
        # 连续分页查询时下一页的标记 (第一页没有)
        self.next_page_token = next_page_token
        # 排序顺序，目前只支持两种：CreateTimeDesc 和 CreateTimeAsc
        self.order_by = order_by
        self.page_size = page_size
        # 任务创建时间筛选条件的起始时间
        self.start_of_create_time = start_of_create_time
        # 任务状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_of_create_time is not None:
            result['EndOfCreateTime'] = self.end_of_create_time
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_of_create_time is not None:
            result['StartOfCreateTime'] = self.start_of_create_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndOfCreateTime') is not None:
            self.end_of_create_time = m.get('EndOfCreateTime')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartOfCreateTime') is not None:
            self.start_of_create_time = m.get('StartOfCreateTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListTranscodeJobsResponseBodyJobsInputGroup(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        # 媒体值：
        #       type 为 OSS 时，为 url, 支持 oss 协议和 http 协议；
        #       type 为 Media 时，为媒资 id。
        self.media = media
        # 媒体对象类型 - OSS: oss文件, Media: 媒资 ID
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupOutput(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        # 媒体值：
        #       type 为 OSS 时，为 url, 支持 oss 协议和 http 协议；
        #       type 为 Media 时，为媒资 id。
        self.media = media
        # 媒体对象类型 - OSS: oss文件, Media: 媒资 ID
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarksOverwriteParamsFile(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        # 媒体值：
        #       type 为 OSS 时，为 url, 支持 oss 协议和 http 协议；
        #       type 为 Media 时，为媒资 id。
        self.media = media
        # 媒体对象类型 - OSS: oss文件, Media: 媒资 ID
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarksOverwriteParamsTimeline(TeaModel):
    def __init__(
        self,
        duration: str = None,
        start: str = None,
    ):
        # 显示时长，秒数 或者 "ToEND"
        self.duration = duration
        # 开始时间
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarksOverwriteParams(TeaModel):
    def __init__(
        self,
        dx: str = None,
        dy: str = None,
        file: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarksOverwriteParamsFile = None,
        height: str = None,
        refer_pos: str = None,
        timeline: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarksOverwriteParamsTimeline = None,
        width: str = None,
    ):
        # 水印位置，x
        self.dx = dx
        # 水印位置，y
        self.dy = dy
        # 水印文件oss路径
        self.file = file
        # 高
        self.height = height
        # 参考位置: TopLeft, TopRight, BottomLeft, BottomRight  default: TopLeft
        self.refer_pos = refer_pos
        # 显示时间设置
        self.timeline = timeline
        # 宽
        self.width = width

    def validate(self):
        if self.file:
            self.file.validate()
        if self.timeline:
            self.timeline.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dx is not None:
            result['Dx'] = self.dx
        if self.dy is not None:
            result['Dy'] = self.dy
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.height is not None:
            result['Height'] = self.height
        if self.refer_pos is not None:
            result['ReferPos'] = self.refer_pos
        if self.timeline is not None:
            result['Timeline'] = self.timeline.to_map()
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dx') is not None:
            self.dx = m.get('Dx')
        if m.get('Dy') is not None:
            self.dy = m.get('Dy')
        if m.get('File') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarksOverwriteParamsFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('ReferPos') is not None:
            self.refer_pos = m.get('ReferPos')
        if m.get('Timeline') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarksOverwriteParamsTimeline()
            self.timeline = temp_model.from_map(m['Timeline'])
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarks(TeaModel):
    def __init__(
        self,
        overwrite_params: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarksOverwriteParams = None,
        template_id: str = None,
    ):
        # 覆盖参数, 若填写会覆盖模板对应参数
        self.overwrite_params = overwrite_params
        # 模板 id
        self.template_id = template_id

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarksOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigSubtitlesOverwriteParamsFile(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        # 媒体值：
        #       type 为 OSS 时，为 url, 支持 oss 协议和 http 协议；
        #       type 为 Media 时，为媒资 id。
        self.media = media
        # 媒体对象类型 - OSS: oss文件, Media: 媒资 ID
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigSubtitlesOverwriteParams(TeaModel):
    def __init__(
        self,
        char_enc: str = None,
        file: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigSubtitlesOverwriteParamsFile = None,
        format: str = None,
    ):
        # 文件 encoding 格式
        self.char_enc = char_enc
        # 字幕文件
        self.file = file
        # 字幕文件格式
        self.format = format

    def validate(self):
        if self.file:
            self.file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.char_enc is not None:
            result['CharEnc'] = self.char_enc
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CharEnc') is not None:
            self.char_enc = m.get('CharEnc')
        if m.get('File') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigSubtitlesOverwriteParamsFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigSubtitles(TeaModel):
    def __init__(
        self,
        overwrite_params: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigSubtitlesOverwriteParams = None,
        template_id: str = None,
    ):
        # 覆盖参数, 若填写会覆盖模板对应参数
        self.overwrite_params = overwrite_params
        # 模板 id
        self.template_id = template_id

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigSubtitlesOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTextWatermarksOverwriteParams(TeaModel):
    def __init__(
        self,
        adaptive: str = None,
        border_color: str = None,
        border_width: int = None,
        content: str = None,
        font_alpha: str = None,
        font_color: str = None,
        font_name: str = None,
        font_size: int = None,
        left: str = None,
        top: str = None,
    ):
        # 根据输出视频大小调整字体 size。 true / false, default: false
        self.adaptive = adaptive
        # 边框颜色
        self.border_color = border_color
        # 边框宽度
        self.border_width = border_width
        # 水印文本，不需要 base64 encode，字符串需要 utf-8 编码
        self.content = content
        # 透明度
        self.font_alpha = font_alpha
        # 颜色
        self.font_color = font_color
        # 字体
        self.font_name = font_name
        # 字体大小
        self.font_size = font_size
        # 水印位置，距离左边距离
        self.left = left
        # 水印位置，距离上边距离
        self.top = top

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adaptive is not None:
            result['Adaptive'] = self.adaptive
        if self.border_color is not None:
            result['BorderColor'] = self.border_color
        if self.border_width is not None:
            result['BorderWidth'] = self.border_width
        if self.content is not None:
            result['Content'] = self.content
        if self.font_alpha is not None:
            result['FontAlpha'] = self.font_alpha
        if self.font_color is not None:
            result['FontColor'] = self.font_color
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.font_size is not None:
            result['FontSize'] = self.font_size
        if self.left is not None:
            result['Left'] = self.left
        if self.top is not None:
            result['Top'] = self.top
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Adaptive') is not None:
            self.adaptive = m.get('Adaptive')
        if m.get('BorderColor') is not None:
            self.border_color = m.get('BorderColor')
        if m.get('BorderWidth') is not None:
            self.border_width = m.get('BorderWidth')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('FontAlpha') is not None:
            self.font_alpha = m.get('FontAlpha')
        if m.get('FontColor') is not None:
            self.font_color = m.get('FontColor')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('FontSize') is not None:
            self.font_size = m.get('FontSize')
        if m.get('Left') is not None:
            self.left = m.get('Left')
        if m.get('Top') is not None:
            self.top = m.get('Top')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTextWatermarks(TeaModel):
    def __init__(
        self,
        overwrite_params: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTextWatermarksOverwriteParams = None,
        template_id: str = None,
    ):
        # 覆盖参数, 若填写会覆盖模板对应参数
        self.overwrite_params = overwrite_params
        # 模板 id
        self.template_id = template_id

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTextWatermarksOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsAudioVolume(TeaModel):
    def __init__(
        self,
        integrated_loudness_target: str = None,
        loudness_range_target: str = None,
        method: str = None,
        true_peak: str = None,
    ):
        # 目标音量
        self.integrated_loudness_target = integrated_loudness_target
        # 音量范围
        self.loudness_range_target = loudness_range_target
        # 音量调整方式
        self.method = method
        # 最大峰值
        self.true_peak = true_peak

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.integrated_loudness_target is not None:
            result['IntegratedLoudnessTarget'] = self.integrated_loudness_target
        if self.loudness_range_target is not None:
            result['LoudnessRangeTarget'] = self.loudness_range_target
        if self.method is not None:
            result['Method'] = self.method
        if self.true_peak is not None:
            result['TruePeak'] = self.true_peak
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IntegratedLoudnessTarget') is not None:
            self.integrated_loudness_target = m.get('IntegratedLoudnessTarget')
        if m.get('LoudnessRangeTarget') is not None:
            self.loudness_range_target = m.get('LoudnessRangeTarget')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('TruePeak') is not None:
            self.true_peak = m.get('TruePeak')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsAudio(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        channels: str = None,
        codec: str = None,
        profile: str = None,
        remove: str = None,
        samplerate: str = None,
        volume: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsAudioVolume = None,
    ):
        # 输出文件的音频码率。
        self.bitrate = bitrate
        # 声道数。
        self.channels = channels
        # 音频编解码格式，AAC、MP3、VORBIS、FLAC。
        self.codec = codec
        # 音频编码预置。
        self.profile = profile
        # 是否删除音频流。
        self.remove = remove
        # 采样率。
        self.samplerate = samplerate
        # 音量控制
        self.volume = volume

    def validate(self):
        if self.volume:
            self.volume.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.channels is not None:
            result['Channels'] = self.channels
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.samplerate is not None:
            result['Samplerate'] = self.samplerate
        if self.volume is not None:
            result['Volume'] = self.volume.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Channels') is not None:
            self.channels = m.get('Channels')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('Samplerate') is not None:
            self.samplerate = m.get('Samplerate')
        if m.get('Volume') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsAudioVolume()
            self.volume = temp_model.from_map(m['Volume'])
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsContainer(TeaModel):
    def __init__(
        self,
        format: str = None,
    ):
        # 容器格式
        self.format = format

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfigSegment(TeaModel):
    def __init__(
        self,
        duration: str = None,
        force_seg_time: str = None,
    ):
        # 切片时长
        self.duration = duration
        # 强制切片时间点
        self.force_seg_time = force_seg_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.force_seg_time is not None:
            result['ForceSegTime'] = self.force_seg_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ForceSegTime') is not None:
            self.force_seg_time = m.get('ForceSegTime')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfig(TeaModel):
    def __init__(
        self,
        segment: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfigSegment = None,
    ):
        # 切片设置
        self.segment = segment

    def validate(self):
        if self.segment:
            self.segment.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.segment is not None:
            result['Segment'] = self.segment.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Segment') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfigSegment()
            self.segment = temp_model.from_map(m['Segment'])
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsVideo(TeaModel):
    def __init__(
        self,
        abr_max: str = None,
        bitrate: str = None,
        bufsize: str = None,
        codec: str = None,
        crf: str = None,
        crop: str = None,
        fps: str = None,
        gop: str = None,
        height: str = None,
        long_short_mode: str = None,
        maxrate: str = None,
        pad: str = None,
        pix_fmt: str = None,
        preset: str = None,
        profile: str = None,
        remove: str = None,
        scan_mode: str = None,
        width: str = None,
    ):
        self.abr_max = abr_max
        # 视频平均码率。
        self.bitrate = bitrate
        # 缓冲区大小
        self.bufsize = bufsize
        # 编码格式
        self.codec = codec
        # 码率-质量控制因子。
        self.crf = crf
        # 视频画面裁切
        self.crop = crop
        # 帧率。
        self.fps = fps
        # 关键帧间最大帧数。
        self.gop = gop
        # 高。
        self.height = height
        # 是否开启横竖屏自适应（即：长短边模式）
        self.long_short_mode = long_short_mode
        # 视频码率峰值
        self.maxrate = maxrate
        # 视频贴黑边
        self.pad = pad
        # 视频颜色格式。
        self.pix_fmt = pix_fmt
        # 只有H264支持该参数
        self.preset = preset
        # 编码级别。
        self.profile = profile
        # 是否去掉视频
        self.remove = remove
        # 扫描模式。
        self.scan_mode = scan_mode
        # 宽。
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abr_max is not None:
            result['AbrMax'] = self.abr_max
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.bufsize is not None:
            result['Bufsize'] = self.bufsize
        if self.codec is not None:
            result['Codec'] = self.codec
        if self.crf is not None:
            result['Crf'] = self.crf
        if self.crop is not None:
            result['Crop'] = self.crop
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.long_short_mode is not None:
            result['LongShortMode'] = self.long_short_mode
        if self.maxrate is not None:
            result['Maxrate'] = self.maxrate
        if self.pad is not None:
            result['Pad'] = self.pad
        if self.pix_fmt is not None:
            result['PixFmt'] = self.pix_fmt
        if self.preset is not None:
            result['Preset'] = self.preset
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.remove is not None:
            result['Remove'] = self.remove
        if self.scan_mode is not None:
            result['ScanMode'] = self.scan_mode
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AbrMax') is not None:
            self.abr_max = m.get('AbrMax')
        if m.get('Bitrate') is not None:
            self.bitrate = m.get('Bitrate')
        if m.get('Bufsize') is not None:
            self.bufsize = m.get('Bufsize')
        if m.get('Codec') is not None:
            self.codec = m.get('Codec')
        if m.get('Crf') is not None:
            self.crf = m.get('Crf')
        if m.get('Crop') is not None:
            self.crop = m.get('Crop')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('LongShortMode') is not None:
            self.long_short_mode = m.get('LongShortMode')
        if m.get('Maxrate') is not None:
            self.maxrate = m.get('Maxrate')
        if m.get('Pad') is not None:
            self.pad = m.get('Pad')
        if m.get('PixFmt') is not None:
            self.pix_fmt = m.get('PixFmt')
        if m.get('Preset') is not None:
            self.preset = m.get('Preset')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Remove') is not None:
            self.remove = m.get('Remove')
        if m.get('ScanMode') is not None:
            self.scan_mode = m.get('ScanMode')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParams(TeaModel):
    def __init__(
        self,
        audio: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsAudio = None,
        container: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsContainer = None,
        mux_config: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfig = None,
        video: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsVideo = None,
    ):
        # audio 设置
        self.audio = audio
        # 封装格式设置
        self.container = container
        # 封装设置
        self.mux_config = mux_config
        # video 设置
        self.video = video

    def validate(self):
        if self.audio:
            self.audio.validate()
        if self.container:
            self.container.validate()
        if self.mux_config:
            self.mux_config.validate()
        if self.video:
            self.video.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio is not None:
            result['Audio'] = self.audio.to_map()
        if self.container is not None:
            result['Container'] = self.container.to_map()
        if self.mux_config is not None:
            result['MuxConfig'] = self.mux_config.to_map()
        if self.video is not None:
            result['Video'] = self.video.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Audio') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsAudio()
            self.audio = temp_model.from_map(m['Audio'])
        if m.get('Container') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsContainer()
            self.container = temp_model.from_map(m['Container'])
        if m.get('MuxConfig') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsMuxConfig()
            self.mux_config = temp_model.from_map(m['MuxConfig'])
        if m.get('Video') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParamsVideo()
            self.video = temp_model.from_map(m['Video'])
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscode(TeaModel):
    def __init__(
        self,
        overwrite_params: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParams = None,
        template_id: str = None,
    ):
        # 覆盖参数, 若填写会覆盖模板对应参数
        self.overwrite_params = overwrite_params
        # 模板 id
        self.template_id = template_id

    def validate(self):
        if self.overwrite_params:
            self.overwrite_params.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite_params is not None:
            result['OverwriteParams'] = self.overwrite_params.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OverwriteParams') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscodeOverwriteParams()
            self.overwrite_params = temp_model.from_map(m['OverwriteParams'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfig(TeaModel):
    def __init__(
        self,
        image_watermarks: List[ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarks] = None,
        subtitles: List[ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigSubtitles] = None,
        text_watermarks: List[ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTextWatermarks] = None,
        transcode: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscode = None,
    ):
        # 图片水印配置
        self.image_watermarks = image_watermarks
        # 字幕压制配置
        self.subtitles = subtitles
        # 文字水印配置
        self.text_watermarks = text_watermarks
        # 转码配置
        self.transcode = transcode

    def validate(self):
        if self.image_watermarks:
            for k in self.image_watermarks:
                if k:
                    k.validate()
        if self.subtitles:
            for k in self.subtitles:
                if k:
                    k.validate()
        if self.text_watermarks:
            for k in self.text_watermarks:
                if k:
                    k.validate()
        if self.transcode:
            self.transcode.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ImageWatermarks'] = []
        if self.image_watermarks is not None:
            for k in self.image_watermarks:
                result['ImageWatermarks'].append(k.to_map() if k else None)
        result['Subtitles'] = []
        if self.subtitles is not None:
            for k in self.subtitles:
                result['Subtitles'].append(k.to_map() if k else None)
        result['TextWatermarks'] = []
        if self.text_watermarks is not None:
            for k in self.text_watermarks:
                result['TextWatermarks'].append(k.to_map() if k else None)
        if self.transcode is not None:
            result['Transcode'] = self.transcode.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.image_watermarks = []
        if m.get('ImageWatermarks') is not None:
            for k in m.get('ImageWatermarks'):
                temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigImageWatermarks()
                self.image_watermarks.append(temp_model.from_map(k))
        self.subtitles = []
        if m.get('Subtitles') is not None:
            for k in m.get('Subtitles'):
                temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigSubtitles()
                self.subtitles.append(temp_model.from_map(k))
        self.text_watermarks = []
        if m.get('TextWatermarks') is not None:
            for k in m.get('TextWatermarks'):
                temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTextWatermarks()
                self.text_watermarks.append(temp_model.from_map(k))
        if m.get('Transcode') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfigTranscode()
            self.transcode = temp_model.from_map(m['Transcode'])
        return self


class ListTranscodeJobsResponseBodyJobsOutputGroup(TeaModel):
    def __init__(
        self,
        output: ListTranscodeJobsResponseBodyJobsOutputGroupOutput = None,
        process_config: ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfig = None,
    ):
        # 输出媒体配置
        self.output = output
        # 任务处理配置
        self.process_config = process_config

    def validate(self):
        if self.output:
            self.output.validate()
        if self.process_config:
            self.process_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output is not None:
            result['Output'] = self.output.to_map()
        if self.process_config is not None:
            result['ProcessConfig'] = self.process_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Output') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupOutput()
            self.output = temp_model.from_map(m['Output'])
        if m.get('ProcessConfig') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsOutputGroupProcessConfig()
            self.process_config = temp_model.from_map(m['ProcessConfig'])
        return self


class ListTranscodeJobsResponseBodyJobsScheduleConfig(TeaModel):
    def __init__(
        self,
        pipeline_id: str = None,
        priority: int = None,
    ):
        # 管道 id
        self.pipeline_id = pipeline_id
        # 任务优先级，取值范围：1~10
        self.priority = priority

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        return self


class ListTranscodeJobsResponseBodyJobs(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        finish_time: str = None,
        input_group: List[ListTranscodeJobsResponseBodyJobsInputGroup] = None,
        job_count: int = None,
        name: str = None,
        output_group: List[ListTranscodeJobsResponseBodyJobsOutputGroup] = None,
        parent_job_id: str = None,
        percent: int = None,
        request_id: str = None,
        schedule_config: ListTranscodeJobsResponseBodyJobsScheduleConfig = None,
        status: str = None,
        submit_time: str = None,
        trigger_source: str = None,
        user_data: str = None,
    ):
        # 任务创建时间
        self.create_time = create_time
        # 任务结束时间
        self.finish_time = finish_time
        # 任务输入组 (目前只支持单个输入)
        self.input_group = input_group
        # 子任务数量
        self.job_count = job_count
        # 任务名
        self.name = name
        # 任务输出组
        self.output_group = output_group
        # 主任务 id
        self.parent_job_id = parent_job_id
        # 任务完成百分比
        self.percent = percent
        # 提交任务时请求 id
        self.request_id = request_id
        # 任务调度配置
        self.schedule_config = schedule_config
        # 任务状态 Success: 有子任务成功, Fail: 所有子任务失败
        self.status = status
        # 任务提交时间
        self.submit_time = submit_time
        # 任务来源 - API, WorkFlow, Console
        self.trigger_source = trigger_source
        # 用户数据
        self.user_data = user_data

    def validate(self):
        if self.input_group:
            for k in self.input_group:
                if k:
                    k.validate()
        if self.output_group:
            for k in self.output_group:
                if k:
                    k.validate()
        if self.schedule_config:
            self.schedule_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        result['InputGroup'] = []
        if self.input_group is not None:
            for k in self.input_group:
                result['InputGroup'].append(k.to_map() if k else None)
        if self.job_count is not None:
            result['JobCount'] = self.job_count
        if self.name is not None:
            result['Name'] = self.name
        result['OutputGroup'] = []
        if self.output_group is not None:
            for k in self.output_group:
                result['OutputGroup'].append(k.to_map() if k else None)
        if self.parent_job_id is not None:
            result['ParentJobId'] = self.parent_job_id
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.schedule_config is not None:
            result['ScheduleConfig'] = self.schedule_config.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        if self.trigger_source is not None:
            result['TriggerSource'] = self.trigger_source
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        self.input_group = []
        if m.get('InputGroup') is not None:
            for k in m.get('InputGroup'):
                temp_model = ListTranscodeJobsResponseBodyJobsInputGroup()
                self.input_group.append(temp_model.from_map(k))
        if m.get('JobCount') is not None:
            self.job_count = m.get('JobCount')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.output_group = []
        if m.get('OutputGroup') is not None:
            for k in m.get('OutputGroup'):
                temp_model = ListTranscodeJobsResponseBodyJobsOutputGroup()
                self.output_group.append(temp_model.from_map(k))
        if m.get('ParentJobId') is not None:
            self.parent_job_id = m.get('ParentJobId')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScheduleConfig') is not None:
            temp_model = ListTranscodeJobsResponseBodyJobsScheduleConfig()
            self.schedule_config = temp_model.from_map(m['ScheduleConfig'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        if m.get('TriggerSource') is not None:
            self.trigger_source = m.get('TriggerSource')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class ListTranscodeJobsResponseBody(TeaModel):
    def __init__(
        self,
        jobs: List[ListTranscodeJobsResponseBodyJobs] = None,
        next_page_token: str = None,
        request_id: str = None,
    ):
        self.jobs = jobs
        self.next_page_token = next_page_token
        # 请求 id
        self.request_id = request_id

    def validate(self):
        if self.jobs:
            for k in self.jobs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Jobs'] = []
        if self.jobs is not None:
            for k in self.jobs:
                result['Jobs'].append(k.to_map() if k else None)
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.jobs = []
        if m.get('Jobs') is not None:
            for k in m.get('Jobs'):
                temp_model = ListTranscodeJobsResponseBodyJobs()
                self.jobs.append(temp_model.from_map(k))
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListTranscodeJobsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListTranscodeJobsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTranscodeJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class NotifyPreOssUploadCompleteRequest(TeaModel):
    def __init__(
        self,
        file_name: str = None,
    ):
        self.file_name = file_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_name is not None:
            result['FileName'] = self.file_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        return self


class NotifyPreOssUploadCompleteResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # RequestId
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class NotifyPreOssUploadCompleteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: NotifyPreOssUploadCompleteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = NotifyPreOssUploadCompleteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryCensorJobListRequest(TeaModel):
    def __init__(
        self,
        job_ids: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.job_ids = job_ids
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_ids is not None:
            result['JobIds'] = self.job_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobIds') is not None:
            self.job_ids = m.get('JobIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorConfigOutputFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorConfig(TeaModel):
    def __init__(
        self,
        biz_type: str = None,
        interval: str = None,
        output_file: QueryCensorJobListResponseBodyJobsCensorJobCensorConfigOutputFile = None,
        save_type: str = None,
        scenes: str = None,
    ):
        self.biz_type = biz_type
        self.interval = interval
        self.output_file = output_file
        self.save_type = save_type
        self.scenes = scenes

    def validate(self):
        if self.output_file:
            self.output_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.output_file is not None:
            result['OutputFile'] = self.output_file.to_map()
        if self.save_type is not None:
            result['SaveType'] = self.save_type
        if self.scenes is not None:
            result['Scenes'] = self.scenes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OutputFile') is not None:
            temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorConfigOutputFile()
            self.output_file = temp_model.from_map(m['OutputFile'])
        if m.get('SaveType') is not None:
            self.save_type = m.get('SaveType')
        if m.get('Scenes') is not None:
            self.scenes = m.get('Scenes')
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornCounterListCounter(TeaModel):
    def __init__(
        self,
        count: int = None,
        label: str = None,
    ):
        self.count = count
        self.label = label

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.label is not None:
            result['Label'] = self.label
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornCounterList(TeaModel):
    def __init__(
        self,
        counter: List[QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornCounterListCounter] = None,
    ):
        self.counter = counter

    def validate(self):
        if self.counter:
            for k in self.counter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Counter'] = []
        if self.counter is not None:
            for k in self.counter:
                result['Counter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.counter = []
        if m.get('Counter') is not None:
            for k in m.get('Counter'):
                temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornCounterListCounter()
                self.counter.append(temp_model.from_map(k))
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornTopListTop(TeaModel):
    def __init__(
        self,
        index: str = None,
        label: str = None,
        object: str = None,
        score: str = None,
        timestamp: str = None,
    ):
        self.index = index
        self.label = label
        self.object = object
        self.score = score
        self.timestamp = timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.label is not None:
            result['Label'] = self.label
        if self.object is not None:
            result['Object'] = self.object
        if self.score is not None:
            result['Score'] = self.score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornTopList(TeaModel):
    def __init__(
        self,
        top: List[QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornTopListTop] = None,
    ):
        self.top = top

    def validate(self):
        if self.top:
            for k in self.top:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Top'] = []
        if self.top is not None:
            for k in self.top:
                result['Top'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.top = []
        if m.get('Top') is not None:
            for k in m.get('Top'):
                temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornTopListTop()
                self.top.append(temp_model.from_map(k))
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorPornResult(TeaModel):
    def __init__(
        self,
        average_score: str = None,
        label: str = None,
        max_score: str = None,
        porn_counter_list: QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornCounterList = None,
        porn_top_list: QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornTopList = None,
        suggestion: str = None,
    ):
        self.average_score = average_score
        self.label = label
        self.max_score = max_score
        self.porn_counter_list = porn_counter_list
        self.porn_top_list = porn_top_list
        self.suggestion = suggestion

    def validate(self):
        if self.porn_counter_list:
            self.porn_counter_list.validate()
        if self.porn_top_list:
            self.porn_top_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_score is not None:
            result['AverageScore'] = self.average_score
        if self.label is not None:
            result['Label'] = self.label
        if self.max_score is not None:
            result['MaxScore'] = self.max_score
        if self.porn_counter_list is not None:
            result['PornCounterList'] = self.porn_counter_list.to_map()
        if self.porn_top_list is not None:
            result['PornTopList'] = self.porn_top_list.to_map()
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AverageScore') is not None:
            self.average_score = m.get('AverageScore')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('MaxScore') is not None:
            self.max_score = m.get('MaxScore')
        if m.get('PornCounterList') is not None:
            temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornCounterList()
            self.porn_counter_list = temp_model.from_map(m['PornCounterList'])
        if m.get('PornTopList') is not None:
            temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorPornResultPornTopList()
            self.porn_top_list = temp_model.from_map(m['PornTopList'])
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismCounterListCounter(TeaModel):
    def __init__(
        self,
        count: int = None,
        label: str = None,
    ):
        self.count = count
        self.label = label

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.label is not None:
            result['Label'] = self.label
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismCounterList(TeaModel):
    def __init__(
        self,
        counter: List[QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismCounterListCounter] = None,
    ):
        self.counter = counter

    def validate(self):
        if self.counter:
            for k in self.counter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Counter'] = []
        if self.counter is not None:
            for k in self.counter:
                result['Counter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.counter = []
        if m.get('Counter') is not None:
            for k in m.get('Counter'):
                temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismCounterListCounter()
                self.counter.append(temp_model.from_map(k))
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismTopListTop(TeaModel):
    def __init__(
        self,
        index: str = None,
        label: str = None,
        object: str = None,
        score: str = None,
        timestamp: str = None,
    ):
        self.index = index
        self.label = label
        self.object = object
        self.score = score
        self.timestamp = timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.label is not None:
            result['Label'] = self.label
        if self.object is not None:
            result['Object'] = self.object
        if self.score is not None:
            result['Score'] = self.score
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismTopList(TeaModel):
    def __init__(
        self,
        top: List[QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismTopListTop] = None,
    ):
        self.top = top

    def validate(self):
        if self.top:
            for k in self.top:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Top'] = []
        if self.top is not None:
            for k in self.top:
                result['Top'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.top = []
        if m.get('Top') is not None:
            for k in m.get('Top'):
                temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismTopListTop()
                self.top.append(temp_model.from_map(k))
        return self


class QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResult(TeaModel):
    def __init__(
        self,
        average_score: str = None,
        label: str = None,
        max_score: str = None,
        suggestion: str = None,
        terrorism_counter_list: QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismCounterList = None,
        terrorism_top_list: QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismTopList = None,
    ):
        self.average_score = average_score
        self.label = label
        self.max_score = max_score
        self.suggestion = suggestion
        self.terrorism_counter_list = terrorism_counter_list
        self.terrorism_top_list = terrorism_top_list

    def validate(self):
        if self.terrorism_counter_list:
            self.terrorism_counter_list.validate()
        if self.terrorism_top_list:
            self.terrorism_top_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average_score is not None:
            result['AverageScore'] = self.average_score
        if self.label is not None:
            result['Label'] = self.label
        if self.max_score is not None:
            result['MaxScore'] = self.max_score
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.terrorism_counter_list is not None:
            result['TerrorismCounterList'] = self.terrorism_counter_list.to_map()
        if self.terrorism_top_list is not None:
            result['TerrorismTopList'] = self.terrorism_top_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AverageScore') is not None:
            self.average_score = m.get('AverageScore')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('MaxScore') is not None:
            self.max_score = m.get('MaxScore')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('TerrorismCounterList') is not None:
            temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismCounterList()
            self.terrorism_counter_list = temp_model.from_map(m['TerrorismCounterList'])
        if m.get('TerrorismTopList') is not None:
            temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResultTerrorismTopList()
            self.terrorism_top_list = temp_model.from_map(m['TerrorismTopList'])
        return self


class QueryCensorJobListResponseBodyJobsCensorJobImageCensorResultsImageCensorResult(TeaModel):
    def __init__(
        self,
        image_bucket: str = None,
        image_location: str = None,
        image_object: str = None,
        result: str = None,
    ):
        self.image_bucket = image_bucket
        self.image_location = image_location
        self.image_object = image_object
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_bucket is not None:
            result['ImageBucket'] = self.image_bucket
        if self.image_location is not None:
            result['ImageLocation'] = self.image_location
        if self.image_object is not None:
            result['ImageObject'] = self.image_object
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageBucket') is not None:
            self.image_bucket = m.get('ImageBucket')
        if m.get('ImageLocation') is not None:
            self.image_location = m.get('ImageLocation')
        if m.get('ImageObject') is not None:
            self.image_object = m.get('ImageObject')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class QueryCensorJobListResponseBodyJobsCensorJobImageCensorResults(TeaModel):
    def __init__(
        self,
        image_censor_result: List[QueryCensorJobListResponseBodyJobsCensorJobImageCensorResultsImageCensorResult] = None,
    ):
        self.image_censor_result = image_censor_result

    def validate(self):
        if self.image_censor_result:
            for k in self.image_censor_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ImageCensorResult'] = []
        if self.image_censor_result is not None:
            for k in self.image_censor_result:
                result['ImageCensorResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.image_censor_result = []
        if m.get('ImageCensorResult') is not None:
            for k in m.get('ImageCensorResult'):
                temp_model = QueryCensorJobListResponseBodyJobsCensorJobImageCensorResultsImageCensorResult()
                self.image_censor_result.append(temp_model.from_map(k))
        return self


class QueryCensorJobListResponseBodyJobsCensorJobInput(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryCensorJobListResponseBodyJobsCensorJob(TeaModel):
    def __init__(
        self,
        barrage_censor_result: str = None,
        censor_config: QueryCensorJobListResponseBodyJobsCensorJobCensorConfig = None,
        censor_porn_result: QueryCensorJobListResponseBodyJobsCensorJobCensorPornResult = None,
        censor_terrorism_result: QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResult = None,
        code: str = None,
        creation_time: str = None,
        desc_censor_result: str = None,
        id: str = None,
        image_censor_results: QueryCensorJobListResponseBodyJobsCensorJobImageCensorResults = None,
        input: QueryCensorJobListResponseBodyJobsCensorJobInput = None,
        message: str = None,
        pipeline_id: str = None,
        result_save_object: str = None,
        state: str = None,
        title_censor_result: str = None,
        user_data: str = None,
    ):
        self.barrage_censor_result = barrage_censor_result
        self.censor_config = censor_config
        self.censor_porn_result = censor_porn_result
        self.censor_terrorism_result = censor_terrorism_result
        self.code = code
        self.creation_time = creation_time
        self.desc_censor_result = desc_censor_result
        self.id = id
        self.image_censor_results = image_censor_results
        self.input = input
        self.message = message
        self.pipeline_id = pipeline_id
        self.result_save_object = result_save_object
        self.state = state
        self.title_censor_result = title_censor_result
        self.user_data = user_data

    def validate(self):
        if self.censor_config:
            self.censor_config.validate()
        if self.censor_porn_result:
            self.censor_porn_result.validate()
        if self.censor_terrorism_result:
            self.censor_terrorism_result.validate()
        if self.image_censor_results:
            self.image_censor_results.validate()
        if self.input:
            self.input.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.barrage_censor_result is not None:
            result['BarrageCensorResult'] = self.barrage_censor_result
        if self.censor_config is not None:
            result['CensorConfig'] = self.censor_config.to_map()
        if self.censor_porn_result is not None:
            result['CensorPornResult'] = self.censor_porn_result.to_map()
        if self.censor_terrorism_result is not None:
            result['CensorTerrorismResult'] = self.censor_terrorism_result.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.desc_censor_result is not None:
            result['DescCensorResult'] = self.desc_censor_result
        if self.id is not None:
            result['Id'] = self.id
        if self.image_censor_results is not None:
            result['ImageCensorResults'] = self.image_censor_results.to_map()
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.result_save_object is not None:
            result['ResultSaveObject'] = self.result_save_object
        if self.state is not None:
            result['State'] = self.state
        if self.title_censor_result is not None:
            result['TitleCensorResult'] = self.title_censor_result
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BarrageCensorResult') is not None:
            self.barrage_censor_result = m.get('BarrageCensorResult')
        if m.get('CensorConfig') is not None:
            temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorConfig()
            self.censor_config = temp_model.from_map(m['CensorConfig'])
        if m.get('CensorPornResult') is not None:
            temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorPornResult()
            self.censor_porn_result = temp_model.from_map(m['CensorPornResult'])
        if m.get('CensorTerrorismResult') is not None:
            temp_model = QueryCensorJobListResponseBodyJobsCensorJobCensorTerrorismResult()
            self.censor_terrorism_result = temp_model.from_map(m['CensorTerrorismResult'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DescCensorResult') is not None:
            self.desc_censor_result = m.get('DescCensorResult')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ImageCensorResults') is not None:
            temp_model = QueryCensorJobListResponseBodyJobsCensorJobImageCensorResults()
            self.image_censor_results = temp_model.from_map(m['ImageCensorResults'])
        if m.get('Input') is not None:
            temp_model = QueryCensorJobListResponseBodyJobsCensorJobInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('ResultSaveObject') is not None:
            self.result_save_object = m.get('ResultSaveObject')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('TitleCensorResult') is not None:
            self.title_censor_result = m.get('TitleCensorResult')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class QueryCensorJobListResponseBodyJobs(TeaModel):
    def __init__(
        self,
        censor_job: List[QueryCensorJobListResponseBodyJobsCensorJob] = None,
    ):
        self.censor_job = censor_job

    def validate(self):
        if self.censor_job:
            for k in self.censor_job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CensorJob'] = []
        if self.censor_job is not None:
            for k in self.censor_job:
                result['CensorJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.censor_job = []
        if m.get('CensorJob') is not None:
            for k in m.get('CensorJob'):
                temp_model = QueryCensorJobListResponseBodyJobsCensorJob()
                self.censor_job.append(temp_model.from_map(k))
        return self


class QueryCensorJobListResponseBodyNonExistIds(TeaModel):
    def __init__(
        self,
        string: List[str] = None,
    ):
        self.string = string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.string is not None:
            result['String'] = self.string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('String') is not None:
            self.string = m.get('String')
        return self


class QueryCensorJobListResponseBody(TeaModel):
    def __init__(
        self,
        jobs: QueryCensorJobListResponseBodyJobs = None,
        non_exist_ids: QueryCensorJobListResponseBodyNonExistIds = None,
        request_id: str = None,
    ):
        self.jobs = jobs
        self.non_exist_ids = non_exist_ids
        self.request_id = request_id

    def validate(self):
        if self.jobs:
            self.jobs.validate()
        if self.non_exist_ids:
            self.non_exist_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.jobs is not None:
            result['Jobs'] = self.jobs.to_map()
        if self.non_exist_ids is not None:
            result['NonExistIds'] = self.non_exist_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Jobs') is not None:
            temp_model = QueryCensorJobListResponseBodyJobs()
            self.jobs = temp_model.from_map(m['Jobs'])
        if m.get('NonExistIds') is not None:
            temp_model = QueryCensorJobListResponseBodyNonExistIds()
            self.non_exist_ids = temp_model.from_map(m['NonExistIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryCensorJobListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryCensorJobListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryCensorJobListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryIProductionJobRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        job_id: str = None,
    ):
        # 幂等参数
        self.client_token = client_token
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class QueryIProductionJobResponseBodyInput(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        self.media = media
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QueryIProductionJobResponseBodyOutput(TeaModel):
    def __init__(
        self,
        media: str = None,
        type: str = None,
    ):
        self.media = media
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media is not None:
            result['Media'] = self.media
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Media') is not None:
            self.media = m.get('Media')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QueryIProductionJobResponseBodyScheduleConfig(TeaModel):
    def __init__(
        self,
        pipeline_id: str = None,
        priority: int = None,
    ):
        self.pipeline_id = pipeline_id
        self.priority = priority

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.priority is not None:
            result['Priority'] = self.priority
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        return self


class QueryIProductionJobResponseBody(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        finish_time: str = None,
        function_name: str = None,
        input: QueryIProductionJobResponseBodyInput = None,
        job_id: str = None,
        job_params: str = None,
        name: str = None,
        output: QueryIProductionJobResponseBodyOutput = None,
        output_files: List[str] = None,
        output_urls: List[str] = None,
        request_id: str = None,
        result: str = None,
        schedule_config: QueryIProductionJobResponseBodyScheduleConfig = None,
        status: str = None,
        template_id: str = None,
        user_data: str = None,
    ):
        self.create_time = create_time
        self.finish_time = finish_time
        self.function_name = function_name
        self.input = input
        self.job_id = job_id
        self.job_params = job_params
        self.name = name
        self.output = output
        self.output_files = output_files
        self.output_urls = output_urls
        # Id of the request
        self.request_id = request_id
        self.result = result
        self.schedule_config = schedule_config
        self.status = status
        self.template_id = template_id
        self.user_data = user_data

    def validate(self):
        if self.input:
            self.input.validate()
        if self.output:
            self.output.validate()
        if self.schedule_config:
            self.schedule_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.function_name is not None:
            result['FunctionName'] = self.function_name
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_params is not None:
            result['JobParams'] = self.job_params
        if self.name is not None:
            result['Name'] = self.name
        if self.output is not None:
            result['Output'] = self.output.to_map()
        if self.output_files is not None:
            result['OutputFiles'] = self.output_files
        if self.output_urls is not None:
            result['OutputUrls'] = self.output_urls
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.schedule_config is not None:
            result['ScheduleConfig'] = self.schedule_config.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('FunctionName') is not None:
            self.function_name = m.get('FunctionName')
        if m.get('Input') is not None:
            temp_model = QueryIProductionJobResponseBodyInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobParams') is not None:
            self.job_params = m.get('JobParams')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Output') is not None:
            temp_model = QueryIProductionJobResponseBodyOutput()
            self.output = temp_model.from_map(m['Output'])
        if m.get('OutputFiles') is not None:
            self.output_files = m.get('OutputFiles')
        if m.get('OutputUrls') is not None:
            self.output_urls = m.get('OutputUrls')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('ScheduleConfig') is not None:
            temp_model = QueryIProductionJobResponseBodyScheduleConfig()
            self.schedule_config = temp_model.from_map(m['ScheduleConfig'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class QueryIProductionJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryIProductionJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryIProductionJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryMediaCensorJobDetailRequest(TeaModel):
    def __init__(
        self,
        job_id: str = None,
        maximum_page_size: int = None,
        next_page_token: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.job_id = job_id
        self.maximum_page_size = maximum_page_size
        self.next_page_token = next_page_token
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.maximum_page_size is not None:
            result['MaximumPageSize'] = self.maximum_page_size
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('MaximumPageSize') is not None:
            self.maximum_page_size = m.get('MaximumPageSize')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailBarrageCensorResult(TeaModel):
    def __init__(
        self,
        label: str = None,
        rate: str = None,
        scene: str = None,
        suggestion: str = None,
    ):
        self.label = label
        self.rate = rate
        self.scene = scene
        self.suggestion = suggestion

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResultsResult(TeaModel):
    def __init__(
        self,
        label: str = None,
        rate: str = None,
        scene: str = None,
        suggestion: str = None,
    ):
        self.label = label
        self.rate = rate
        self.scene = scene
        self.suggestion = suggestion

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResults(TeaModel):
    def __init__(
        self,
        result: List[QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResultsResult] = None,
    ):
        self.result = result

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.result = []
        if m.get('Result') is not None:
            for k in m.get('Result'):
                temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResultsResult()
                self.result.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResult(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
        results: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResults = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object
        self.results = results

    def validate(self):
        if self.results:
            self.results.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        if self.results is not None:
            result['Results'] = self.results.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Results') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResultResults()
            self.results = temp_model.from_map(m['Results'])
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResults(TeaModel):
    def __init__(
        self,
        cover_image_censor_result: List[QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResult] = None,
    ):
        self.cover_image_censor_result = cover_image_censor_result

    def validate(self):
        if self.cover_image_censor_result:
            for k in self.cover_image_censor_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CoverImageCensorResult'] = []
        if self.cover_image_censor_result is not None:
            for k in self.cover_image_censor_result:
                result['CoverImageCensorResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cover_image_censor_result = []
        if m.get('CoverImageCensorResult') is not None:
            for k in m.get('CoverImageCensorResult'):
                temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResultsCoverImageCensorResult()
                self.cover_image_censor_result.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailDescCensorResult(TeaModel):
    def __init__(
        self,
        label: str = None,
        rate: str = None,
        scene: str = None,
        suggestion: str = None,
    ):
        self.label = label
        self.rate = rate
        self.scene = scene
        self.suggestion = suggestion

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailInput(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailTitleCensorResult(TeaModel):
    def __init__(
        self,
        label: str = None,
        rate: str = None,
        scene: str = None,
        suggestion: str = None,
    ):
        self.label = label
        self.rate = rate
        self.scene = scene
        self.suggestion = suggestion

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResultsCensorResult(TeaModel):
    def __init__(
        self,
        label: str = None,
        rate: str = None,
        scene: str = None,
        suggestion: str = None,
    ):
        self.label = label
        self.rate = rate
        self.scene = scene
        self.suggestion = suggestion

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResults(TeaModel):
    def __init__(
        self,
        censor_result: List[QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResultsCensorResult] = None,
    ):
        self.censor_result = censor_result

    def validate(self):
        if self.censor_result:
            for k in self.censor_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CensorResult'] = []
        if self.censor_result is not None:
            for k in self.censor_result:
                result['CensorResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.censor_result = []
        if m.get('CensorResult') is not None:
            for k in m.get('CensorResult'):
                temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResultsCensorResult()
                self.censor_result.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResultsCensorResult(TeaModel):
    def __init__(
        self,
        label: str = None,
        rate: str = None,
        scene: str = None,
        suggestion: str = None,
    ):
        self.label = label
        self.rate = rate
        self.scene = scene
        self.suggestion = suggestion

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResults(TeaModel):
    def __init__(
        self,
        censor_result: List[QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResultsCensorResult] = None,
    ):
        self.censor_result = censor_result

    def validate(self):
        if self.censor_result:
            for k in self.censor_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CensorResult'] = []
        if self.censor_result is not None:
            for k in self.censor_result:
                result['CensorResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.censor_result = []
        if m.get('CensorResult') is not None:
            for k in m.get('CensorResult'):
                temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResultsCensorResult()
                self.censor_result.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimeline(TeaModel):
    def __init__(
        self,
        censor_results: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResults = None,
        object: str = None,
        timestamp: str = None,
    ):
        self.censor_results = censor_results
        self.object = object
        self.timestamp = timestamp

    def validate(self):
        if self.censor_results:
            self.censor_results.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.censor_results is not None:
            result['CensorResults'] = self.censor_results.to_map()
        if self.object is not None:
            result['Object'] = self.object
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CensorResults') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimelineCensorResults()
            self.censor_results = temp_model.from_map(m['CensorResults'])
        if m.get('Object') is not None:
            self.object = m.get('Object')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelines(TeaModel):
    def __init__(
        self,
        video_timeline: List[QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimeline] = None,
    ):
        self.video_timeline = video_timeline

    def validate(self):
        if self.video_timeline:
            for k in self.video_timeline:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoTimeline'] = []
        if self.video_timeline is not None:
            for k in self.video_timeline:
                result['VideoTimeline'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.video_timeline = []
        if m.get('VideoTimeline') is not None:
            for k in m.get('VideoTimeline'):
                temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelinesVideoTimeline()
                self.video_timeline.append(temp_model.from_map(k))
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResult(TeaModel):
    def __init__(
        self,
        censor_results: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResults = None,
        next_page_token: str = None,
        video_timelines: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelines = None,
    ):
        self.censor_results = censor_results
        self.next_page_token = next_page_token
        self.video_timelines = video_timelines

    def validate(self):
        if self.censor_results:
            self.censor_results.validate()
        if self.video_timelines:
            self.video_timelines.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.censor_results is not None:
            result['CensorResults'] = self.censor_results.to_map()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.video_timelines is not None:
            result['VideoTimelines'] = self.video_timelines.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CensorResults') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultCensorResults()
            self.censor_results = temp_model.from_map(m['CensorResults'])
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('VideoTimelines') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResultVideoTimelines()
            self.video_timelines = temp_model.from_map(m['VideoTimelines'])
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVideoCensorConfigOutputFile(TeaModel):
    def __init__(
        self,
        bucket: str = None,
        location: str = None,
        object: str = None,
    ):
        self.bucket = bucket
        self.location = location
        self.object = object

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket is not None:
            result['Bucket'] = self.bucket
        if self.location is not None:
            result['Location'] = self.location
        if self.object is not None:
            result['Object'] = self.object
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bucket') is not None:
            self.bucket = m.get('Bucket')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Object') is not None:
            self.object = m.get('Object')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVideoCensorConfig(TeaModel):
    def __init__(
        self,
        biz_type: str = None,
        output_file: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVideoCensorConfigOutputFile = None,
        video_censor: str = None,
    ):
        self.biz_type = biz_type
        self.output_file = output_file
        self.video_censor = video_censor

    def validate(self):
        if self.output_file:
            self.output_file.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.output_file is not None:
            result['OutputFile'] = self.output_file.to_map()
        if self.video_censor is not None:
            result['VideoCensor'] = self.video_censor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('OutputFile') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVideoCensorConfigOutputFile()
            self.output_file = temp_model.from_map(m['OutputFile'])
        if m.get('VideoCensor') is not None:
            self.video_censor = m.get('VideoCensor')
        return self


class QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetail(TeaModel):
    def __init__(
        self,
        barrage_censor_result: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailBarrageCensorResult = None,
        code: str = None,
        cover_image_censor_results: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResults = None,
        creation_time: str = None,
        desc_censor_result: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailDescCensorResult = None,
        finish_time: str = None,
        input: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailInput = None,
        job_id: str = None,
        message: str = None,
        pipeline_id: str = None,
        state: str = None,
        suggestion: str = None,
        title_censor_result: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailTitleCensorResult = None,
        user_data: str = None,
        vensor_censor_result: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResult = None,
        video_censor_config: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVideoCensorConfig = None,
    ):
        self.barrage_censor_result = barrage_censor_result
        self.code = code
        self.cover_image_censor_results = cover_image_censor_results
        self.creation_time = creation_time
        self.desc_censor_result = desc_censor_result
        self.finish_time = finish_time
        self.input = input
        self.job_id = job_id
        self.message = message
        self.pipeline_id = pipeline_id
        self.state = state
        self.suggestion = suggestion
        self.title_censor_result = title_censor_result
        self.user_data = user_data
        self.vensor_censor_result = vensor_censor_result
        self.video_censor_config = video_censor_config

    def validate(self):
        if self.barrage_censor_result:
            self.barrage_censor_result.validate()
        if self.cover_image_censor_results:
            self.cover_image_censor_results.validate()
        if self.desc_censor_result:
            self.desc_censor_result.validate()
        if self.input:
            self.input.validate()
        if self.title_censor_result:
            self.title_censor_result.validate()
        if self.vensor_censor_result:
            self.vensor_censor_result.validate()
        if self.video_censor_config:
            self.video_censor_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.barrage_censor_result is not None:
            result['BarrageCensorResult'] = self.barrage_censor_result.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.cover_image_censor_results is not None:
            result['CoverImageCensorResults'] = self.cover_image_censor_results.to_map()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.desc_censor_result is not None:
            result['DescCensorResult'] = self.desc_censor_result.to_map()
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.input is not None:
            result['Input'] = self.input.to_map()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.message is not None:
            result['Message'] = self.message
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.state is not None:
            result['State'] = self.state
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.title_censor_result is not None:
            result['TitleCensorResult'] = self.title_censor_result.to_map()
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.vensor_censor_result is not None:
            result['VensorCensorResult'] = self.vensor_censor_result.to_map()
        if self.video_censor_config is not None:
            result['VideoCensorConfig'] = self.video_censor_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BarrageCensorResult') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailBarrageCensorResult()
            self.barrage_censor_result = temp_model.from_map(m['BarrageCensorResult'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CoverImageCensorResults') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailCoverImageCensorResults()
            self.cover_image_censor_results = temp_model.from_map(m['CoverImageCensorResults'])
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DescCensorResult') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailDescCensorResult()
            self.desc_censor_result = temp_model.from_map(m['DescCensorResult'])
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('Input') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailInput()
            self.input = temp_model.from_map(m['Input'])
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('TitleCensorResult') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailTitleCensorResult()
            self.title_censor_result = temp_model.from_map(m['TitleCensorResult'])
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('VensorCensorResult') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVensorCensorResult()
            self.vensor_censor_result = temp_model.from_map(m['VensorCensorResult'])
        if m.get('VideoCensorConfig') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetailVideoCensorConfig()
            self.video_censor_config = temp_model.from_map(m['VideoCensorConfig'])
        return self


class QueryMediaCensorJobDetailResponseBody(TeaModel):
    def __init__(
        self,
        media_censor_job_detail: QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetail = None,
        request_id: str = None,
    ):
        self.media_censor_job_detail = media_censor_job_detail
        self.request_id = request_id

    def validate(self):
        if self.media_censor_job_detail:
            self.media_censor_job_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_censor_job_detail is not None:
            result['MediaCensorJobDetail'] = self.media_censor_job_detail.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaCensorJobDetail') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBodyMediaCensorJobDetail()
            self.media_censor_job_detail = temp_model.from_map(m['MediaCensorJobDetail'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class QueryMediaCensorJobDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryMediaCensorJobDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryMediaCensorJobDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RefreshUploadMediaRequest(TeaModel):
    def __init__(
        self,
        media_id: str = None,
    ):
        self.media_id = media_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        return self


class RefreshUploadMediaResponseBody(TeaModel):
    def __init__(
        self,
        media_id: str = None,
        request_id: str = None,
        upload_address: str = None,
        upload_auth: str = None,
    ):
        self.media_id = media_id
        # RequestId
        self.request_id = request_id
        self.upload_address = upload_address
        self.upload_auth = upload_auth

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.upload_address is not None:
            result['UploadAddress'] = self.upload_address
        if self.upload_auth is not None:
            result['UploadAuth'] = self.upload_auth
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UploadAddress') is not None:
            self.upload_address = m.get('UploadAddress')
        if m.get('UploadAuth') is not None:
            self.upload_auth = m.get('UploadAuth')
        return self


class RefreshUploadMediaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: RefreshUploadMediaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = RefreshUploadMediaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RegisterMediaInfoRequest(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        cate_id: int = None,
        client_token: str = None,
        cover_url: str = None,
        description: str = None,
        input_url: str = None,
        media_tags: str = None,
        media_type: str = None,
        overwrite: bool = None,
        register_config: str = None,
        title: str = None,
        user_data: str = None,
    ):
        # 媒资业务类型
        self.business_type = business_type
        self.cate_id = cate_id
        # 客户端token
        self.client_token = client_token
        # 封面图，仅视频媒资有效
        self.cover_url = cover_url
        # 描述
        self.description = description
        # 媒资媒体url
        self.input_url = input_url
        # 标签,如果有多个标签用逗号隔开
        self.media_tags = media_tags
        # 媒资媒体类型
        self.media_type = media_type
        # 是否覆盖已有媒资
        self.overwrite = overwrite
        # 注册媒资的配置
        self.register_config = register_config
        # 标题
        self.title = title
        # 用户数据，最大1024字节
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.cate_id is not None:
            result['CateId'] = self.cate_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.description is not None:
            result['Description'] = self.description
        if self.input_url is not None:
            result['InputURL'] = self.input_url
        if self.media_tags is not None:
            result['MediaTags'] = self.media_tags
        if self.media_type is not None:
            result['MediaType'] = self.media_type
        if self.overwrite is not None:
            result['Overwrite'] = self.overwrite
        if self.register_config is not None:
            result['RegisterConfig'] = self.register_config
        if self.title is not None:
            result['Title'] = self.title
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('CateId') is not None:
            self.cate_id = m.get('CateId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InputURL') is not None:
            self.input_url = m.get('InputURL')
        if m.get('MediaTags') is not None:
            self.media_tags = m.get('MediaTags')
        if m.get('MediaType') is not None:
            self.media_type = m.get('MediaType')
        if m.get('Overwrite') is not None:
            self.overwrite = m.get('Overwrite')
        if m.get('RegisterConfig') is not None:
            self.register_config = m.get('RegisterConfig')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class RegisterMediaInfoResponseBody(TeaModel):
    def __init__(
        self,
        media_id: str = None,
        request_id: str = None,
    ):
        # ICE媒资ID
        self.media_id = media_id
        # 请求ID
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RegisterMediaInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: RegisterMediaInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = RegisterMediaInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RegisterMediaStreamRequest(TeaModel):
    def __init__(
        self,
        input_url: str = None,
        media_id: str = None,
        user_data: str = None,
    ):
        self.input_url = input_url
        self.media_id = media_id
        self.user_data = user_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_url is not None:
            result['InputURL'] = self.input_url
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InputURL') is not None:
            self.input_url = m.get('InputURL')
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class RegisterMediaStreamResponseBody(TeaModel):
    def __init__(
        self,
        media_id: str = None,
        request_id: str = None,
    ):
        self.media_id = media_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.media_id is not None:
            result['MediaId'] = self.media_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MediaId') is not None:
            self.media_id = m.get('MediaId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RegisterMediaStreamResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: RegisterMediaStreamResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = RegisterMediaStreamResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SearchEditingProjectRequest(TeaModel):
    def __init__(
        self,
        create_source: str = None,
        end_time: str = None,
        max_results: int = None,
        next_token: str = None,
        project_type: str = None,
        sort_by: str = None,
        start_time: str = None,
        status: str = None,
        template_type: str = None,
    ):
        # 创建来源
        self.create_source = create_source
        # CreationTime（创建时间）的结束时间
        self.end_time = end_time
        # 分页参数
        self.max_results = max_results
        # 分页参数
        self.next_token = next_token
        self.project_type = project_type
        # 结果排序方式
        self.sort_by = sort_by
        # CreateTime（创建时间）的开始时间
        self.start_time = start_time
        # 云剪辑工程状态。多个用逗号分隔
        self.status = status
        # 模板类型
        self.template_type = template_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.project_type is not None:
            result['ProjectType'] = self.project_type
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateSource') is not None:
            self.create_source = m.get('CreateSource')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('ProjectType') is not None:
            self.project_type = m.get('ProjectType')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        return self


class SearchEditingProjectResponseBodyProjectList(TeaModel):
    def __init__(
        self,
        business_config: str = None,
        business_status: str = None,
        cover_url: str = None,
        create_source: str = None,
        create_time: str = None,
        description: str = None,
        duration: int = None,
        error_code: str = None,
        error_message: str = None,
        modified_source: str = None,
        modified_time: str = None,
        project_id: str = None,
        project_type: str = None,
        status: str = None,
        template_type: str = None,
        timeline: str = None,
        title: str = None,
    ):
        self.business_config = business_config
        self.business_status = business_status
        # 云剪辑工程封面
        self.cover_url = cover_url
        # 创建来源
        self.create_source = create_source
        # 云剪辑工程创建时间
        self.create_time = create_time
        # 云剪辑工程描述
        self.description = description
        # 云剪辑工程总时长
        self.duration = duration
        # 云剪辑工程合成失败的错误码
        self.error_code = error_code
        # 云剪辑工程合成失败的消息
        self.error_message = error_message
        # 最后一次修改来源
        self.modified_source = modified_source
        # 云剪辑工程最新修改时间
        self.modified_time = modified_time
        # 云剪辑工程ID
        self.project_id = project_id
        self.project_type = project_type
        # 云剪辑工程状态
        self.status = status
        # 模板类型
        self.template_type = template_type
        # 云剪辑工程时间线
        self.timeline = timeline
        # 云剪辑工程标题
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_config is not None:
            result['BusinessConfig'] = self.business_config
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        if self.cover_url is not None:
            result['CoverURL'] = self.cover_url
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.modified_source is not None:
            result['ModifiedSource'] = self.modified_source
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_type is not None:
            result['ProjectType'] = self.project_type
        if self.status is not None:
            result['Status'] = self.status
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        if self.timeline is not None:
            result['Timeline'] = self.timeline
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessConfig') is not None:
            self.business_config = m.get('BusinessConfig')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        if m.get('CoverURL') is not None:
            self.cover_url = m.get('CoverURL')
        if m.get('CreateSource') is not None:
            self.create_source = m.get('CreateSource')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ModifiedSource') is not None:
            self.modified_source = m.get('ModifiedSource')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectType') is not None:
            self.project_type = m.get('ProjectType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        if m.get('Timeline') is not None:
            self.timeline = m.get('Timeline')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class SearchEditingProjectResponseBody(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        project_list: List[SearchEditingProjectResponseBodyProjectList] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # 云剪辑工程总数
        self.max_results = max_results
        self.next_token = next_token
        # 云剪辑工程列表
        self.project_list = project_list
        # Id of the request
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.project_list:
            for k in self.project_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        result['ProjectList'] = []
        if self.project_list is not None:
            for k in self.project_list:
                result['ProjectList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        self.project_list = []
        if m.get('ProjectList') is not None:
            for k in m.get('ProjectList'):
                temp_model = SearchEditingProjectResponseBodyProjectList()
                self.project_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class SearchEditingProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: SearchEditingProjectResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SearchEditingProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SearchMediaRequest(TeaModel):
    def __init__(
        self,
        entity_id: str = None,
        match: str = None,
        page_no: int = None,
        page_size: int = None,
        sort_by: str = None,
    ):
        # 实体Id
        self.entity_id = entity_id
        # 过滤条件
        self.match = match
        # 当前页码。默认值为1
        self.page_no = page_no
        # 每页返回的数据条数。默认值为10，最大值为100
        self.page_size = page_size
        # 排序字段和排序顺序。多个使用英文逗号（,）分隔
        self.sort_by = sort_by

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.match is not None:
            result['Match'] = self.match
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_by is not None:
            result['SortBy'] = self.sort_by
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('Match') is not None:
            self.match = m.get('Match')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortBy') is not None:
            self.sort_by = m.get('SortBy')
        return self


class SearchMediaResponseBodyMediaInfoListFileInfoListFileBasicInfo(TeaModel):
    def __init__(
        self,
        bitrate: str = None,
        create_time: str = None,
        duration: str = None,
        file_name: str = None,
        file_size: str = None,
        file_status: str = None,
        file_type: str = None,
        file_url: str = None,
        format_name: str = None,
        height: str = None,
        modified_time: str = None,
        region: str = None,
        width: str = None,
    ):
        # 码率
        self.bitrate = bitrate
        self.create_time = create_time
        # 时长
        self.duration = duration
        # 文件名
        self.file_name = file_name
        # 文件大小（字节）
        self.file_size = file_size
        # 文件状态
        self.file_status = file_status
        self.file_type = file_type
        # 文件oss地址
        self.file_url = file_url
        # 封装格式
        self.format_name = format_name
        # 高
        self.height = height
        self.modified_time = modified_time
        # 文件存储区域
        self.region = region
        # 宽
        self.width = width

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bitrate is not None:
            result['Bitrate'] = self.bitrate
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_status is not None:
            result['FileStatus'] = self.file_status
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.format_name is not None:
            result['FormatName'] = self.format_name
        if self.height is not None:
            result['Height'] = self.height
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.region is not None:
            result['Region'] = self.region
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m: dict = None):
        m = m or di